using GLib;
using Gtk;
using Gdk;
using Hildon;
using Osso;

public string apptitle;
public string exttext;
public string filename;

static void println (string str) {
	stdout.printf ("%s\n", str);
}

public class mainProgram : Hildon.Program {
        private Hildon.Window window;
        private Label label;
        private Pid pid;
        
	construct {
                window = new Hildon.Window ();
		window.set_icon_from_file ("/usr/share/pixmaps/"+apptitle.down()+".png");
                window.destroy += Gtk.main_quit;
                add_window (window);
                
		label = new Label(exttext);
		window.add(label);

                Environment.set_application_name (apptitle);
                window.map_event += activate;
                
                window.show_all();
	}
		
	private bool activate() {
	        string[] buf = new string[1];

		buf[0] = filename;
	        Process.spawn_async( null, buf, null, SpawnFlags.DO_NOT_REAP_CHILD, null, out this.pid );
		ChildWatch.add (this.pid, child_exited);
				
		return false;
	}

	private void child_exited (Pid pid, int status) {
		Gtk.main_quit();
	}

        static int main (string[] args) {
                Osso.Context ctx;

                Gtk.init (ref args);
                
                apptitle = args[1];
                filename = args[2];
                exttext = args[3];
                
                ctx = new Osso.Context(apptitle, "0.2", false, null);
                if (ctx.display_state_on() != Osso.Error.OK)
                    println("Error: Osso Initialize failed.\n");
                    
                var prg = new mainProgram ();
                Gtk.main();
                
                return 0;
        }
}