class PlaylistMenu:
    def __init__(self, xml):
        self._w = xml.get_object("playlist_menu")

        self.view = None

        xml.get_object("playlist_rename").connect("activate", self._rename)
        xml.get_object("playlist_add").connect("activate", self._add)
        xml.get_object("playlist_delete").connect("activate", self._remove)

    def _rename(self, caller):
        self.view.label.edit_name()
    
    def _add(self, caller):
        self.view.add()
    
    def _remove(self, caller):
        self.view.remove()

    def popup(self, *args):
        self._w.popup(*args)

class SongMenu:
    def __init__(self, config, player, dw, xml):
        self._w = xml.get_object("context_menu")
        
        self.song = None
        self.playlist = None
        self.remove_act = None
        self.add_act = None
        self._details = dw
            
        self._config = config
        
        enq = xml.get_object("play_next")
        enq.connect("activate", self._jump_next_to, player)
                
        bar = xml.get_object("view_artist")
        bar.connect("activate", self._browse_artist)
        
        bal = xml.get_object("view_album")
        bal.connect("activate", self._browse_album)
        
        atc = xml.get_object("add_to_current")
        atc.connect("activate", self._add_to_current)

        self.rem = xml.get_object("remove_song")
        self.rem.connect("activate", self._remove)

        details = xml.get_object("view_details")
        details.connect("activate", self._display_details)
    
    def _add_to_current(self, *args):
        self.add_act()
        
    def popup(self, *args):
        self._w.popup(*args)

    def _remove(self, *args):
        self.remove_act()

    def _jump_next_to(self, caller, player):
        player.playlist.jump_to = (self.playlist, self.song)
        
    def _browse_artist(self, *args):
        self._config["search-artist"] = str(self.song["artist"])
        self._config["search-album"] = "" 
        self._config["is-browser"] = True
        self._config.notify("is-browser")
        
        # FIXME: Maemo issue
        self._config.notify("search-artist")
        self._config.notify("search-album")

    def _browse_album(self, *args):
        self._config["search-artist"] = ""
        self._config["search-album"] = str(self.song["album"])
        self._config["is-browser"] = True
        self._config.notify("is-browser")

        # FIXME: Maemo issue
        self._config.notify("search-artist")
        self._config.notify("search-album")
 
    def _display_details(self, *args):
        self._details.set_data(self.song)
        self._details.show_all()
