import os
import os.path
import commands

xdg_cache_home = os.path.expanduser("~/.cache")
xdg_data_home = ""

VERSION = "0.6.0"

IS_MAEMO = commands.getoutput("uname -m")[0:3] == "arm"

# device specific settings
if IS_MAEMO:
    MAX_VOL = 10.0
else:
    MAX_VOL = 2.0

KNOWN_EXTS = ("mp3", "ogg", "oga", "mp4", "m4a", "wma", "wav")

data_path = "data/"

if not os.path.exists(data_path):
    data_path = "/usr/share/youamp/"

# select a appropriate media-art  dir
# try non empty sd-cards before writing to flash
media_art_dirs = ["/media/mmc1/.media-art/", "/media/mmc2/.media-art/", xdg_cache_home+"/media-art/"]

media_art = None

for p in media_art_dirs:
    if os.path.exists(p):
        media_art = p
        break

if media_art is None:
    for p in media_art_dirs:
        dir = os.path.split(p[:-1])[0]
        if len(os.listdir(dir)) > 0: # strip last slash so we get the right dir
            os.makedirs(p)
            media_art = p
            break

db_file = os.path.expanduser("~/.musicdb")
