import sqlite3
import gst
import gobject
import os
import sys
import thread

import mutagen
import mutagen.easyid3

from gobject import GObject
from youamp import known_exts, db_file
from mutagen.id3 import ID3NoHeaderError, ID3BadUnsynchData

class Indexer(GObject):
    __gsignals__ = {"update-complete": (gobject.SIGNAL_RUN_LAST, gobject.TYPE_NONE, (bool,))}

    def __init__(self):
        GObject.__init__(self)

    # start update thread
    def update(self, folder):
        thread.start_new_thread(self._update, (folder,))

    def _get_files(self, folder):
        filelist = []

        for root, dirs, files in os.walk(folder):
            for f in files:
                if f.lower().endswith(known_exts):
                    uri = "file://"+os.path.join(root, f)
                    uri = uri.replace("%", "%25") #escape the uri escape char
                    filelist.append(uri)

        return filelist

    def _update(self, folder):
        # local connection, so we can run as thread
        con = sqlite3.connect(db_file)

        disc_files = self._get_files(folder)
        db_files = con.execute("SELECT uri FROM songs").fetchall()

        updated = len(disc_files) != len(db_files)

        for uri, in db_files:
            try:
                disc_files.remove(str(uri))   # convert unicode
            except ValueError:
                con.execute("DELETE FROM songs WHERE uri = ?", (uri,))
                print "Removed: %s" % uri

        # add new files
        for uri in disc_files:
            song = {"title": "None", "artist": "None", "album": "None", "genre": "None", "tracknumber": 0}

            path = gst.uri_get_location(uri)

            if path.lower().endswith("mp3"):
                try:
                    f = mutagen.easyid3.EasyID3(path)
                except (ID3NoHeaderError, ID3BadUnsynchData):
                    sys.stderr.write("Bad ID3 Header: %s\n" % path)
                    f = {}
                except IOError, e:
                    sys.stderr.write(str(e)+"\n")
                    continue
            else:
                try:
                    f = mutagen.File(path)
                except:
                    sys.stderr.write("Skipped %s, error in Mutagen\n" % path)
                    continue

            if f is None:
                sys.stderr.write("Not a media file, skipping: %s\n" % path)
                continue

            for k, v in f.items():
                # FIXME what if v is not a list
                try:
                    v = str(", ".join(v))   # flatten value
                except TypeError:
                    sys.stderr.write("wrong type for %s in %s\n" % (k, path))
                    continue

                if k == "tracknumber":
                    try:
                        slash = v.index("/")
                        v = v[0:slash]
                    except ValueError:
                        pass

                song[k] = v

            # no visible tags -> set title = filename
            if song["title"] == "None" and \
               song["artist"] == "None" and \
               song["album"] == "None":
                    fname = uri.rindex("/")
                    fnend = uri.rindex(".")
                    song["title"] = uri[fname+1:fnend]
            else:
                # sanitise tags
                for k in ("title", "artist", "album"):
                    song[k] = song[k].strip()

            mtime = os.path.getmtime(path)

            # sqlite wants only unicode strings
            for k, v in song.iteritems():
                try:
                    song[k] = unicode(v)
                except UnicodeDecodeError:
                    song[k] = unicode("")

            # store metadata in database (uri, title, artist, album, genre, tracknumber, date)
            con.execute("INSERT INTO songs VALUES (?, ?, ?, ?, ?, ?, 0, datetime(?, 'unixepoch'))", \
                (unicode(uri), song["title"], song["artist"], song["album"], song["genre"], song["tracknumber"], mtime))

            print "Added: %s" % uri

        con.commit()
        con.close()
        self.emit("update-complete", updated)
