import gtk
from youamp.ui.detailswindow import DetailsWindow

class PopupMenu(gtk.Menu):
    def __init__(self, config, player):
        gtk.Menu.__init__(self)

        self.song = None
        self._details = DetailsWindow.get_instance()
            
        self._config = config
        
        enq = gtk.ImageMenuItem(_("Play this next"))
        enq.set_image(gtk.image_new_from_stock(gtk.STOCK_JUMP_TO, gtk.ICON_SIZE_MENU))
        enq.connect("activate", self._jump_next_to, player)  
        self.append(enq)
        
        self.append(gtk.SeparatorMenuItem())
        
        bar = gtk.MenuItem(_("View this Artist"))
        bar.connect("activate", self._browse_artist)
        self.append(bar)
        
        bal = gtk.MenuItem(_("View this Album"))
        bal.connect("activate", self._browse_album)
        self.append(bal)
        
        self.append(gtk.SeparatorMenuItem())
        
        details = gtk.ImageMenuItem(_("Details"))
        details.set_image(gtk.image_new_from_stock(gtk.STOCK_INFO, gtk.ICON_SIZE_MENU))
        details.connect("activate", self._display_details)
        self.append(details)
        
        self.show_all()
    
    def _jump_next_to(self, caller, player):
        player.jump_to = self.song
        
    def _browse_artist(self, *args):
        self._config["search-artist"] = str(self.song["artist"])
        self._config["search-album"] = "" 
        self._config["is-browser"] = True
        self._config.notify("is-browser")
        
        # FIXME: Maemo issue
        self._config.notify("search-artist")
        self._config.notify("search-album")

    def _browse_album(self, *args):
        self._config["search-artist"] = str(self.song["artist"])
        self._config["search-album"] = str(self.song["album"])
        self._config["is-browser"] = True
        self._config.notify("is-browser")
        
        # FIXME: Maemo issue
        self._config.notify("search-artist")
        self._config.notify("search-album")
 
    def _display_details(self, *args):        
        self._details.set_data(self.song)
        self._details.cshow()