import gtk
from youamp.ui.detailswindow import DetailsWindow

class PopupMenu(gtk.Menu):
    def __init__(self, config):
        gtk.Menu.__init__(self)

        self._song = None
        self._details = DetailsWindow.get_instance()
            
        self._config = config
        
        #enq = gtk.ImageMenuItem(_("Add to Play Queue"))
        #enq.set_image(gtk.image_new_from_stock(gtk.STOCK_ADD, gtk.ICON_SIZE_MENU))    
        #self.append(enq)
        
        #self.append(gtk.SeparatorMenuItem())
        
        bar = gtk.MenuItem(_("View this Artist"))
        bar.connect("activate", self._browse_artist)
        self.append(bar)
        
        bal = gtk.MenuItem(_("View this Album"))
        bal.connect("activate", self._browse_album)
        self.append(bal)
        
        self.append(gtk.SeparatorMenuItem())
        
        details = gtk.ImageMenuItem(_("Details"))
        details.set_image(gtk.image_new_from_stock(gtk.STOCK_INFO, gtk.ICON_SIZE_MENU))
        details.connect("activate", self._display_details)
        self.append(details)
        
        self.show_all()
    
    def _browse_artist(self, *args):
        self._config["search-artist"] = str(self._song["artist"])
        self._config["search-album"] = "" 
        self._config["is-browser"] = True
        self._config.notify("is-browser")
        
        # FIXME: Maemo issue
        self._config.notify("search-artist")
        self._config.notify("search-album")

    def _browse_album(self, *args):
        self._config["search-artist"] = str(self._song["artist"])
        self._config["search-album"] = str(self._song["album"])
        self._config["is-browser"] = True
        self._config.notify("is-browser")
        
        # FIXME: Maemo issue
        self._config.notify("search-artist")
        self._config.notify("search-album")
 
    def _display_details(self, *args):        
        self._details.set_data(self._song)
        self._details.cshow()