import gtk
import pango

import os.path


class DetailsView(gtk.Window):
    def __init__(self, music_dir):
        gtk.Window.__init__(self)
    
        self.set_type_hint(gtk.gdk.WINDOW_TYPE_HINT_DIALOG)
        self.set_default_size(600, -1)
        
        self._music_dir = music_dir
        self._data = None
        self._transl = {"title": _("Title"), "artist": _("Artist"), "album": _("Album")}
        
        ebox = gtk.EventBox()
        self.add(ebox)
        
        vbox = gtk.VBox()
        vbox.set_spacing(5)
        ebox.add(vbox)
        
        # content
        hbox = gtk.HBox()
        hbox.set_spacing(5)
        vbox.pack_start(hbox)
        
        self._cover = gtk.Image()
        hbox.pack_start(self._cover, expand=False)
        
        dbox = gtk.VBox()
        hbox.pack_start(dbox)
        
        self._data = {}
        
        for k, tk in self._transl.iteritems():
            row, self._data[k] = self._data_row(tk)
            dbox.pack_start(row, expand=False)
            
        row, self._loc = self._data_row(_("Location"))
        dbox.pack_start(row, expand=False)
        
        ebox.connect("button-release-event", self.hide_on_delete)     
        self.connect("delete-event", self.hide_on_delete)
    
    def _data_row(self, tk):
        row = gtk.HBox()
        
        kl = gtk.Label()
        kl.set_markup("<b>%s</b>" % tk)
        kl.set_size_request(100, -1)
        kl.set_alignment(0, 0.5)
        row.pack_start(kl, expand=False)
        
        dlabel = gtk.Label()
        dlabel.set_ellipsize(pango.ELLIPSIZE_END)
        dlabel.set_alignment(0, 0.5)
        #dlabel.set_selectable(True)
        row.pack_start(dlabel)
        
        return row, dlabel
            
    def set_data(self, song):        
        self.set_title(_("Details for %s") % song["title"])
        
        cover_file = song.cover_uri()
        
        if cover_file is not None:
            pb = gtk.gdk.pixbuf_new_from_file_at_size(cover_file, 300, 300)
            self._cover.set_from_pixbuf(pb)
        else:
            self._cover.set_from_pixbuf(None)
        
        for k, l in self._data.iteritems():
            l.set_text(song[k])
        
        self._loc.set_text(song.uri[7:])
        
    
class PopupMenu(gtk.Menu):
    def __init__(self, config):
        gtk.Menu.__init__(self)

        self._song = None
        self._details = None
        self._config = config
        
        #enq = gtk.ImageMenuItem(_("Add to Play Queue"))
        #enq.set_image(gtk.image_new_from_stock(gtk.STOCK_ADD, gtk.ICON_SIZE_MENU))    
        #self.append(enq)
        
        #self.append(gtk.SeparatorMenuItem())
        
        bar = gtk.MenuItem(_("View this Artist"))
        bar.connect("activate", self._browse_artist)
        self.append(bar)
        
        bal = gtk.MenuItem(_("View this Album"))
        bal.connect("activate", self._browse_album)
        self.append(bal)
        
        self.append(gtk.SeparatorMenuItem())
        
        details = gtk.ImageMenuItem(_("Details"))
        details.set_image(gtk.image_new_from_stock(gtk.STOCK_INFO, gtk.ICON_SIZE_MENU))
        details.connect("activate", self._display_details)
        self.append(details)
        
        self.show_all()
    
    def _browse_artist(self, *args):
        self._config["search-artist"] = str(self._song["artist"])
        self._config["search-album"] = "" 
        self._config["is-browser"] = True
        self._config.notify("is-browser")
        
        # FIXME: Maemo issue
        self._config.notify("search-artist")
        self._config.notify("search-album")

    def _browse_album(self, *args):
        self._config["search-artist"] = str(self._song["artist"])
        self._config["search-album"] = str(self._song["album"])
        self._config["is-browser"] = True
        self._config.notify("is-browser")
        
        # FIXME: Maemo issue
        self._config.notify("search-artist")
        self._config.notify("search-album")
 
    def _display_details(self, *args):
        if self._details is None:
            self._details = DetailsView(self._config["music-folder"])
        
        self._details.set_data(self._song)
        self._details.show_all()