import gtk
#import gnome
import gtk.gdk
from youamp import VERSION, IS_MAEMO

GPLv3 = """YouAmp Music Player

Copyright (C) 2008 Pavel Rojtberg

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>."""

class AboutDialog(gtk.AboutDialog):
    def __init__(self, parent):
        gtk.AboutDialog.__init__(self)
        
        #gtk.about_dialog_set_url_hook(self.on_url)
        self.set_transient_for(parent)
        
        self.set_name("YouAmp")
        self.set_version(VERSION)
        #self.set_website("http://www.madman2k.net/article/108")
        #self.set_website_label("YouAmp Website")
        self.set_copyright("Copyright (C) 2008 Pavel Rojtberg")
        self.set_license(GPLv3)
        self.set_authors(("Pavel Rojtberg",))
        self.set_artists(("Pavel Rojtberg", "Tango Icon Team"))
        self.set_translator_credits(_("translator-credits"))
        self.set_comments("A lightweight Music Player for the Internet Tablet")
        
        if IS_MAEMO:
            logo = gtk.gdk.pixbuf_new_from_file("/usr/share/pixmaps/youamp.png")
            self.set_logo(logo)
            
        self.connect("response", self._on_close)
        self.connect("delete-event", self._on_close)

    #def on_url(self, caller, link):
    #    gnome.url_show(link)
    
    def _on_close(self, caller, event):
        self.hide()
        return True
