import gtk
import gobject
import hildon

from youamp import IS_MAEMO, img_path

class Controls(gtk.HBox):
    def __init__(self, player, config):
        gtk.HBox.__init__(self)
        
        self._player = player
        self._config = config
        self._play_img = gtk.image_new_from_file(img_path % "media-playback-start.png")
        self._pause_img = gtk.image_new_from_file(img_path % "media-playback-pause.png")
        
        self.set_spacing(5)
        
        toggle = gtk.Button()
        # FIXME pygtk on meamo needs a copy, since set_image apparently clears the old img
        play_img_copy = gtk.image_new_from_pixbuf(self._play_img.get_pixbuf())
        toggle.set_image(play_img_copy)
        toggle.set_size_request(60, -1)
        toggle.connect("clicked", self.on_toggle)
        self.toggle_button = toggle
        self.pack_start(toggle, expand=False)
        
        prev = gtk.Button()
        prev.set_image(gtk.image_new_from_file(img_path % "media-skip-backward.png"))
        prev.set_size_request(60, -1)
        prev.connect("clicked", lambda caller: self._player.previous())
        prev.unset_flags(gtk.CAN_FOCUS)
        self.pack_start(prev, expand=False)
        
        next = gtk.Button()
        next.set_image(gtk.image_new_from_file(img_path % "media-skip-forward.png"))
        next.set_size_request(60, -1)
        next.unset_flags(gtk.CAN_FOCUS)
        next.connect("clicked", lambda caller: self._player.next())
        self.pack_start(next, expand=False)
        
        self.pos = hildon.Seekbar()
        self.pos.set_draw_value(False)
        self.pos.set_range(0.0, 1.0)
        self.pos.set_increments(0.01, 0.01)
        self.pos.connect("change-value", self.on_seek)
        self.pos.unset_flags(gtk.CAN_FOCUS)
        self.pos.set_update_policy(gtk.UPDATE_DELAYED)
        
        self.pack_start(self.pos)
        
        self.volume = hildon.HVolumebar()
        self.volume.set_size_request(200, -1)
        
        self.volume.set_level(self._config["volume"] * 100)
        self.volume.connect("level-changed", self._on_hvolume_changed)
        self.volume.connect("mute-toggled", self._on_mute)
        self.volume.unset_flags(gtk.CAN_FOCUS)
        self.pack_end(self.volume, expand=False)
        
        self._config.notify_add("volume", self._on_conf_volume_changed)
        self._config.notify_add("search-str", self._on_song_changed)
        self._player.connect("song-changed", self._on_song_changed)
        self._player.connect("seek-changed", lambda caller, new_seek: self.pos.set_value(new_seek))
        
    def _on_song_changed(self, *args):
        self._update_toggle_img()
        
        self.toggle_button.grab_focus()
    
    def _update_toggle_img(self):                
        # FIXME copying image for maemo
        if self._player.playing:
            self.toggle_button.set_image(gtk.image_new_from_pixbuf(self._pause_img.get_pixbuf()))
        else:
            self.toggle_button.set_image(gtk.image_new_from_pixbuf(self._play_img.get_pixbuf()))
        
    def on_toggle(self, caller=None):
        self._player.toggle()
        self._update_toggle_img()

    def on_seek(self, caller, scroll, value):
        self._player.seek_to(caller.get_value())
    
    def _on_conf_volume_changed(self, client, cxn_id, entry, data):
        self.volume.set_level(entry.get_value().get_float() * 100)
    
    def _on_mute(self, hvolume):
        if hvolume.get_mute():
            self._player.mute()
        else:
            self._config.notify("volume") # refresh volume
    
    def _on_hvolume_changed(self, hvolume):
        if(hvolume.get_mute()):
            self._player.mute()
            return
        else:
            val = hvolume.get_level()/100
        
        self._config["volume"] = val
        
    def _update_pos(self):
        self.pos.set_value(self._player.get_seek())
        
        return True
