import gtk
import hildon
import pango

from youamp.ui.controls import Controls
from youamp.ui.searchview import SearchView

class Window(hildon.Window):
    def __init__(self, player, config, library):
        hildon.Window.__init__(self)
        
        self._player = player
        self._config = config
        self._library = library

        self.set_default_size(800, 480)
        self.set_title(_("No Track"))
        self._is_fullscreen = False
        
        # Content Box
        vbox = gtk.VBox()
        vbox.set_spacing(5)
        
        # Label
        self._label = gtk.Label()
        self._label.set_alignment(0, 0)
        self._label.set_justify(gtk.JUSTIFY_LEFT)
        self._label.set_ellipsize(pango.ELLIPSIZE_END)
        self._label.set_selectable(False)
        self._label.set_markup("<b><big>%s</big></b>" % _("No Track"))
        self._label.show_all()
        vbox.pack_start(self._label, expand=False)

        # Controls
        self._controls = Controls(self._player, self._config)
        self._controls.show_all()
        vbox.pack_start(self._controls, expand=False)

        # View
        self.view = SearchView(self._config, self._player, self._library)
        vbox.pack_start(self.view)
        
        vbox.show()
        self.add(vbox)
    
        self._player.connect("tags-updated", self._on_tags_updated)
        
        self.show()
    
    def toggle_fullscreen(self):
        if self._is_fullscreen:
            self.unfullscreen()
            self._label.set_padding(0, 0)
        else:
            self.fullscreen()
            self._label.set_padding(10, 10)
        
        self._is_fullscreen = not self._is_fullscreen
    
    def _on_tags_updated(self, caller, newsong):
        self.set_title("%s - %s" % (newsong["title"], newsong["artist"]))
                
        label_txt = "<b><big>%s</big></b> %s <i>%s</i> %s <i>%s</i>" % (newsong["title"], _("by"), newsong["artist"], _("from"), newsong["album"])
        label_txt = label_txt.replace("&", "&amp;") # escape the xml escape char
        
        if not self._player.has_rg_info():
            label_txt = """<span foreground="red">%s</span>""" % label_txt
        
        self._label.set_markup(label_txt)
