from youamp import IS_MAEMO

if IS_MAEMO:
    import gnome.gconf as gconf
else:
    import gconf

class Config(gconf.Client): 
    def __init__(self):
        gconf.Client.__init__(self)
        self.add_dir("/apps/youamp", gconf.CLIENT_PRELOAD_RECURSIVE)
        
        if not self.has_key("volume"):
            # write default config
            self["volume"] = 0.5
            self["search-str"] = ""
            self["search-artist"] = ""
            self["search-album"] = ""
            self["pos"] = 0
            self["shuffle"] = False
            self["is-browser"] = False
            self["order-by"] = "artist"
            self["rg-preamp"] = 0     # preamp to adjust the default of 89db (value: db)
            self["no-rg-preamp"] = -10  # amp value to be used if no rg info is available (value: db)
    
    def notify_add(self, k, f):
        gconf.Client.notify_add(self, "/apps/youamp/"+k, f)

    def notify(self, k):
        gconf.Client.notify(self, "/apps/youamp/"+k)
    
    def has_key(self, k):
        return self.get("/apps/youamp/"+k) is not None
    
    def __getitem__(self, k):
        try:
            return self.get_value("/apps/youamp/"+k)
        except ValueError:
            return None
    
    def __setitem__(self, k, v):
        if v is None:
            self.unset("/apps/youamp/"+k)
        else:
            self.set_value("/apps/youamp/"+k, v)
