/*
  This file is part of "WhoAmI" - A "Guess whats on the photo" riddle game.
  Copyright (C) 2007  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include "Image.h"

Image::Image(const std::string& author,
             const std::string& title,
             const std::string& description,
             const std::string& imageLink)
 : author(author),
   title(title),
   description(description),
   imageLink(imageLink),
   shown(false)
{
  // no code
}

void Image::SetImage(Lum::Images::Image* image)
{
  this->image=image;
}

std::string Image::GetAuthor() const
{
  return author;
}

std::string Image::GetTitle() const
{
  return title;
}

std::string Image::GetDescription() const
{
  return description;
}

void Image::SetShown()
{
  shown=true;
}

bool Image::HasImage() const
{
  return image.Valid();
}

Lum::Images::Image* Image::GetImage() const
{
  return image.Get();
}

std::string Image::GetImageLink() const
{
  return imageLink;
}

bool Image::HasBeenShown() const
{
  return shown;
}

