/* audio.h - Copyright (C) 2001-2002 Jacob Kroon, see COPYING for details */

#ifndef _AUDIO_H
#define _AUDIO_H
#ifndef MAEMO
/* includes */
#include <SDL_types.h>

/* structs */
typedef struct _Sound Sound;

/* functions */
void audio_init(void);
void audio_deinit(void);
Sound *audio_create_sound(Uint8 *, Uint32 *);
void audio_free_sound(Sound *);
void audio_play_sound(Sound *);
void audio_set_mute(Uint8);
void audio_set_single(Sound *, Uint8);
#else

#define false 0
#define true 1

#define SNDFILENOCK   "nock.wav"
#define SNDFILECRASH  "crash.wav"
#define SNDFILEAPPS   "apps.wav"
#define SNDFILEBOOS  "boos.wav"
#define SOUNDPREFIX "$(datadir)/tuxpuck/sounds"

typedef enum { SNDCRASH, SNDNOCK, SNDAPPS, SNDBOOS } SoundOption;

extern int soundsystemworks;

extern void audio_init(void);
extern void audio_deinit(void);
extern void audio_play_sound(SoundOption soundoption);
#endif /*MAEMO*/
#endif /* _AUDIO_H */
