import blowfish

# if True: a dummy encrypted data is used
DUMMY_SAFE_IMPLEMENTATION = False
DUMMY_PATERN = 'X'

class Blowfish(blowfish.Blowfish):
    ''' Implementation of the Crypto.Cipher.Blowfish API
        using a pure-python blowfish module.
    '''
    avoid_recursive = True
    
    @staticmethod
    def new(key):
        inst = Blowfish(key)
        inst.avoid_recursive = False
        return inst
    
    def encrypt(self, data):
        if DUMMY_SAFE_IMPLEMENTATION: return DUMMY_PATERN * len(data)
        if self.avoid_recursive:
            return blowfish.Blowfish.encrypt(self, data)
        self.avoid_recursive = True
        self.initCTR()
        encrypted = blowfish.Blowfish.encryptCTR(self, data)
        self.avoid_recursive = False
        return encrypted
    
    def decrypt(self, data):
        if DUMMY_SAFE_IMPLEMENTATION: return data
        if self.avoid_recursive:
            return blowfish.Blowfish.decrypt(self, data)
        self.avoid_recursive = True
        self.initCTR()
        decrypted = blowfish.Blowfish.decryptCTR(self, data)
        self.avoid_recursive = False
        return decrypted

__all__ = ['Blowfish',]
