#
# This is the encryption module for TrustMe
# Copyright (C) 2009, Henning Spruth
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor,
# Boston, MA  02110-1301, USA.
#

#
# The file format consists of:
#    1. a client-provided header line
#    2. a random, 128-bit initialization vector
#    3. the encrypted payload data, starting with an encrypted copy of the
#       header line
#

import re
import Gcrypt
import os.path


class EncryptedFileError(Exception):
    def __init__(self, value):
        self.value=value

class Vault():


    def encrypt(self, string):
        encryptor=Gcrypt.Cipher('BLOWFISH-128', 'CBC-CTS',
                                self.pwHash, self.iv)
        result=encryptor.Encrypt(string)
        return result

    def save(self, fn, header, content):

        appDir=os.path.dirname(fn)
        if appDir!='' and not os.path.exists(appDir):
            os.mkdir(appDir)
        backupFileName=fn+'.bak'
        if os.path.exists(backupFileName):
            #print "removing backup file"
            os.remove(backupFileName)
        if os.path.exists(fn):
            #print "creating backup"
            os.rename(fn, backupFileName)


        # create a random 128-bit initizliation vector
        self.iv=Gcrypt.GenRandom(8)

            
        #print "Saving to",fn
        fp=open(fn, 'w')

        #engine=Blowfish.new(self.password)
        #content=engine.encrypt("#TrustMe 1.0\n"+self.store.toString())

        # The header is first written in clear text (to allow detecting
        # things like schema and encryption method), and then again encrypted
        # to allow checking the key
        content=self.encrypt(header+"\n"+content)
        fp.write(header+"\n")
        fp.write(self.iv)
        fp.write(content)
        fp.close()

    def decrypt(self, string):

        decryptor=Gcrypt.Cipher('BLOWFISH-128', 'CBC-CTS', self.pwHash,
                                self.iv)
        return decryptor.Decrypt(string)
        

    def load(self, fn, headerRe):
        fp=open(fn, 'r')
        header=fp.readline()
        self.iv=fp.read(8)
        content=fp.read()
        fp.close()

        match=re.match(headerRe, header)
        if not match:
            raise EncryptedFileError("Wrong file header")

        if match.lastindex>=1:
            schemaVersion=str(match.group(1))
        else:
            schemaVersion=None
        #if schemaVersion!=1:
        #    raise EncryptedFileError("Unsupported schema version '"+str(schemaVersion)+"'")

        # old:
        #engine=Blowfish.new(self.main.password)
        #content=engine.decrypt(content)
        
        content=self.decrypt(content)
        if not content.startswith(header):
            raise EncryptedFileError("Wrong password or corrupted file")
        content=content[len(header):]
        return (schemaVersion, content)


    def setPassword(self, password):
        hashGen=Gcrypt.Hash("MD5")
        hashGen.Add(password)
        self.pwHash=hashGen.Hash()

        # Can't use global Cipher objects as they are not re-usable
        #self.encryptor=Gcrypt.Cipher('BLOWFISH-128', 'CBC-CTS', pwHash, 'initinit')
        #self.decryptor=Gcrypt.Cipher('BLOWFISH-128', 'CBC-CTS', pwHash, 'initinit')



    def __init__(self):
        self.pwHash=None



if __name__=='__main__':
    cleartext="The lady Macbeth rises from the ashes"
    secret="foobarbaz"
    vault1=Vault('fooz1234')

    vault1.setPassword(secret)
    enc1=vault1.encrypt(cleartext)

    print enc1

    vault=Vault('fooz1234')
    vault.setPassword(secret)
    dec=vault.decrypt(enc1)
    print dec

    vault=Vault('fooz1234')
    vault.setPassword(secret)
    dec=vault.decrypt(enc1)
    print dec


    vault=Vault()
    vault.setPassword(secret)
    fn='./vault_test.db'
    header="MY HEADER"
    vault.save(fn, header, cleartext)

    tuple=vault.load(fn, header)
    print "'"+tuple[1]+"'"
    print "'"+cleartext+"'"
    assert tuple[1]==cleartext
