#!/usr/bin/python

import re
import gtk



class Record:
    def __init__(self, id, name, user, password, category, info):
        self.id=id
        self.name=name
        self.user=user
        self.password=password
        self.category=category
        self.info=info

    def toString(self):
        result=''
        cr="\n"
        result+='n: '+self.name+cr
        result+='u: '+self.user+cr
        result+='p: '+self.password+cr
        result+='c: '+self.category+cr
        for line in self.info.split("\n"):
            result+="i: "+line+cr
        result+=cr
        return result

    def toTuple(self):
        return (self.id,self.name)
        #return [self.id,self.name,self.user,self.password,self.category, self.info]
    

class DataStore(gtk.ListStore):

    def __init__(self):
        #gtk.ListStore.__init__(self,int,str,str,str,str,str)
        gtk.ListStore.__init__(self,int,str)
        self.set_sort_column_id(1,gtk.SORT_ASCENDING)
        self.clearRecords()


    def clearRecords(self):
        self.records=[]
        self.clear()
        self.lastId=0

    def deleteRecord(self, id):
        del self.records[id]

    def addRecord(self, name, user, password, category, info):
        record=Record(self.lastId, name, user, password, category, info)
        self.records.append(record)
        self.lastId+=1
        return record
        

    #def add(self, name, user, password, category, info):
    #    tuple=(name,user,password,category,info)
    #    self.db.append(tuple)

    def getCategories(self):
        result=[]
        result.append('')
        for record in self.records:
            cat=record.category
            if result.count(cat)==0:
                result.append(cat)
        result.sort()
        return result

    def dump(self):
        for tuple in self:
            print "%s %s" % (tuple[0], tuple[1])

    def toString(self):
        result=''
        for record in self.records:
            result+=record.toString()
        return result

    def fromString(self, s):
        name=''
        user=''
        password=''
        category=''
        info=''
        lineNo=0
        self.clearRecords()
        for line in s.split("\n"):
            #print "line='"+line+"'"
            lineNo+=1
            # skip blank lines and comments
            if not re.match("\s*(#.*|\s*)$", line):
                match=re.match("([nupci]):\s*(.*)", line)
                if match:
                    key=match.group(1)
                    val=match.group(2)
                    if key=='n':
                        if name!='':
                            self.addRecord(name, user, password, category, info)
                            user=''
                            password=''
                            category=''
                            info=''
                        name=val
                    else:
                        if key=='u':
                            user=val
                        elif key=='p':
                            password=val
                        elif key=='c':
                            category=val
                        elif key=='i':
                            if info!='':
                                info+="\n"+val
                            else:
                                info=val
                        else:
                            raise ValueError("Line "+str(lineNo)+": unknown field code "+key)
                else:
                    raise ValueError("Line "+str(lineNo)+": can't parse "+line)
        if name!='':
            self.addRecord(name, user, password, category, info)

    def filter(self, search, category):
        self.clear()
        result=0
        for record in self.records:
            if (category=='' or record.category==category) and (search=='' or record.name.find(search)>=0):
                self.append(record.toTuple())
                result+=1
            else:
                record.iter=None
                #print "skip"
        return result
            




if __name__=="__main__":
    store=DataStore()
    store.append(['My Bank', 'johndoe', 'secret', 'money', "foo\nbar"])
    store.append(['Google', 'xyz123', 'secret', 'internet', "Since 12/23/2009"])
    store.append(['Yahoo', 'xyz123', 'secret', 'internet', ''])
    store.append(['MSN', 'xyz123', 'secret', 'internet', ''])
    store.append(['AOL', 'xyz123', 'secret', 'internet', "Not really using this\naccount any more"])
    #store.dump()

    masterPassword='hokuspokus'
    ob=Blowfish.new(masterPassword)
    s=store.toString()

    encrypted=ob.encrypt(s)
    s=ob.decrypt(encrypted)
    print s

    store.fromString(s)
    store.dump()
