//
// Telescope - graphical task switcher
//
// (c) Ilya Skriblovsky, 2010
// <Ilya.Skriblovsky@gmail.com>
//

// $Id: Resources.h 124 2010-07-27 11:27:25Z mitrandir $

// Resources - loads and ownes all common resources

// Singleton

#ifndef __TELESCOPE__RESOURCES_H
#define __TELESCOPE__RESOURCES_H

#include <X11/Xlib.h>
#include <X11/extensions/Xrender.h>

class Resources
{
    private:
        static Resources *_instance;

        Display *_dpy;

        Pixmap _headerLeftPix;
        Picture _headerLeftPict;
        Pixmap _headerRightPix;
        Picture _headerRightPict;
        Pixmap _headerMiddlePix;
        Picture _headerMiddlePict;
        Pixmap _headerLeftSelectedPix;
        Picture _headerLeftSelectedPict;
        Pixmap _headerRightSelectedPix;
        Picture _headerRightSelectedPict;
        Pixmap _headerMiddleSelectedPix;
        Picture _headerMiddleSelectedPict;
        Pixmap _brokenPatternPix;
        Picture _brokenPatternPict;

        int _headerHeight;
        int _headerLeftWidth;
        int _headerRightWidth;

        XRenderColor _borderColor;
        XRenderColor _borderActiveColor;

    public:
        Resources(Display *dpy);
        ~Resources();

        static Resources* instance() { return _instance; }

        bool loadARGBImage(
            const char *filename,
            Drawable parent,
            Pixmap *pixmap,
            Picture *picture,
            int *width,
            int *height
        );


        Pixmap headerLeftPix()     { return _headerLeftPix; }
        Picture headerLeftPict()   { return _headerLeftPict; }
        Pixmap headerRightPix()    { return _headerRightPix; }
        Picture headerRightPict()  { return _headerRightPict; }
        Pixmap headerMiddlePix()   { return _headerMiddlePix; }
        Picture headerMiddlePict() { return _headerMiddlePict; }
        Pixmap headerLeftSelectedPix()     { return _headerLeftSelectedPix; }
        Picture headerLeftSelectedPict()   { return _headerLeftSelectedPict; }
        Pixmap headerRightSelectedPix()    { return _headerRightSelectedPix; }
        Picture headerRightSelectedPict()  { return _headerRightSelectedPict; }
        Pixmap headerMiddleSelectedPix()   { return _headerMiddleSelectedPix; }
        Picture headerMiddleSelectedPict() { return _headerMiddleSelectedPict; }
        Pixmap brokenPatternPix()   { return _brokenPatternPix; }
        Picture brokenPatternPict() { return _brokenPatternPict; }

        int headerHeight() { return _headerHeight; }
        int headerLeftWidth() { return _headerLeftWidth; }
        int headerRightWidth() { return _headerRightWidth; }


        const XRenderColor* borderColor() { return &_borderColor; }
        const XRenderColor* borderActiveColor() { return &_borderActiveColor; }
};


#endif
