//
// Telescope - graphical task switcher
//
// (c) Ilya Skriblovsky, 2010
// <Ilya.Skriblovsky@gmail.com>
//

// $Id: Resources.cpp 124 2010-07-27 11:27:25Z mitrandir $

#include "Resources.h"

#include <stdio.h>
#include <string.h>

#include <Imlib2.h>

#include <sys/stat.h>

#include "XTools.h"
#include "Settings.h"

Resources* Resources::_instance = 0;


Resources::Resources(Display *dpy): _dpy(dpy)
{
    if (_instance != 0)
        printf("Resources singleton created twice!\n");

    _instance = this;

    Window rootWindow = XTools::rootWindow();

// Loading header images

    bool ok = true;
    ok = ok && loadARGBImage(
        Settings::instance()->headerLeftFilename(),
        rootWindow,
        &_headerLeftPix,
        &_headerLeftPict,
        &_headerLeftWidth,
        &_headerHeight);
    ok = ok && loadARGBImage(
        Settings::instance()->headerRightFilename(),
        rootWindow,
        &_headerRightPix,
        &_headerRightPict,
        &_headerRightWidth,
        0);
    ok = ok && loadARGBImage(
        Settings::instance()->headerMiddleFilename(),
        rootWindow,
        &_headerMiddlePix,
        &_headerMiddlePict,
        0, 0);

    ok = ok && loadARGBImage(
        Settings::instance()->headerLeftSelectedFilename(),
        rootWindow,
        &_headerLeftSelectedPix,
        &_headerLeftSelectedPict,
        0, 0);
    ok = ok && loadARGBImage(
        Settings::instance()->headerRightSelectedFilename(),
        rootWindow,
        &_headerRightSelectedPix,
        &_headerRightSelectedPict,
        0, 0);
    ok = ok && loadARGBImage(
        Settings::instance()->headerMiddleSelectedFilename(),
        rootWindow,
        &_headerMiddleSelectedPix,
        &_headerMiddleSelectedPict,
        0, 0);

    ok = ok && loadARGBImage(
        Settings::instance()->brokenPatternFilename(),
        rootWindow,
        &_brokenPatternPix,
        &_brokenPatternPict,
        0, 0);

    if (! ok)
        printf("Cannot load all pixmaps\n");


    XRenderPictureAttributes pictureAttrs;
    pictureAttrs.repeat = RepeatNormal;
    XRenderChangePicture(_dpy, _headerMiddlePict, CPRepeat, &pictureAttrs);
    XRenderChangePicture(_dpy, _headerMiddleSelectedPict, CPRepeat, &pictureAttrs);
    XRenderChangePicture(_dpy, _brokenPatternPict, CPRepeat, &pictureAttrs);


    XRenderParseColor(_dpy, Settings::instance()->borderColor(), &_borderColor);
    XRenderParseColor(_dpy, Settings::instance()->borderActiveColor(), &_borderActiveColor);
}


Resources::~Resources()
{
    XRenderFreePicture(_dpy, _headerLeftPict);
    XRenderFreePicture(_dpy, _headerRightPict);
    XRenderFreePicture(_dpy, _headerMiddlePict);
    XRenderFreePicture(_dpy, _headerLeftSelectedPict);
    XRenderFreePicture(_dpy, _headerRightSelectedPict);
    XRenderFreePicture(_dpy, _headerMiddleSelectedPict);
    XFreePixmap(_dpy, _headerLeftPix);
    XFreePixmap(_dpy, _headerRightPix);
    XFreePixmap(_dpy, _headerMiddlePix);
    XFreePixmap(_dpy, _headerLeftSelectedPix);
    XFreePixmap(_dpy, _headerRightSelectedPix);
    XFreePixmap(_dpy, _headerMiddleSelectedPix);
}


bool Resources::loadARGBImage(
    const char *filename,
    Drawable parent,
    Pixmap *pixmap,
    Picture *picture,
    int *width,
    int *height)
{
    static Visual *defaultVisual = 0;
    static XVisualInfo rgbaVisual;
    static XRenderPictFormat *defaultFormat;
    static XRenderPictFormat *rgbaFormat;
    static Colormap colormap;

    *pixmap = 0;
    *picture = 0;

    if (defaultVisual == 0)
    {
        // Initializing

        int scr = DefaultScreen(_dpy);
        defaultVisual = DefaultVisual(_dpy, scr);
        colormap = DefaultColormap(_dpy, scr);
        defaultFormat = XRenderFindVisualFormat(_dpy, defaultVisual);

        if (XMatchVisualInfo(_dpy, scr, 32, TrueColor, &rgbaVisual) == 0)
        {
            fprintf(stderr, "Cannot find rgba visual\n");
            return false;
        }
        rgbaFormat = XRenderFindVisualFormat(_dpy, rgbaVisual.visual);
    }


    Imlib_Image image = imlib_load_image(filename);
    if (image == 0)
        return false;

    imlib_context_set_image(image);
    int w = imlib_image_get_width();
    int h = imlib_image_get_height();

    if (width) *width = w;
    if (height) *height = h;

    // Making image with premultiplied alpha
    Imlib_Image premul = imlib_create_image(w, h);
    imlib_context_set_image(premul);
    imlib_context_set_color(0, 0, 0, 255);
    imlib_image_fill_rectangle(0, 0, w, h);
    imlib_context_set_blend(1);
    imlib_blend_image_onto_image(image, 0, 0, 0, w, h, 0, 0, w, h);
    imlib_image_copy_alpha_to_image(image, 0, 0);

    *pixmap = XCreatePixmap(_dpy, parent, w, h, 32);
    imlib_context_set_display(_dpy);
    imlib_context_set_colormap(colormap);
    imlib_context_set_visual(rgbaVisual.visual);
    imlib_context_set_drawable(*pixmap);
    imlib_context_set_blend(0);
    imlib_render_image_on_drawable(0, 0);

    imlib_free_image();
    imlib_context_set_image(image);
    imlib_free_image();

    *picture = XRenderCreatePicture(_dpy, *pixmap, rgbaFormat, 0, 0);

    return true;
}
