//
// Telescope - graphical task switcher
//
// (c) Ilya Skriblovsky, 2010
// <Ilya.Skriblovsky@gmail.com>
//

// $Id: DBus.h 108 2010-07-07 13:23:53Z mitrandir $

// DBus - class for dealing with D-Bus

#ifdef DBUS

#ifndef __TELESCOPE__DBUS_H
#define __TELESCOPE__DBUS_H

#include <dbus/dbus.h>

#include <pthread.h>

class TeleWindow;

class DBus
{
    private:
        TeleWindow *_teleWindow;

        DBusConnection *_conn;

        bool _running;
        bool _stopped;

        pthread_t _thread;

        DBusObjectPathVTable _telescopeVTable;

        static void mainLoop(DBus *self);

        static void telescope_unregister(
            DBusConnection *conn,
            DBus *self
        );
        static DBusHandlerResult telescope_message(
            DBusConnection *conn,
            DBusMessage *msg,
            DBus *self
        );

    public:
        DBus(TeleWindow *teleWindow);
        ~DBus();

        void startMainLoop();
        void stopMainLoop();
};

#endif

#endif
