//
// Telescope - graphical task switcher
//
// (c) Ilya Skriblovsky, 2010
// <Ilya.Skriblovsky@gmail.com>
//

// $Id: DBus.cpp 108 2010-07-07 13:23:53Z mitrandir $


// FIXME: D-Bus thread will not be stopped at exit
// because of infinite timeout in mainloop

#ifdef DBUS

#include "DBus.h"

#include "TeleWindow.h"


DBus::DBus(TeleWindow *teleWindow)
{
    _teleWindow = teleWindow;
    _running = false;
    _stopped = false;

    DBusError error;
    dbus_error_init(&error);

    _conn = dbus_bus_get(DBUS_BUS_SESSION, &error);
    if (dbus_error_is_set(&error) || _conn == 0)
    {
        fprintf(stderr, "D-Bus connection error: %s\n", error.message);
        return;
    }

    dbus_bus_request_name(_conn, "org.telescope",
            DBUS_NAME_FLAG_DO_NOT_QUEUE, &error);
    if (dbus_error_is_set(&error))
    {
        fprintf(stderr, "D-Bus bus name error: %s\n", error.message);
        return;
    }


    _telescopeVTable.unregister_function = (DBusObjectPathUnregisterFunction)telescope_unregister;
    _telescopeVTable.message_function = (DBusObjectPathMessageFunction)telescope_message;
    dbus_connection_register_object_path(_conn, "/Telescope",
        &_telescopeVTable, this);
}

DBus::~DBus()
{
    stopMainLoop();

    dbus_connection_close(_conn);
    dbus_connection_unref(_conn);
}

void DBus::startMainLoop()
{
    _running = true;
    _stopped = false;
    pthread_create(&_thread, 0, (void*(*)(void*))&mainLoop, this);
}

void DBus::stopMainLoop()
{
    if (_running && ! _stopped)
    {
        _stopped = true;
        pthread_join(_thread, 0);
        _running = false;
        _stopped = false;
    }
}



void DBus::mainLoop(DBus *self)
{
//    while (! self->_stopped)
//    {
//        dbus_connection_read_write(self->_conn, -1);
//        DBusMessage *msg = dbus_connection_pop_message(self->_conn);
//
//        if (msg == 0)
//        {
//            continue;
//        }
//
//        printf("\nD-Bus event\n");
//        printf("path: %s\n", dbus_message_get_path(msg));
//        printf("interface: %s\n", dbus_message_get_interface(msg));
//
//        dbus_message_unref(msg);
//    }

    while (! self->_stopped && dbus_connection_read_write_dispatch(self->_conn, -1))
    {
    }
}



void DBus::telescope_unregister(DBusConnection *conn, DBus *self)
{
}

DBusHandlerResult DBus::telescope_message(
    DBusConnection *conn,
    DBusMessage *msg,
    DBus *self
)
{
    if (dbus_message_is_method_call(msg, "org.telescope.Telescope", "Show"))
    {
        DBusMessage *reply = dbus_message_new_method_return(msg);
        dbus_connection_send(conn, reply, 0);
        dbus_message_unref(reply);

        XLockDisplay(self->_teleWindow->display());
        self->_teleWindow->show();
        XFlush(self->_teleWindow->display());
        XUnlockDisplay(self->_teleWindow->display());
    }
    else if (dbus_message_is_method_call(msg, "org.telescope.Telescope", "Hide"))
    {
        DBusMessage *reply = dbus_message_new_method_return(msg);
        dbus_connection_send(conn, reply, 0);
        dbus_message_unref(reply);

        XLockDisplay(self->_teleWindow->display());
        self->_teleWindow->hide();
        XFlush(self->_teleWindow->display());
        XUnlockDisplay(self->_teleWindow->display());
    }

    return DBUS_HANDLER_RESULT_HANDLED;
}


#endif
