#!/usr/bin/python
import Sword

def initConfig(confPath):
    print "initConfig",confPath
    ins=Sword.InstallSource("FTP")
    ins.caption.set("CrossWire")
    ins.source.set("ftp.crosswire.org")
    ins.directory.set("/pub/sword/raw")

    config=Sword.SWConfig(confPath)
    config.set("General","PassiveFTP","true")
    config.set("Sources","FTPSource",ins.getConfEnt().getRawData())
    config.Save()
    
def listModules(mgr):
    print "Listing modules"
    for i in mgr.getModules().values():
        print i.Name(),i.Description()

def listRemoteSources(installMgr):
    print "Listing remote sources:"
    for cur_source in installMgr.sources.items():
        print "---"
        source_name=cur_source[0].getRawData()
        install_source=cur_source[1]
        directory=install_source.directory.getRawData()
        caption=install_source.caption.getRawData()
        localShadow=install_source.localShadow.getRawData()
        source=install_source.source.getRawData()
        type=install_source.type.getRawData()
        print "name=%s"%source_name
        print "directory=%s"%directory
        print "caption=%s"%caption
        print "localShadow=%s"%localShadow
        print "source=%s"%source
        print "type=%s"%type
        
def refreshRemoteSource(sourceName,installMgr):
    print "refreshRemoteSource",sourceName
    source=False
    for i in installMgr.sources.items():
        if sourceName==i[0].getRawData():
            source=i
    if not source:
        print "Couldn't find remote source: %s"%sourceName
        return False

    if installMgr.refreshRemoteSource(source[1])!=0:
        return False
    else:
        return True
    

def remoteListModules(sourceName,installMgr):
    print "remoteListModules",sourceName
    source=False
    for i in installMgr.sources.items():
        if sourceName==i[0].getRawData():
            source=i
    if not source:
        print "Couldn't find remote source: %s"%sourceName
        return False

    swmgr = source[1].getMgr()
    for i in swmgr.getModules().values():
        print "%s -> %s"%(i.Name(),i.Description())

def remoteInstallModule(sourceName,moduleName,installMgr,swmgr):
    print "remoteInstallModule:",sourceName,moduleName
    source=False
    for i in installMgr.sources.items():
        if sourceName==i[0].getRawData():
            source=i
    if not source:
        print "Couldn't find remote source: %s"%sourceName
        return False

    rmgr=source[1].getMgr()

    exist=False
    for i in rmgr.getModules():
        if i.getRawData()==moduleName:
            exist=True
    if not exist:
        print "Couldn't fine remote module: %s"%moduleName
        return False

    installMgr.installModule(swmgr,0,moduleName,source[1])
    
data_path="/home/pamadio/modules"
install_mgr_dir="/home/pamadio/.sword/InstallMgr"


mgr=Sword.SWMgr()
mgr.prefixPath = data_path
mgr.configPath = "%s/mods.d" % data_path
mgr.augmentModules(data_path)

#initConfig(install_mgr_dir+"/InstallMgr.conf")
installMgr=Sword.InstallMgr(install_mgr_dir)
#listModules(mgr)
#listRemoteSources(installMgr)
#refreshRemoteSource("CrossWire",installMgr)
#remoteListModules("CrossWire",installMgr)
remoteInstallModule("CrossWire","KJV",installMgr,mgr)
