#!/usr/bin/env python2.5

import gtk
import hildon
import sys
import mokoui
import os
import ConfigParser
import pango

class QuickClipViewer(hildon.Program):
   def __init__(self):
      hildon.Program.__init__(self)

      gtk.set_application_name("Quick Clip Viewer")

      self.window = hildon.Window()
      self.window.connect("destroy", self.close_application)
      self.window.connect("key-press-event", self.on_key_press)
      self.window.connect("window-state-event", self.on_window_state_change)
      self.add_window(self.window)

      filename = sys.argv[1]
      self.window.set_title(filename)

      settings = self.get_settings()

      if settings['scrolling'] == 1:
         sw = gtk.ScrolledWindow()
         sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
      else:
         sw = mokoui.FingerScroll()
         sw.set_property('mode', 1)

      textview = gtk.TextView()
      textbuffer = textview.get_buffer()
      textview.set_sensitive(False)

      textview.modify_font(pango.FontDescription(settings['font']))

      sw.add(textview)

      infile = open(filename, "r")

      if infile:
         string = infile.read()
         infile.close()
         textbuffer.set_text(string)
      textview.set_wrap_mode(gtk.WRAP_WORD)

      toolbar = gtk.Toolbar()

      editable_button = gtk.ToggleToolButton(gtk.STOCK_EDIT)
      editable_button.connect('toggled', self.editable_button_callback, editable_button, textview)
      preference_button = gtk.ToolButton(gtk.STOCK_PREFERENCES)
      preference_button.connect('clicked', self.preference_button_callback)
      font_button = gtk.ToolButton(gtk.STOCK_SELECT_FONT)
      font_button.connect('clicked', self.font_button_callback, textview)
      copy_button = gtk.ToolButton(gtk.STOCK_COPY)
      copy_button.connect('clicked', self.copy_button_callback, textview)
      top_button = gtk.ToolButton(gtk.STOCK_GOTO_TOP)
      top_button.connect('clicked', self.goto_top_button_callback, textview)
      bottom_button = gtk.ToolButton(gtk.STOCK_GOTO_BOTTOM)
      bottom_button.connect('clicked', self.goto_bottom_button_callback, textview)
      zoom_in_button = gtk.ToolButton(gtk.STOCK_ZOOM_IN)
      zoom_in_button.connect('clicked', self.zoom_in_button_callback, textview)
      zoom_out_button = gtk.ToolButton(gtk.STOCK_ZOOM_OUT)
      zoom_out_button.connect('clicked', self.zoom_out_button_callback, textview)
      about_button = gtk.ToolButton(gtk.STOCK_ABOUT)
      about_button.connect('clicked', self.about_dialog)
      quit_button = gtk.ToolButton(gtk.STOCK_QUIT)
      quit_button.connect('clicked', self.quit_button_callback)

      toolbar.insert(editable_button, -1)
      toolbar.insert(preference_button, -1)
      toolbar.insert(font_button, -1)
      toolbar.insert(gtk.SeparatorToolItem(), -1)
      toolbar.insert(copy_button, -1)
      toolbar.insert(top_button, -1)
      toolbar.insert(bottom_button, -1)
      toolbar.insert(gtk.SeparatorToolItem(), -1)
      toolbar.insert(zoom_in_button, -1)
      toolbar.insert(zoom_out_button, -1)
      toolbar.insert(gtk.SeparatorToolItem(), -1)
      toolbar.insert(about_button, -1)
      toolbar.insert(quit_button, -1)

      self.window.add_toolbar(toolbar)
      self.window.add(sw)
      self.window.show_all()

   def quit_button_callback(self, widget):
      gtk.main_quit()

   def goto_top_button_callback(self, widget, textview):
      textview_iter = textview.get_iter_at_location(0, 0)
      textview.scroll_to_iter(textview_iter, False)

   def goto_bottom_button_callback(self, widget, textview):
      textbuffer = textview.get_buffer()
      buffer_length = textbuffer.get_end_iter()
      textview.scroll_to_iter(buffer_length, False)

   def zoom_in_button_callback(self, widget, textview):
      context = textview.get_pango_context()
      font = context.get_font_description()
      size = font.get_size()

      if size > 32000:
         hildon.hildon_banner_show_information(textview, None, "Maximum zoom level reached")
         return

      font.set_size(int(size + 2000))
      textview.modify_font(font)
      self.set_settings(font)

   def zoom_out_button_callback(self, widget, textview):
      context = textview.get_pango_context()
      font = context.get_font_description()
      size = font.get_size()

      if size < 6000:
         hildon.hildon_banner_show_information(textview, None, "Minimum zoom level reached")
         return

      font.set_size(int(size - 2000))
      textview.modify_font(font)
      self.set_settings(font)

   def font_button_callback(self, widget, textview):
      font_dialog = gtk.FontSelectionDialog("Select A Font")
      font_dialog.set_size_request(700, 450)
      response = font_dialog.run()

      if response == gtk.RESPONSE_OK:
         font_desc = pango.FontDescription(font_dialog.get_font_name())
         if font_desc:
            textview.modify_font(font_desc)
            self.set_settings(font_desc)

      font_dialog.destroy()

   def copy_button_callback(self, widget, textview):
      try:
         textview_buffer = textview.get_buffer ()
         start, end = textview_buffer.get_selection_bounds()

         clipboard = gtk.clipboard_get(gtk.gdk.SELECTION_CLIPBOARD)
         clipboard.set_text(textview_buffer.get_text(start, end))
         hildon.hildon_banner_show_information(textview, None, "Copied")
      except ValueError:
         hildon.hildon_banner_show_information(textview, "qgn_note_gene_syswarning", "Nothing Selected")

   def editable_button_callback(self, widget, editable_button, textview):
      active = editable_button.get_active()
      if active == True:
         textview.set_sensitive(True)
         textview.set_editable(False)
      else:
         textview.set_sensitive(False)

   def preference_button_callback(self, widget):
      dialog = gtk.Dialog("Settings",None,gtk.DIALOG_MODAL)
      dialog.set_size_request(400, -1)
      ok_button = dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      cancel_button = dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

      

      settings = self.get_settings()

      combobox = gtk.combo_box_new_text()
      combobox.append_text("Kinetic")
      combobox.append_text("GTK")

      combobox.set_active(int(settings['scrolling']))

      hbox = gtk.HBox()
      hbox.pack_start(gtk.Label("Scrolling:"), False, 5, 5)
      hbox.pack_end(combobox)

      dialog.vbox.pack_start(hbox, False, 10, 10)
      dialog.vbox.pack_end(gtk.Label("Note: You may need to restart the\nprogram for some changes to take effect."), False, 10, 10)

      dialog.show_all()
      response = dialog.run()

      if response == gtk.RESPONSE_OK:
         scrolling = combobox.get_active()
         self.set_settings(None, scrolling)

      dialog.destroy()

# About dialog

   def about_dialog(self,widget,data=None):
      about_quick_clip = gtk.AboutDialog()
      about_quick_clip.set_name("Quick Clip")
      about_quick_clip.set_version("0.3.0")
      about_quick_clip.set_logo(gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/40x40/hildon/quick_clip-40x40.png"))
      about_quick_clip.set_comments("""
The fast and easy way to copy and save information.
""")
      about_quick_clip.set_copyright("Copyright 2009, Brent Chiodo")
      about_quick_clip.set_license("""This program is free software: you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program.  If not, see
<http://www.gnu.org/licenses/>.""")

      authors = ["Brent Chiodo <bchiodo@gmail.com>"]
      about_quick_clip.set_authors(authors)
      about_quick_clip.run()
      about_quick_clip.destroy()

# Get User's settings

   def get_settings(self):

      user_config_file = open('/home/user/.quickclip/viewer.conf', 'r')
      user_config_access = ConfigParser.RawConfigParser()
      user_config_access.readfp(user_config_file)

      settings_dict = {}
      settings_dict['font'] = user_config_access.get('DEFAULT', 'font')
      settings_dict['scrolling'] = user_config_access.get('DEFAULT', 'scrolling')

      if settings_dict['scrolling'] == "kinetic":
         settings_dict['scrolling'] = 0
      if settings_dict['scrolling'] == "gtk":
         settings_dict['scrolling'] = 1

      user_config_file.close()

      return settings_dict

   def get_settings_helper(self, value):
      if value == "True":
         return True
      if value == "False":
         return False
      if value == "1":
         return 1
      if value == "0":
         return 0

# Set settings

   def set_settings(self, font=None, scrolling=None):

      settings = self.get_settings()

      user_config_file = open('/home/user/.quickclip/viewer.conf', 'w')
      user_config_access = ConfigParser.RawConfigParser()

      if not font == None:
         user_config_access.set('DEFAULT', 'font', font)
         user_config_access.set('DEFAULT', 'scrolling', settings['scrolling'])
      if not scrolling == None:
         if scrolling == 0:
            scrolling = "kinetic"
         if scrolling == 1:
            scrolling = "gtk"

         user_config_access.set('DEFAULT', 'scrolling', scrolling)
         user_config_access.set('DEFAULT', 'font', settings['font'])

      user_config_access.write(user_config_file)
      user_config_file.close()

   def on_window_state_change(self, widget, event, *args):
      if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
         self.window_in_fullscreen = True
      else:
         self.window_in_fullscreen = False

   def on_key_press(self, widget, event, *args):
      if event.keyval == gtk.keysyms.F6:
      # The "Full screen" hardware key has been pressed
         if self.window_in_fullscreen:
            self.window.unfullscreen()
         else:
            self.window.fullscreen()

   def close_application(self, widget):
      gtk.main_quit()

   def run(self):
      gtk.main()

if not os.path.exists('/home/user/.quickclip/viewer.conf'):

   user_config_file = open('/home/user/.quickclip/viewer.conf', 'w')
   user_config_access = ConfigParser.RawConfigParser()

   user_config_access.set('DEFAULT', 'font', 'Sans 12')
   user_config_access.set('DEFAULT', 'scrolling', 'kinetic')

   user_config_access.write(user_config_file)
   user_config_file.close()

app = QuickClipViewer()
app.run()