#    Copyright 2009, Brent Chiodo.

#    Quick Clip is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import gtk
import pygtk
import hildon
import hildondesktop
import hildonhelp
import commands
import os
import ConfigParser
import subprocess
import osso

history = []
history_target = []
osso_context = osso.Context('com.quickclip.Quickclip','.21', False)

# Main class

# ============================
class statusbar_applet(hildondesktop.StatusbarItem):
   def __init__(self):
      hildondesktop.StatusbarItem.__init__(self)

      self.button = gtk.ToggleButton()
      self.button.set_image(gtk.image_new_from_file("/usr/share/icons/hicolor/40x40/hildon/quick_clip-40x40.png"))
      self.button.set_name("hildon-statusbar-button-one")
      self.button.set_size_request(40,40)
      self.button.connect("clicked",self.popup_menu)
      self.add(self.button)
      self.show_all()

# Main menu

   def create_menu(self):
      self.menu = gtk.Menu()

      settings = self.get_settings()

      if settings['default_menu_positioning'] == 0:
         self.default_menu_positioning_func()
         self.menu.append(gtk.SeparatorMenuItem())

      self.create_parent_func()

      if settings['default_menu_positioning'] == 1:
         self.menu.append(gtk.SeparatorMenuItem())
         self.default_menu_positioning_func()

      self.menu.set_name("menu_from_statusbar")
      self.menu.connect("selection-done", self.menu_done)
      self.menu.show_all()

   def default_menu_positioning_func(self):

      menu_group = gtk.MenuItem("Options")
      self.menu.append(menu_group)

      self.submenu = gtk.Menu()
      about_item = gtk.MenuItem("About Quick Clip")
      manage_item = gtk.MenuItem("Manage Files...")
      settings_item = gtk.MenuItem("Settings...")
      donations_item = gtk.MenuItem("Donations")
      help_item = gtk.MenuItem("Help")
      self.submenu.append(about_item)
      self.submenu.append(manage_item)
      self.submenu.append(settings_item)
      self.submenu.append(donations_item)
      self.submenu.append(help_item)
      about_item.connect('activate',self.about_dialog)
      manage_item.connect('activate',self.manage_files)
      settings_item.connect('activate',self.settings)
      donations_item.connect('activate',self.donations)
      help_item.connect('activate',self.help)
      menu_group.set_submenu(self.submenu)

      self.history_menu()

# Main menu call

   def popup_menu(self,widget,data=None):
      if (self.button.get_active() == True) :
         self.create_menu()
         self.menu.popup(None,None,self.menu_position,0,gtk.get_current_event_time())

# Cleaup?

   def menu_done(self, widget, data=None):
      self.button.set_active(False)
      self.menu.destroy()

   def menu_position(self,data=None):
      (reqw, reqh) = self.menu.size_request()
      (x,y) = self.button.get_parent_window().get_position()
      button_allocation = self.button.get_allocation()
      y = y + button_allocation.y + button_allocation.height
      x = x + button_allocation.x + button_allocation.width - reqw
      return (x,y,True)
# ============================      

# About dialog

   def about_dialog(self,widget,data=None):
      about_quick_clip = gtk.AboutDialog()
      about_quick_clip.set_name("Quick Clip")
      about_quick_clip.set_version("0.3.0")
      about_quick_clip.set_logo(gtk.gdk.pixbuf_new_from_file("/usr/share/icons/hicolor/40x40/hildon/quick_clip-40x40.png"))
      about_quick_clip.set_comments("""
The fast and easy way to copy and save information.
""")
      about_quick_clip.set_copyright("Copyright 2009, Brent Chiodo")
      about_quick_clip.set_license("""This program is free software: you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation, either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more
details.

You should have received a copy of the GNU General Public
License along with this program.  If not, see
<http://www.gnu.org/licenses/>.""")

      authors = ["Brent Chiodo <bchiodo@gmail.com>"]
      about_quick_clip.set_authors(authors)
      about_quick_clip.run()
      about_quick_clip.destroy()

# Settings dialog

   def settings(self,widget,data=None):

      settings_dialog = gtk.Dialog("Quick Clip Settings",None,gtk.DIALOG_MODAL)
      ok_button = settings_dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      cancel_button = settings_dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)
      reset_button = settings_dialog.add_button("Reset", 42)

      settings = self.get_settings()

      path_entry = gtk.Entry()
      path_button = gtk.Button("Open")
      view_entry = gtk.Entry()
      edit_entry = gtk.Entry()

      path_entry.set_width_chars(30)
      view_entry.set_width_chars(30)
      edit_entry.set_width_chars(30)

      path_entry.set_text(settings['path'])
      view_entry.set_text(settings['view_program'])
      edit_entry.set_text(settings['edit_program'])

      use_date_stamp_checkbutton = gtk.CheckButton("Use Date Stamp")
      use_separater_checkbutton = gtk.CheckButton("Use Separater")

      combobox = gtk.combo_box_new_text()
      combobox.set_size_request(300, -1)
      combobox.append_text("Top")
      combobox.append_text("Bottom")

      ok_button.connect('clicked', self.settings_callback, path_entry, view_entry, edit_entry, use_date_stamp_checkbutton, use_separater_checkbutton, combobox)
      reset_button.connect('clicked', self.set_default_settings)
      path_button.connect('clicked', self.path_button_callback, path_entry)

      use_date_stamp_checkbutton.set_active(settings['use_date_stamp'])
      use_separater_checkbutton.set_active(settings['use_separater'])

      combobox.set_active(settings['default_menu_positioning'])

      path_hbox = gtk.HBox()
      path_button_hbox = gtk.HBox()
      view_hbox = gtk.HBox()
      edit_hbox = gtk.HBox()
      checkbox_hbox = gtk.HBox()
      combobox_hbox = gtk.HBox()

      path_hbox.pack_start(gtk.Label("Storage Path:"), False, 5, 10)
      path_hbox.pack_end(path_entry)
      view_hbox.pack_start(gtk.Label("View Program:"), False, 5, 5)
      view_hbox.pack_end(view_entry)
      edit_hbox.pack_start(gtk.Label("Edit Program:"), False, 5, 9)
      edit_hbox.add(edit_entry)
      checkbox_hbox.pack_start(use_date_stamp_checkbutton, False, 5, 70)
      checkbox_hbox.pack_end(use_separater_checkbutton, False, 5, 70)
      combobox_hbox.pack_start(gtk.Label("Options/History Displayed:"), False, 5, 60)
      combobox_hbox.pack_end(combobox, False, 5, 70)

      path_button_hbox.pack_start(path_hbox)
      path_button_hbox.pack_end(path_button)

      settings_dialog.vbox.pack_start(path_button_hbox, True, 15, 8)
      settings_dialog.vbox.pack_start(view_hbox, True, 15, 8)
      settings_dialog.vbox.pack_start(edit_hbox, True, 15, 8)
      settings_dialog.vbox.pack_start(checkbox_hbox, True, 15, 8)
      settings_dialog.vbox.pack_end(combobox_hbox, True, 10, 15)

      hildonhelp.help_dialog_help_enable(settings_dialog, "osso_quickclip_settings", osso_context)

      settings_dialog.show_all()
      settings_dialog.run()     
      settings_dialog.destroy()

   def path_button_callback(self, widget, path_entry):
      dialog = gtk.FileChooserDialog("Choose Path", None, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER, (gtk.STOCK_OPEN, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))
      response = dialog.run()

      if response == gtk.RESPONSE_OK:
         path = dialog.get_filename()
         if path == "/":
            pass
         else:
            path = path + "/"
      else:
         dialog.destroy()
         return None

      dialog.destroy()
      path_entry.set_text(path)

# Settings Dialog entry callback

   def settings_callback(self, widget, path_entry, view_entry, edit_entry, use_date_stamp_checkbutton, use_separater_checkbutton, combobox):
      path = path_entry.get_text()
      view_program = view_entry.get_text()
      edit_program = edit_entry.get_text()
      use_date_stamp = use_date_stamp_checkbutton.get_active()
      use_separater = use_separater_checkbutton.get_active()
      default_menu_positioning = combobox.get_active()
      print default_menu_positioning

      self.set_settings(path, view_program, edit_program, use_date_stamp, use_separater, default_menu_positioning)

# Manage files dialog

   def manage_files(self, widget, data=None):
      files_dialog = gtk.Dialog("Manage Your Target Files",None,gtk.DIALOG_MODAL)
      ok_button = files_dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      cancel_button = files_dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

      new_file_button = gtk.Button("New")
      delete_file_button = gtk.Button("Delete")
      rename_button = gtk.Button("Rename")
      up_button = gtk.Button()
      up_button.set_image(gtk.image_new_from_file("/usr/share/icons/hicolor/26x26/hildon/qgn_indi_arrow_up.png"))
      down_button = gtk.Button()
      down_button.set_image(gtk.image_new_from_file("/usr/share/icons/hicolor/26x26/hildon/qgn_indi_arrow_down.png"))

      new_file_button.set_size_request(150, 50)
      delete_file_button.set_size_request(150, 50)
      rename_button.set_size_request(150, 50)
      up_button.set_size_request(150, 50)
      down_button.set_size_request(150, 50)

      hbox = gtk.HBox()
      main_vbox = gtk.VBox()
      list_vbox = gtk.VBox()

      main_vbox.pack_start(new_file_button, True, 5, 5)
      main_vbox.pack_start(delete_file_button, True, 5, 5)
      main_vbox.pack_start(rename_button, True, 5, 5)
      main_vbox.pack_start(up_button, True, 5, 5)
      main_vbox.pack_start(down_button, True, 5, 5)

      liststore = gtk.ListStore(str)

      files_list = self.get_files()

      for item in files_list:
         liststore.append([item])

      treeview = gtk.TreeView(liststore)
      treeview.set_reorderable(True)
      tvcolumn = gtk.TreeViewColumn('Column 0')
      treeview.append_column(tvcolumn)
      cell = gtk.CellRendererText()
      tvcolumn.pack_start(cell, True)
      tvcolumn.add_attribute(cell, 'text', 0)

      scrolled_window = gtk.ScrolledWindow()
      scrolled_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
      scrolled_window.set_size_request(400, -1)
      scrolled_window.add(treeview)

      list_vbox.pack_start(scrolled_window, True, 5, 5)

      hbox.pack_start(list_vbox, True, 5, 5)
      hbox.pack_end(main_vbox, True, 5, 5)

      files_dialog.vbox.pack_start(hbox)

      ok_button.connect('clicked', self.ok_button_callback, treeview)
      new_file_button.connect('clicked', self.new_file_button_dialog, liststore)
      delete_file_button.connect('clicked', self.delete_file_button_callback, liststore, treeview)
      rename_button.connect('clicked', self.rename_button_callback, liststore, treeview)
      up_button.connect('clicked', self.up_button_callback, liststore, treeview)
      down_button.connect('clicked', self.down_button_callback, liststore, treeview)

      hildonhelp.help_dialog_help_enable(files_dialog, "osso_quickclip_manage", osso_context)

      files_dialog.show_all()
      files_dialog.run()     
      files_dialog.destroy()

# OK button callback

   def ok_button_callback(self, widget, treeview):
      files_list = treeview.get_model()               
      self.set_files(files_list)

# New file dialog

   def new_file_button_dialog(self, widget, liststore):

      dialog = gtk.Dialog("Enter New Name",None,gtk.DIALOG_MODAL)
      dialog.set_size_request(300, -1)
      ok_button = dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      cancel_button = dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

      entry = gtk.Entry(20)

      ok_button.connect('clicked', self.new_file_entry_callback, entry, liststore)

      dialog.vbox.pack_start(entry, True, 10, 10)

      dialog.show_all()
      dialog.run()     
      dialog.destroy()

# New file callback

   def new_file_entry_callback(self, widget, entry, liststore):
      text = entry.get_text()
      if text == "":
         return
      liststore.append([text])

# Delete file callback

   def delete_file_button_callback(self, widget, liststore, treeview):
      selection = treeview.get_selection()
      model, treeiter = selection.get_selected()
      if treeiter is not None:
         model.remove(treeiter)

# Rename file dialog

   def rename_button_callback(self, widget, liststore, treeview):

      dialog = gtk.Dialog("Enter New Name",None,gtk.DIALOG_MODAL)
      dialog.set_size_request(300, -1)
      ok_button = dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      cancel_button = dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

      entry = gtk.Entry(20)

      ok_button.connect('clicked', self.rename_file_entry_callback, entry, liststore, treeview)

      dialog.vbox.pack_start(entry, True, 10, 10)

      dialog.show_all()
      dialog.run()     
      dialog.destroy()

# Rename file callback

   def rename_file_entry_callback(self, widget, entry, liststore, treeview):
      text = entry.get_text()
      if text == "":
         return

      selection = treeview.get_selection()
      model, treeiter = selection.get_selected()
      liststore.set(treeiter, 0 , text)

# Up  button callback

   def up_button_callback(self, widget, liststore, treeview):
      selection = treeview.get_selection()
      model, treeiter = selection.get_selected()
      path = liststore.get_path(treeiter)
      a_row = path[0]
      b_row = a_row - 1
      a = treeiter
      b = liststore.get_iter(b_row)
      liststore.swap(a, b)

# Down button callback

   def down_button_callback(self, widget, liststore, treeview):
      selection = treeview.get_selection()
      model, treeiter = selection.get_selected()
      path = liststore.get_path(treeiter)
      a_row = path[0]
      b_row = a_row + 1
      a = treeiter
      b = liststore.get_iter(b_row)
      liststore.swap(a, b)

# Donations

   def donations(self, widget, data=None):
      dialog = gtk.Dialog("Donate to Quick Clip",None,gtk.DIALOG_MODAL)
      dialog.set_size_request(700, 375)
      close_button = dialog.add_button(gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE)
      donate_button = dialog.add_button("Danate", 1)

      sw = gtk.ScrolledWindow()
      sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
      textview = gtk.TextView()
      textview.set_sensitive(False)
      textbuffer = textview.get_buffer()
      textview.set_wrap_mode(gtk.WRAP_WORD)
      textbuffer.set_text("""Quick Clip is completely free to use, modify, distribute, and enjoy. But if you like using Quick Clip, please consider making a donation. Donations not only help to offset the cost of development, but can possibly guilt me in to fixing bugs or adding new features.

If you would like to help support Quick Clip, just click the "Donate" button below (donations can be any amount of your choosing).

Thank you,
Brent Chiodo""")
      sw.add(textview)

      dialog.vbox.pack_start(sw)

      sw.show()
      textview.show()

      response = dialog.run()

      if response == 1:
         subprocess.Popen('/usr/bin/dbus-send --print-reply --dest=com.nokia.osso_browser /com/nokia/osso_browser com.nokia.osso_browser.mime_open string:"http://brentdc.maemobox.org/donate.html"', shell=True)

      dialog.destroy()

# Main Help

   def help(self, widget, data=None):
      hildonhelp.help_show(osso_context, "osso_quickclip_intro", 0)

# Create parent file group

   def create_parent_func(self):

      files_list = self.get_files()

      for item in files_list:
         menu_group = gtk.MenuItem(item)
         self.menu.append(menu_group)

         self.submenu = gtk.Menu()
         menu_selection = gtk.MenuItem("Selection >> File")
         menu_entry = gtk.MenuItem("Entry >> File")
         menu_view = gtk.MenuItem("View")
         menu_edit = gtk.MenuItem("Edit")
         self.submenu.append(menu_selection)
         self.submenu.append(menu_entry)
         self.submenu.append(menu_view)
         self.submenu.append(menu_edit)
         menu_selection.connect('activate', self.clip_selection, item)
         menu_entry.connect('activate', self.entry_dialog, item)
         menu_view.connect('activate', self.view_file, item)
         menu_edit.connect('activate', self.edit_file, item)
         menu_group.set_submenu(self.submenu)

# The Entry >> File dialog

   def entry_dialog(self, widget, name):
      entry_dialog = gtk.Dialog("Enter Text Here",None,gtk.DIALOG_MODAL)
      entry_dialog.set_size_request(600, 300)
      ok_button = entry_dialog.add_button(gtk.STOCK_OK, gtk.RESPONSE_OK)
      cancel_button = entry_dialog.add_button(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL)

      sw = gtk.ScrolledWindow()
      sw.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
      textview = gtk.TextView()
      textview.set_wrap_mode(gtk.WRAP_WORD)
      textbuffer = textview.get_buffer()
      sw.add(textview)
      sw.show()
      textview.show()

      ok_button.connect("clicked", self.entry_dialog_callback, name, textbuffer)

      entry_dialog.vbox.pack_start(sw)

      entry_dialog.show_all()
      entry_dialog.run()     
      entry_dialog.destroy()

# Function to get text from the textbuffer

   def entry_dialog_callback(self, widget, name, textbuffer):

      text = textbuffer.get_text(*textbuffer.get_bounds())

      if text == "":
         return

      self.clip_entry(name, text)

# Clip selection function

   def clip_selection(self, widget, name):
      date_stamp = commands.getoutput('date +"%m/%d/%y, %l:%M %p: "')

      clipboard = gtk.clipboard_get("PRIMARY")
      clip = clipboard.wait_for_text()
      separater = "______"

      if clip == None:
         hildon.hildon_banner_show_information(self, "qgn_note_gene_syswarning", "Nothing Selected!")
         return 0

      try:
         settings = self.get_settings()
         open_file = open(settings['path'] + name + '.txt', 'a')

         file_contents = '\n\n'

         if settings['use_date_stamp']:
            file_contents = file_contents + date_stamp

         file_contents = file_contents + clip

         if settings['use_separater']:
            file_contents = file_contents + '\n' + separater

         open_file.write(file_contents)
         hildon.hildon_banner_show_information(self, "qgn_indi_voip_clear_summary", "Clipped!")

      except Exception:
         hildon.hildon_banner_show_information(self, "qgn_note_gene_syserror", "Error Clipping...")

      history_file = name
      self.set_history(clip, history_file)

      open_file.close()

      clip = ""

# Clip entry

   def clip_entry(self, name, text):
      date_stamp = commands.getoutput('date +"%m/%d/%y, %l:%M %p: "')
      separater = "______"

      settings = self.get_settings()
      open_file = open(settings['path'] + name + '.txt', 'a')

      file_contents = '\n\n'

      if settings['use_date_stamp']:
         file_contents = file_contents + date_stamp

      file_contents = file_contents + text

      if settings['use_separater']:
         file_contents = file_contents + '\n' + separater

      open_file.write(file_contents)

      history_file = name
      self.set_history(text, history_file)

      open_file.close()

# View function

   def view_file(self, widget, name):

      settings = self.get_settings()
      if settings['view_program'] == "$builtin":
         command = '/usr/bin/quickclip_viewer.py "%s"' % (settings['path'] + name)
         command = command + '.txt'
         subprocess.Popen(command, shell=True)
      else:
         command = settings['view_program'] % (settings['path'] + name)
         command = command + '.txt'
         subprocess.Popen(command, shell=True)

# Edit function

   def edit_file(self, widget, name):

      settings = self.get_settings()
      command = settings['edit_program'] % (settings['path'] + name)
      command = command + '.txt'
      subprocess.Popen(command, shell=True)

# History menu

   def history_menu(self):

      menu_group = gtk.MenuItem("History")
      self.menu.append(menu_group)

      self.submenu = gtk.Menu()
      if len(history) == 0:

         history_label = gtk.MenuItem("(No History)")
         history_label.set_sensitive(False)
         history_label.modify_fg(gtk.STATE_INSENSITIVE, None)
         self.submenu.append(history_label)

      for item in history:
         name = item
         target_index = history.index(item)
         self.set_history_menu(name, target_index, self.submenu)

      menu_group.set_submenu(self.submenu)

   def set_history_menu(self, name, target_index, submenu):
      menu_item = gtk.MenuItem(name)
      self.submenu.append(menu_item)
      menu_item.connect("activate", self.view_file, history_target[target_index])

# Set History

   def set_history(self, item, target_item):
      if len(item) > 50:
         item = item[0:50]
         item = item + "..."

      item = item.replace('\n', ' ')

      history_target.insert(0, target_item)
      history.insert(0, item)

      if len(history_target) > 10:
         del history[-1]

      if len(history) > 10:
         del history[-1]

# Get parent files

   def get_files(self):

      parent_file = open('/home/user/.quickclip/parent_files', 'r')
      parent_file.seek(0)
      file_contents = parent_file.readlines()

      files_list = []

      for line in file_contents:
         name = line
         name = name.strip('\n')
         files_list.append(name)

      return files_list

# Set parent files

   def set_files(self, files):

      parent_file = open('/home/user/.quickclip/parent_files', 'w')

      count = 0

      for item in files:
         parent_file.write(item[0])

         if count < len(files):
            parent_file.write('\n')

      parent_file.close()

# Get User's settings

   def get_settings(self):

      user_config_file = open('/home/user/.quickclip/user.conf', 'r')
      user_config_access = ConfigParser.RawConfigParser()
      user_config_access.readfp(user_config_file)

      settings_dict = {}
      settings_dict['path'] = user_config_access.get('DEFAULT', 'path')
      settings_dict['view_program'] = user_config_access.get('DEFAULT', 'view_program')
      settings_dict['edit_program'] = user_config_access.get('DEFAULT', 'edit_program')
      settings_dict['use_date_stamp'] = user_config_access.get('DEFAULT', 'use_date_stamp')
      settings_dict['use_separater'] = user_config_access.get('DEFAULT', 'use_separater')
      settings_dict['default_menu_positioning'] = user_config_access.get('DEFAULT', 'default_menu_positioning')

      settings_dict['use_date_stamp'] = self.get_settings_helper(settings_dict['use_date_stamp'])
      settings_dict['use_separater'] = self.get_settings_helper(settings_dict['use_separater'])
      settings_dict['default_menu_positioning'] = self.get_settings_helper(settings_dict['default_menu_positioning'])

      user_config_file.close()

      return settings_dict

   def get_settings_helper(self, value):
      if value == "True":
         return True
      if value == "False":
         return False
      if value == "1":
         return 1
      if value == "0":
         return 0

# Set settings...done through gui

   def set_settings(self, path, view_program, edit_program, use_date_stamp, use_separater, default_menu_positioning):

      user_config_file = open('/home/user/.quickclip/user.conf', 'w')
      user_config_access = ConfigParser.RawConfigParser()

      user_config_access.set('DEFAULT', 'path', path)
      user_config_access.set('DEFAULT', 'view_program', view_program)
      user_config_access.set('DEFAULT', 'edit_program', edit_program)
      user_config_access.set('DEFAULT', 'use_date_stamp', use_date_stamp)
      user_config_access.set('DEFAULT', 'use_separater', use_separater)
      user_config_access.set('DEFAULT', 'default_menu_positioning', default_menu_positioning)

      user_config_access.write(user_config_file)
      user_config_file.close()

# Set default settings

   def set_default_settings(self, widget, data=None):

      user_config_file = open('/home/user/.quickclip/user.conf', 'w')
      user_config_access = ConfigParser.RawConfigParser()

      user_config_access.set('DEFAULT', 'path', '/home/user/.quickclip/data/')
      user_config_access.set('DEFAULT', 'view_program', '$builtin')
      user_config_access.set('DEFAULT', 'edit_program', '/usr/bin/dbus-send --print-reply --dest=com.nokia.osso_notes /com/nokia/osso_notes com.nokia.osso_notes.mime_open string:"%s"')
      user_config_access.set('DEFAULT', 'use_date_stamp', True)
      user_config_access.set('DEFAULT', 'use_separater', True)
      user_config_access.set('DEFAULT', 'default_menu_positioning', 0)

      user_config_access.write(user_config_file)
      user_config_file.close()

#====================

# Tests to see if system files exist...

if not os.path.exists('/home/user/.quickclip/'):
   subprocess.Popen('mkdir /home/user/.quickclip', shell=True)

if not os.path.exists('/home/user/.quickclip/data/'):
   subprocess.Popen('mkdir /home/user/.quickclip/data', shell=True)

if not os.path.exists('/home/user/.quickclip/user.conf'):

   user_config_file = open('/home/user/.quickclip/user.conf', 'w')
   user_config_access = ConfigParser.RawConfigParser()

   user_config_access.set('DEFAULT', 'path', '/home/user/.quickclip/data/')
   user_config_access.set('DEFAULT', 'view_program', '$builtin')
   user_config_access.set('DEFAULT', 'edit_program', '/usr/bin/dbus-send --print-reply --dest=com.nokia.osso_notes /com/nokia/osso_notes com.nokia.osso_notes.mime_open string:"%s"')
   user_config_access.set('DEFAULT', 'use_date_stamp', True)
   user_config_access.set('DEFAULT', 'use_separater', True)
   user_config_access.set('DEFAULT', 'default_menu_positioning', 0)

   user_config_access.write(user_config_file)
   user_config_file.close()

if not os.path.exists('/home/user/.quickclip/parent_files'):

   parent_files = open('/home/user/.quickclip/parent_files', 'w')
   parent_files.write('Example File 1\nExample File 2\nEtc...')
   parent_files.close()

# ============================
# Main program

def hd_plugin_get_objects():
   plugin = statusbar_applet()
   return [plugin]
# ============================