/**
 * python-launcher-common.c
 * Common functions used by launcher and daemon.
 *
 * Copyright (C) 2005-2008 INdT - Instituto Nokia de Tecnologia
 *
 * Contact: Luciano Miguel Wolf <luciano.wolf@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include "python-launcher.h"

#include "debug.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>

load_type pl_get_load_opt(void)
{
    char fullpath[PATH_MAX], option;
    int opt_file;
    load_type opt = -1;

    snprintf(fullpath, PATH_MAX, "%s/%s", getenv("HOME"), PL_LOADOPT_FILE);

    opt_file = open(fullpath, O_RDWR | O_CREAT,
                    S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);

    DEBUG ("opt_file fullpath: %s", fullpath);
    DEBUG ("opt_file handler : %d", opt_file);

    if (opt_file < 0) {
        perror("Open loadopt file");
        return PL_STARTUP;
    }

    if (read(opt_file, &option, sizeof(char)) > 0)
        opt = option - '0';

    if (opt < 0 || opt > PL_PYTHON_APP) {
        opt = PL_STARTUP;
        option = (char)opt + '0';
        lseek(opt_file, 0, SEEK_SET);
        if (write(opt_file, &option, sizeof(char)) < 0)
            perror("Writing optfile");
    }
    close(opt_file);

    return opt;
}

/* vim:et:sw=4:ts=4:co=80
 */
