/**
 * debug.h
 * Header file defining debug macros.
 *
 * Copyright (C) 2005-2008 INdT - Instituto Nokia de Tecnologia
 *
 * Contact: Luciano Miguel Wolf <luciano.wolf@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef __DEBUG_H__
#define __DEBUG_H_

#include <stdio.h>

#include "config.h"

#ifdef ENABLE_DEBUG

#define DEBUG(format, ...) \
  fprintf (stderr, "[DEBUG]%s:%s(%d) " format "\n", \
           __FILE__, __FUNCTION__, __LINE__, ##__VA_ARGS__)

#else // !ENABLE_DEBUG

#define DEBUG(format, ...) do {} while (0)

#endif

#endif // __DEBUG_H__

/* vim:et:sw=4:ts=4:co=80
 */
