#!/usr/bin/python
#Import necessary modules
import os
import sys,time,re
import webbrowser
from PyQt4 import QtGui,QtCore
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from pyRadio_ui import *
from pyRadio_ui_portrait import *
from radioplayer import RadioPlayer

import dbus
from dbus.mainloop.glib import DBusGMainLoop

__title__ = "Pandora"
#class for the "sleep" function -- needs a way to cancel properly
class snooze(QtCore.QThread):
	__pyqtSignals__ = ( "shutdown" )
	def __init__(self,ktime,cont=None):
		self.ktime = ktime
		self.cont = cont
		QtCore.QThread.__init__(self)
	def run(self):
		time.sleep(self.ktime*60)
		if self.cont:
			self.emit(QtCore.SIGNAL("shutdown"))

#class for reading configuration files
class Config:
	def __init__(self):
		self.user = ""
		self.password = ""
		self.color = ""
		self.lastplayed = ""
		self.format = "mp3"
		self.rotation = "automatic"
		self.protocol_version = "0"
		self.proxy = ""
		#I loop through possible configuration options in this array
		self.config_opts = ['user','password','format','rotation','proxy','protocol_version']

	def write(self): #write the configuration files
		if not os.path.exists(os.path.expanduser("~")+'/.config'):
			os.mkdir(os.path.expanduser("~")+'/.config')

		if not os.path.exists(os.path.expanduser("~")+'/.config/pyradio'):
			os.mkdir(os.path.expanduser("~")+'/.config/pyradio')
		newfile = "user="+self.user+"\npassword="+self.password+"\n"+"format="+self.format+"\n"
		newfile += "rotation="+self.rotation+"\n"+"protocol_version="+self.protocol_version+"\n"
		newfile += "proxy="+self.proxy+"\n"
		f = open(os.path.expanduser("~")+'/.config/pyradio/config', 'w')
		f.write(newfile)
		f.close()

	def load(self): #load the configuration files
		if os.path.exists('/etc/hildon/theme/colors.config'): #get system colors
			f = open('/etc/hildon/theme/colors.config')
			for line in f:
				if re.match("ActiveTextColor\s*=",line):
					self.color = re.match("ActiveTextColor\s*=(.+)",line).group(1).lstrip().rstrip()

			if self.color == "":
				self.color = "rgb(255, 255, 255)"

		else: #default to white
			self.color = "rgb(255, 255, 255)"

		#open main configuration file
		if os.path.exists(os.path.expanduser("~")+'/.config/pyradio/config'):
			f = open(os.path.expanduser("~")+'/.config/pyradio/config', 'r')
			for line in f:
				line = line.replace(" ", "")

				if re.match("^#.*",line) is not None: #skip comments
					continue

				for opt in self.config_opts: #check each line for an option
					if re.match("^"+opt+"=(.+)$",line) is not None:
						setattr(self,opt,self.get_var(opt,line))
			f.close()

		#get lastplayed station to auto-start
		if os.path.exists(os.path.expanduser("~")+'/.config/pyradio/lastplayed'):
			f = open(os.path.expanduser("~")+'/.config/pyradio/lastplayed', 'r')
			self.lastplayed = f.readline().replace("\n","")
			f.close()

	def get_var(self,var,line):
		r = re.match("^"+var+"=(.+)$",line)
		return r.group(1)

class Panda(QtGui.QMainWindow): #main class
	def __init__( self, parent=None ):
		QtGui.QMainWindow.__init__(self, parent)
		self.c = Config()
		self.c.load()
		self.s = snooze( 0 )
		self.song = 0
		self.stimer = QTimer()
		self.manualPause = False #track manual pausing
		self.curStation = 0 #Currently playing station
		self.ui = Ui_pyRadio()
		self.ui.setupUi(self)
		self.stations = None
		self.ui.btnLove.setStyleSheet("background-image: url(:/img/img/thumbup_small.png);\nborder: rgb(0, 0, 0);\nbackground-color: rgb(100, 100, 100);")
		self.ui.btnHate.setStyleSheet("background-color: rgb(100, 100, 100);\nborder: rgb(255, 255, 255);\nbackground-image: url(:/img/img/thumbdwn_small.png);")
		self.player = RadioPlayer()
		self.os = self.player.get_product()
		if self.os != "RX-51": #check for N900
			self.ui.albumArt.setStyleSheet("background-color: rgb(255, 255, 255);")
		self.ui.albumArt.setHtml( "<table width='100%' height='100%'><tr height='100%'><td height='100%' valign='middle'><font style='color: #fff'>Pandora is loading... </font></td><tr></table>" )
		QtGui.QApplication.processEvents()
		self.player.format = self.c.format
		self.player.protocol_version = int(self.c.protocol_version)
		self.player.proxy = self.c.proxy
		if not self.c.lastplayed == "": #auto-play last station
			self.autoPlay = self.c.lastplayed
		else:
			self.autoPlay = 0
		self.connect_signals() #called every time orientation changes to connect slots
		self.player.start()
		self.stimer.singleShot(100, self.auth)
		self.doFM(True)
		try: #test for rotation and set auto-rotation on
		    self.connect(QApplication.desktop(), SIGNAL("resized(int)"), self.orientationChanged );
		    if self.c.rotation == 'automatic':
		        self.setAttribute(Qt.WA_Maemo5AutoOrientation, 1)
		        screenGeometry=QApplication.desktop().screenGeometry();
		        if screenGeometry.width() > screenGeometry.height():
		            self.portrait = False
		        else:
		            self.portrait = True
		            print "Auto rotation on"
		    elif self.c.rotation == 'portrait':
		        self.setAttribute(Qt.WA_Maemo5PortraitOrientation, 1)
		    elif self.c.rotation == 'landscape':
		        self.setAttribute(Qt.WA_Maemo5LandscapeOrientation, 1)
		except:
		    print "could not autorotate on",

#Radio Functions
	def doPlayPause( self ): #Play if stopped, pause if playing
		self.manualPause = True
		if self.player.state == 2:
			self.player.startPlayBack()
			self.ui.btnPlay.setStyleSheet("background-color: "+ self.c.color +";\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/Play_small.png);")
		elif self.player.state == 1:
			self.player.stopPlayBack()
			self.ui.btnPlay.setStyleSheet("background-color: rgb(0, 0, 0);\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/Play_small.png);")

	def handleStates( self ): #receive signals from Backend if changed from somewhere else (ie: headphones)
		if self.manualPause: #Don't want to overlap with calling doPlayPause
			self.manualPause = False
			return
		if self.player.state == 2:
			self.player.stopPlayBack()
			self.ui.btnPlay.setStyleSheet("background-color: rgb(0, 0, 0);\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/Play_small.png);")
		elif self.player.state == 1:
			self.player.startPlayBack()
			self.ui.btnPlay.setStyleSheet("background-color: "+ self.c.color +";\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/Play_small.png);")

	def doLove( self ): #Love this song
		self.ui.btnLove.setStyleSheet("background-color: "+ self.c.color +";\n"
		"border: rgb(0, 0, 0);\nbackground-image: url(:/img/img/thumbup_small.png);")
		self.song[1]["rating"] = 1
		self.stimer.singleShot(100, self.loveCall)

	def loveCall( self ):
		if not self.player.loveHate( self.song, True ):
			self.ui.btnLove.setStyleSheet("background-color: rgb(100, 100, 100);\n"
			"border: rgb(0, 0, 0);\nbackground-image: url(:/img/img/thumbup_small.png);")
		else:
			print "Thumbs up successful."

	def doHate( self ): #Hate this song
		if self.player.loveHate( self.song, False ):
			self.playNextSong()

	def tiredSong( self ): #Mark song tired
		res = self.player.doTired( self.song )
		if res:
			self.playNextSong()
		print res

	def deleteStation( self ):
		reply = QtGui.QMessageBox.question(self, 'Delete Station',
			"Really delete "+self.ui.listStations.currentText()+"?", QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
		if reply == QtGui.QMessageBox.Yes:
			self.ui.btnPlay.setStyleSheet("background-color: "+ self.c.color + ";\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/Play_small.png);")
			self.doPlayPause()
			self.player.doDelete(self.curStation)
			self.ui.albumArt.setHtml( "<table width='100%' height='100%'><tr height='100%'><td height='100%' valign='middle'><font style='color: #fff'>Station Deleted.  Select new station to begin.</font></td><tr></table>" )
			self.getStations()

	def auth( self, count=0 ): #Start authentication process.
		if count>2:
			self.closeEvent()
		count += 1
		ok = True #In case we got the user/pass from config
		if self.c.user == "":
			self.c.user,ok = QtGui.QInputDialog.getText(self,"Username", "Pandora Username:", QLineEdit.Normal)
		if not ok: #Username was cancelled.. they must be done.
			self.closeEvent()
		if self.c.password == "":
			self.c.password,ok = QtGui.QInputDialog.getText(self,"Password", "Pandora Password:", QLineEdit.Password)
		if not ok: #Password was cancelled.. they must be done.
			self.closeEvent()
		self.ui.albumArt.setHtml( "<table width='100%' height='100%'><tr height='100%'><td height='100%' valign='middle'><font style='color: #fff'>Authenticating to Pandora as "+self.c.user+" ... </font></td><tr></table>" )
		QtGui.QApplication.processEvents()
		authenticated = self.player.auth( self.c.user, self.c.password )
		if not authenticated:
			self.c.user = ""
			self.c.password = ""
			self.auth( count )
		else:
			if str(self.player.pandora.protocol_version) != self.c.protocol_version:
			    self.c.protocol_version = str(self.player.pandora.protocol_version)
			self.ui.albumArt.setHtml( "<table width='100%' height='100%'><tr height='100%'><td height='100%' valign='middle'><font style='color: #fff'>Authentication successful.  Select a station from list to the right.</font></td><tr></table>" )
			QtGui.QApplication.processEvents()
			self.c.write()
			self.getStations()

	def playStation( self ): #Play currently selected station
		stationId = self.stations[self.ui.listStations.currentIndex()]['stationId']
		self.curStation = stationId
		self.player.playlist = []
		self.player.getMoreSongs( self.curStation, self.c.format )
		self.playNextSong()
		if stationId != self.c.lastplayed:
			f = open(os.path.expanduser("~")+'/.config/pyradio/lastplayed', 'w')
			f.write(self.curStation)
			f.close()

	def getStations( self ): #Get Station List
		self.ui.listStations.clear()
		self.stations = self.player.getStations()
		for s in self.stations: #Stations need to be scanned for QuickMix seperately
			if s["isQuickMix"]:
				qMixIds = s["quickMixStationIds"]
				break

		for s in self.stations: #Add stations
			#print s
			#print ""
			sName = s["stationName"]
			for qMixId in qMixIds:
				if qMixId == s["stationId"]:
					sName += " *" #If we're in the QuickMix list we add a *
			self.ui.listStations.addItem(sName)
			if self.autoPlay>0 and s["stationId"] == self.autoPlay:
				self.autoPlay = 0
				self.ui.listStations.setCurrentIndex(self.ui.listStations.count()-1)
				self.playStation()

			if self.curStation>0 and s["stationId"] == self.curStation:
				self.ui.listStations.setCurrentIndex(self.ui.listStations.count()-1)

	def setUserPass( self ): #Reset username/password and start authenticating
		self.c.user = ""
		self.c.password = ""
		self.auth()

	def playNextSong( self ): #Go to next song in playlist
		QtGui.QApplication.processEvents()
		if not self.player.playlist == []:
			if self.player.state == 1:
				self.doPlayPause()
			print "Getting next song.."
			self.song = self.player.playlist.pop( 0 )
			self.setUi( self.song )
			self.stimer.singleShot(100, lambda: self.player.play(self.song[0], self.song))
			if self.player.playlist == []:
				self.stimer.singleShot(500, lambda: self.player.getMoreSongs(self.curStation, self.c.format))
		else:
			self.player.getMoreSongs(self.curStation, self.c.format)
			self.stimer.singleShot(100, self.playNextSong)

	def stop( self ): #Stop Playing, not currently implemented
		print "Temp"

	def closeEvent(self, event=None): #Exit application gracefully.. somewhat.
		self.player.run = 0
		self.player.close()
		del self.ui
		del self.player
		quit()

#UI Functions
	def setUi ( self, next=None ): #Update the album graphic and set Love graphic
		art = next[1]["art"]
		self.ui.btnPlay.setStyleSheet("background-color: "+ self.c.color +";\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/Play_small.png);")
		self.ui.albumArt.setHtml("<table width='100%' height='100%'><tr><td vertical-align='middle' style='text-align: center'><img style='width: 80%; height: 100%' src='"+art+"'></td></tr></table>")
		self.ui.lblSong.setText("\"" + next[1]["title"] + "\"\nArtist: " + next[1]["artist"])
		if next[1]["rating"] > 0:
			self.ui.btnLove.setStyleSheet("background-color: "+ self.c.color + ";\n"
			"border: rgb(0, 0, 0);\nbackground-image: url(:/img/img/thumbup_small.png);")
		else:
			self.ui.btnLove.setStyleSheet("background-image: url(:/img/img/thumbup_small.png);\nborder: rgb(0, 0, 0);\nbackground-color: rgb(100, 100, 100);")

		self.ui.btnPlay.setStyleSheet("background-image: url(:/img/img/Play_small.png);\nborder: rgb(0, 0, 0);\nbackground-color: "+ self.c.color + ";")

	def nextDown(self): #change button color
		self.ui.btnNext.setStyleSheet("background-color: " + self.c.color + ";\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/next_small.png);")

	def nextUp(self): #change button color
		self.ui.btnNext.setStyleSheet("background-color: rgb(0, 0, 0);\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/next_small.png);")

	def hateDown(self): #change button color
		self.ui.btnHate.setStyleSheet("background-color: " + self.c.color + ";\nborder: rgb(0, 0, 0);\nbackground-image: url(:/img/img/thumbdwn_small.png);")

	def hateUp(self): #change button color
		self.ui.btnHate.setStyleSheet("background-color: rgb(100, 100, 100);\nborder: rgb(255, 255, 255);\nbackground-image: url(:/img/img/thumbdwn_small.png);")

	def setDuration( self, pos, total ):
		if (total-pos) < total:
			position = "%02d:%02d" % divmod(total - pos, 60) + " / " + "%02d:%02d" % divmod(total, 60)
			self.ui.lblTime.setText(position + "\nAlbum: " + self.song[1]["album"])

#Feature Functions

	def setSnooze(self): #Set tired
		ktime,ok = QtGui.QInputDialog.getText(self,"Snooze", "Enter a time, in minutes, to shutdown:")
		if ok:
			self.s.cont = 1
			self.s.ktime = int(ktime)
			self.s.start()

	def doFM(self, initial=False): #Turn on FM transmitter
		try : #test for FM transmitter.
			sysbus = dbus.SystemBus()
			fmtx = sysbus.get_object('com.nokia.FMTx', '/com/nokia/fmtx/default', False)
			fmtx_iface = dbus.Interface(fmtx, dbus_interface='org.freedesktop.DBus.Properties')

			state = fmtx_iface.Get("com.nokia.FMTx.Device", "state")
			if state == 'disabled':
				if not initial:
					self.ui.actionEnable_FM_Radio.setText(QtGui.QApplication.translate("pyRadio", "Disable FM Tx", None, QtGui.QApplication.UnicodeUTF8))
					fmtx_iface.Set("com.nokia.FMTx.Device", "state", dbus.String(u'%s' % 'enabled', variant_level=1))
				else:
					self.ui.actionEnable_FM_Radio.setText(QtGui.QApplication.translate("pyRadio", "Enable FM Tx", None, QtGui.QApplication.UnicodeUTF8))
			else:
				if not initial:
					self.ui.actionEnable_FM_Radio.setText(QtGui.QApplication.translate("pyRadio", "Enable FM Tx", None, QtGui.QApplication.UnicodeUTF8))
					fmtx_iface.Set("com.nokia.FMTx.Device", "state", dbus.String(u'%s' % 'disabled', variant_level=1))
				else:
					self.ui.actionEnable_FM_Radio.setText(QtGui.QApplication.translate("pyRadio", "Disable FM Tx", None, QtGui.QApplication.UnicodeUTF8))
		except:
			self.ui.actionEnable_FM_Radio.setText(QtGui.QApplication.translate("pyRadio", "Set Max Volume", None, QtGui.QApplication.UnicodeUTF8))
			if not initial:
				self.player.setVolume( 100 )

#Orientation Control

	def orientationChanged ( self ): #called when N900 is rotated
		screenGeometry=QApplication.desktop().screenGeometry();
		self.disconnect_signals()
		if screenGeometry.width() > screenGeometry.height(): #landscape
			self.ui = Ui_pyRadio()
			self.ui.setupUi(self)
			self.connect_signals()
			self.portrait = False
		else: #portrait
			self.ui = Ui_pyRadio_portrait()
			self.ui.setupUi(self)
			self.connect_signals()
			self.portrait = True
		print "Orientation Changed"
		self.ui.lblTime.setWordWrap( True )
		self.ui.btnLove.setStyleSheet("background-image: url(:/img/img/thumbup_small.png);\nborder: rgb(0, 0, 0);\nbackground-color: rgb(100, 100, 100);")
		self.ui.btnHate.setStyleSheet("background-color: rgb(100, 100, 100);\nborder: rgb(255, 255, 255);\nbackground-image: url(:/img/img/thumbdwn_small.png);")
		if self.song:
			self.setUi( self.song )
			self.stimer.singleShot(100, self.getStations)

	def connect_signals( self ): #connect all signals
		QtCore.QObject.connect(self.ui.listStations, QtCore.SIGNAL('activated(int)'), self.playStation)
		QtCore.QObject.connect(self.ui.btnNext, QtCore.SIGNAL('pressed()'), self.nextDown)
		QtCore.QObject.connect(self.ui.btnNext, QtCore.SIGNAL('released()'), self.nextUp)
		QtCore.QObject.connect(self.ui.btnHate, QtCore.SIGNAL('pressed()'), self.hateDown)
		QtCore.QObject.connect(self.ui.btnHate, QtCore.SIGNAL('released()'), self.hateUp)
		QtCore.QObject.connect(self.ui.btnNext, QtCore.SIGNAL('clicked()'), self.playNextSong)
		QtCore.QObject.connect(self.ui.btnHate, QtCore.SIGNAL('clicked()'), self.doHate)
		QtCore.QObject.connect(self.ui.btnPlay, QtCore.SIGNAL('clicked()'), self.doPlayPause)
		QtCore.QObject.connect(self.ui.btnLove, QtCore.SIGNAL('clicked()'), self.doLove)
		QtCore.QObject.connect(self.ui.btnSleep, QtCore.SIGNAL('clicked()'), self.tiredSong)
		QtCore.QObject.connect(self.player,QtCore.SIGNAL("EOF"), self.playNextSong)
		QtCore.QObject.connect(self.player,QtCore.SIGNAL("state_change"), self.handleStates)
		QtCore.QObject.connect(self.player,QtCore.SIGNAL("duration(int,int)"), self.setDuration)
		QtCore.QObject.connect(self.s, QtCore.SIGNAL('shutdown'), self.closeEvent)
		QtCore.QObject.connect(self.ui.actionDelete, QtCore.SIGNAL('triggered()'), self.deleteStation)
		QtCore.QObject.connect(self.ui.actionEnable_FM_Radio, QtCore.SIGNAL('triggered()'), self.doFM)
		QtCore.QObject.connect(self.ui.actionSnooze, QtCore.SIGNAL('triggered()'), self.setSnooze)
		QtCore.QObject.connect(self.ui.actionCreate, QtCore.SIGNAL('triggered()'), self.searchStation)
		QtCore.QObject.connect(self.ui.actionDonate, QtCore.SIGNAL('triggered()'), self.open_donate)
		QtCore.QObject.connect(self.ui.actionAdd_Seed, QtCore.SIGNAL('triggered()'), self.doSeed)
		QtCore.QObject.connect(self.ui.actionSettings, QtCore.SIGNAL('triggered()'), self.openSettings)

	def disconnect_signals( self ): #disconnect all signals
		QtCore.QObject.disconnect(self.ui.listStations, QtCore.SIGNAL('activated(int)'), self.playStation)
		QtCore.QObject.disconnect(self.ui.btnNext, QtCore.SIGNAL('pressed()'), self.nextDown)
		QtCore.QObject.disconnect(self.ui.btnNext, QtCore.SIGNAL('released()'), self.nextUp)
		QtCore.QObject.disconnect(self.ui.btnHate, QtCore.SIGNAL('pressed()'), self.hateDown)
		QtCore.QObject.disconnect(self.ui.btnHate, QtCore.SIGNAL('released()'), self.hateUp)
		QtCore.QObject.disconnect(self.ui.btnNext, QtCore.SIGNAL('clicked()'), self.playNextSong)
		QtCore.QObject.disconnect(self.ui.btnHate, QtCore.SIGNAL('clicked()'), self.doHate)
		QtCore.QObject.disconnect(self.ui.btnPlay, QtCore.SIGNAL('clicked()'), self.doPlayPause)
		QtCore.QObject.disconnect(self.ui.btnLove, QtCore.SIGNAL('clicked()'), self.doLove)
		QtCore.QObject.disconnect(self.ui.btnSleep, QtCore.SIGNAL('clicked()'), self.tiredSong)
		QtCore.QObject.disconnect(self.player,QtCore.SIGNAL("EOF"), self.playNextSong)
		QtCore.QObject.disconnect(self.player,QtCore.SIGNAL("state_change"), self.handleStates)
		QtCore.QObject.disconnect(self.player,QtCore.SIGNAL("duration(int,int)"), self.setDuration)
		QtCore.QObject.disconnect(self.s, QtCore.SIGNAL('shutdown'), self.closeEvent)
		QtCore.QObject.disconnect(self.ui.actionDelete, QtCore.SIGNAL('triggered()'), self.deleteStation)
		QtCore.QObject.disconnect(self.ui.actionEnable_FM_Radio, QtCore.SIGNAL('triggered()'), self.doFM)
		QtCore.QObject.disconnect(self.ui.actionSnooze, QtCore.SIGNAL('triggered()'), self.setSnooze)
		QtCore.QObject.disconnect(self.ui.actionCreate, QtCore.SIGNAL('triggered()'), self.searchStation)
		QtCore.QObject.disconnect(self.ui.actionDonate, QtCore.SIGNAL('triggered()'), self.open_donate)
		QtCore.QObject.disconnect(self.ui.actionAdd_Seed, QtCore.SIGNAL('triggered()'), self.doSeed)
		QtCore.QObject.disconnect(self.ui.actionSettings, QtCore.SIGNAL('triggered()'), self.openSettings)

#Dialog Windows

	def searchStation( self ): #Initiate station search
		self.d = QDialog(self)
		self.d.setParent(self)
		vbox = QVBoxLayout()
		hLayout = QHBoxLayout()
		hLayout2 = QHBoxLayout()
		hLayout3 = QHBoxLayout()
		self.cStation = {}
		lblSearch = QLabel('Search:')
		self.cStation['lineSearch'] = QLineEdit()
		self.cStation['radioArtist'] = QRadioButton('Artist')
		self.cStation['radioSong'] = QRadioButton('Song')
		btnGroup = QButtonGroup()
		btnGroup.addButton(self.cStation['radioArtist'])
		btnGroup.addButton(self.cStation['radioSong'])
		self.cStation['radioArtist'].setChecked(1)
		search = QPushButton("Search")
		cancel = QPushButton("Cancel")
		search.clicked.connect(self.selectStation)
		cancel.clicked.connect(self.d.close)
		hLayout.addWidget(lblSearch)
		hLayout.addWidget(self.cStation['lineSearch'])
		hLayout2.addWidget(self.cStation['radioArtist'])
		hLayout2.addWidget(self.cStation['radioSong'])
		hLayout3.addWidget(search)
		hLayout3.addWidget(cancel)
		vbox.addLayout(hLayout)
		vbox.addLayout(hLayout2)
		vbox.addLayout(hLayout3)
		self.d.setLayout(vbox)
		self.d.setWindowTitle("Create a Station:")
		self.d.show()

	def selectStation( self ): #Select a station search result.
		self.d.close()
		self.d = QDialog(self)
		title = None
		vbox = QVBoxLayout()
		hLayout = QHBoxLayout()
		hLayout2 = QHBoxLayout()
		ret = self.player.search(self.cStation['lineSearch'].text())
		if self.cStation['radioArtist'].isChecked():
			if len(ret["artists"])>0:
				songs = ret["artists"]
				title = "artistName"
		elif self.cStation['radioSong'].isChecked():
			if len(ret["songs"])>0:
				songs = ret["songs"]
				title = "songTitle"
		accept = QPushButton('Accept')
		cancel = QPushButton('Cancel')
		if not title:
			self.cStation['stationList'] = QLineEdit("No Stations Found")
			accept.setDisabled(True)
			self.cStation['stationList'].setDisabled(True)
		else:
			self.cStation['stationList'] = QListWidget()
			self.cStation['songs'] = songs
			for s in songs:
				self.cStation['stationList'].addItem(s[title])
			#end for
		accept.clicked.connect(self.createStation)
		cancel.clicked.connect(self.d.close)
		hLayout.addWidget(self.cStation['stationList'])
		hLayout2.addWidget(accept)
		hLayout2.addWidget(cancel)
		vbox.addLayout(hLayout)
		vbox.addLayout(hLayout2)
		self.d.setLayout(vbox)
		self.d.setWindowTitle("Select Station:")
		self.d.show()

	def createStation( self ): #Create selected station.
		self.d.close()
		ret = self.player.createStation( self.cStation['songs'][self.cStation['stationList'].currentRow()]['musicId'] )
		print ret
		self.autoPlay = ret
		self.doPlayPause()
		self.getStations()
		self.cStation = None

	def doSeed( self ): # Create Seed Window
		self.d = QDialog(self)
		self.d.setParent(self)
		vbox = QVBoxLayout()
		hLayout = QHBoxLayout()
		m = QPushButton("Seed Artist")
		p = QPushButton("Seed Song")
		c = QPushButton("Close")
		hLayout.addWidget(m)
		hLayout.addWidget(p)
		hLayout.addWidget(c)
		m.clicked.connect(lambda: self.addSeed("artist"))
		p.clicked.connect(lambda: self.addSeed("song"))
		c.clicked.connect(self.d.close)
		vbox.addLayout(hLayout)
		self.d.setLayout(vbox)
		self.d.setWindowTitle("Add Station Seed:")
		self.d.show()

	def addSeed( self, seed=None ): #Seed target and Close Seed Window
		if seed == 'artist':
			musicId = self.song[1]['artistMusicId']
		elif seed == 'song':
			musicId = self.song[1]['musicId']
		else:
			return
		self.stimer.singleShot(100, lambda: self.player.doSeed( musicId, self.curStation ))
		self.d.close()

	def open_donate( self ): #Donations are AWESOME :)
		self.d = QDialog(self)
		self.d.setParent(self)
		vbox = QVBoxLayout()
		hLayout = QHBoxLayout()
		m = QPushButton("pyRadio")
		p = QPushButton("Get Pandora One") #Let's support our radio host :)
		c = QPushButton("Close")
		hLayout.addWidget(m)
		hLayout.addWidget(p)
		hLayout.addWidget(c)
		action = lambda: self.donate('radio')
		action1 = lambda: self.donate('pandora')
		m.clicked.connect(action)
		p.clicked.connect(action1)
		c.clicked.connect(self.d.close)
		vbox.addLayout(hLayout)
		self.d.setLayout(vbox)
		self.d.setWindowTitle("Donate to:")
		self.d.show()

	def donate( self, who=None ): #Open browser and close Donation window
		if who == 'radio':
			webbrowser.open_new('https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=BWX2M54JBJ2T2')
		elif who == 'pandora':
			webbrowser.open_new('http://www.pandora.com/pandora_one')
		self.d.close()

	def openSettings( self ): #Build and open settings dialog box.
		self.d = QDialog(self)
		self.d.setParent(self)
		self.settings = {} #Store settings in a hash, it's easier to read in my opinion.
		vbox = QVBoxLayout()
		hLayout = QHBoxLayout()
		hLayout2 = QHBoxLayout()
		hLayout3 = QHBoxLayout()
		hLayout4 = QHBoxLayout()
		hLayout5 = QHBoxLayout()
		hLayout6 = QHBoxLayout()
		self.settings['lblUsername'] = QLabel("Username:")
		self.settings['lineUser'] = QLineEdit()
		self.settings['lblUsername'].setBuddy(self.settings['lineUser'])
		self.settings['lineUser'].setText(self.c.user)
		self.settings['lblPass'] = QLabel("Password:")
		self.settings['linePass'] = QLineEdit()
		self.settings['lblPass'].setBuddy(self.settings['linePass'])
		self.settings['linePass'].setText(self.c.password)
		self.settings['linePass'].setEchoMode(QLineEdit.Password)
		self.settings['lblProxy'] = QLabel("Proxy Server:")
		self.settings['lineProxy'] = QLineEdit()
		self.settings['lblProxy'].setBuddy(self.settings['lineProxy'])
		self.settings['lineProxy'].setText(self.c.proxy)
		self.settings['btnGroup'] = QButtonGroup()
		self.settings['radioHigh'] = QRadioButton("High (Pandora One)")
		self.settings['radioMed'] = QRadioButton("Medium (MP3)")
		self.settings['radioLow'] = QRadioButton("Low (AAC)")
		self.settings['btnGroup'].addButton(self.settings['radioHigh'])
		self.settings['btnGroup'].addButton(self.settings['radioMed'])
		self.settings['btnGroup'].addButton(self.settings['radioLow'])
		if self.c.format == "mp3-hifi":
			self.settings['radioHigh'].setChecked(1)
		elif self.c.format == "mp3":
			self.settings['radioMed'].setChecked(1)
		elif self.c.format == "aacplus":
			self.settings['radioLow'].setChecked(1)
		else:
			self.settings['radioMed'].setChecked(1)
		self.settings['btnGroup2'] = QButtonGroup()
		self.settings['radioAuto'] = QRadioButton("Automatic")
		self.settings['radioPort'] = QRadioButton("Portrait")
		self.settings['radioLand'] = QRadioButton("Landscape")
		if self.c.rotation == "automatic":
			self.settings['radioAuto'].setChecked(1)
		elif self.c.rotation == "landscape":
			self.settings['radioLand'].setChecked(1)
		else:
			self.settings['radioPort'].setChecked(1)
		self.settings['btnGroup2'].addButton(self.settings['radioAuto'])
		self.settings['btnGroup2'].addButton(self.settings['radioPort'])
		self.settings['btnGroup2'].addButton(self.settings['radioLand'])
		a = QPushButton("Accept")
		b = QPushButton("Cancel")
		hLayout.addWidget(self.settings['lblUsername'])
		hLayout.addWidget(self.settings['lineUser'])
		hLayout2.addWidget(self.settings['lblPass'])
		hLayout2.addWidget(self.settings['linePass'])
		hLayout6.addWidget(self.settings['lblProxy'])
		hLayout6.addWidget(self.settings['lineProxy'])
		hLayout3.addWidget(self.settings['radioHigh'])
		hLayout3.addWidget(self.settings['radioMed'])
		hLayout3.addWidget(self.settings['radioLow'])
		hLayout4.addWidget(self.settings['radioAuto'])
		hLayout4.addWidget(self.settings['radioPort'])
		hLayout4.addWidget(self.settings['radioLand'])
		hLayout5.addWidget(a)
		hLayout5.addWidget(b)
		a.clicked.connect(self.setSettings)
		b.clicked.connect(self.d.close)
		vbox.addLayout(hLayout)
		vbox.addLayout(hLayout2)
		vbox.addLayout(hLayout6)
		vbox.addLayout(hLayout3)
		if self.player.os == "RX-51":
			vbox.addLayout(hLayout4)
		vbox.addLayout(hLayout5)
		self.d.setLayout(vbox)
		self.d.setWindowTitle("pyRadio Settings:")
		self.d.show()

	def setSettings ( self ): #Set settings and close settings dialog.
		changed = False
		if self.c.user != self.settings['lineUser'].text() or self.c.password != self.settings['linePass'].text():
			self.c.user = self.settings['lineUser'].text()
			self.c.password = self.settings['linePass'].text()
			self.auth()
			changed = True
		if self.c.proxy != self.settings['lineProxy'].text():
			self.c.proxy = self.settings['lineProxy'].text()
			self.player.pandora.set_proxy(self.c.proxy)
			changed = True
		if self.settings['radioHigh'].isChecked():
			format = 'mp3-hifi'
		elif self.settings['radioMed'].isChecked():
			format = 'mp3'
		elif self.settings['radioLow'].isChecked():
			format = 'aacplus'
		if format != self.c.format:
			self.c.format=format
			self.player.playlist = []
			self.player.getMoreSongs( self.curStation, self.c.format )
			changed = True
		if self.os == "RX-51":
			self.setAttribute(Qt.WA_Maemo5AutoOrientation, 1)
		try:
			if self.settings['radioAuto'].isChecked():
				self.c.rotation = 'automatic'
				self.setAttribute(Qt.WA_Maemo5AutoOrientation, 1)
				changed = True
			elif self.settings['radioPort'].isChecked():
				self.c.rotation = 'portrait'
				self.setAttribute(Qt.WA_Maemo5PortraitOrientation, 1)
				changed = True
			elif self.settings['radioLand'].isChecked():
				self.c.rotation = 'landscape'
				self.setAttribute(Qt.WA_Maemo5LandscapeOrientation, 1)
				changed = True
		except: print "No Rotation."
		self.settings = None
		if changed:
			self.c.write()
		self.d.close()

#Main Method

if __name__ == '__main__':
	if not ( os.path.exists( sys.path[0]+"/libpiano/crypt_key_input.h" ) \
			and os.path.exists( sys.path[0]+"/libpiano/crypt_key_output.h" ) ):
		ok = QtGui.QMessageBox.warning(None, "Pandora", "Missing encription key files." )
	else:
		app = QtGui.QApplication(sys.argv)
		panda = Panda()
		panda.show()
		sys.exit(app.exec_())
