#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <gnokii.h>


struct gn_statemachine	state;



static gn_error show_memory_status(const char *name, gn_memory_type type)
{
	gn_memory_status	stat;
	gn_data			data;
	gn_error		error;

	gn_data_clear(&data);
	stat.memory_type	= type;
	data.memory_status	= &stat;

	if ((error = gn_sm_functions(GN_OP_GetMemoryStatus, &data, &state)) != GN_ERR_NONE) return error;

	printf("%s: Used %d, Free %d\n", name, stat.used, stat.free);

	return GN_ERR_NONE;
}



int main(int argc, const char *argv[])
{
	gn_error	error;
	char		*bindir;

	/* read the config */
	if (gn_cfg_read(&bindir) < 0) exit(1);
	if (!gn_cfg_phone_load("", &state)) exit(1);

	/* initialise the connection */
	if ((error = gn_gsm_initialise(&state)) != GN_ERR_NONE) {
		fprintf(stderr, "Telephone interface init failed: %s Quitting.\n", gn_error_print(error));
		exit(2);
	}

	/* do something */
	show_memory_status("SIM", GN_MT_SM);
	show_memory_status("Phone", GN_MT_ME);
	show_memory_status("DC", GN_MT_DC);
	show_memory_status("EN", GN_MT_EN);
	show_memory_status("FD", GN_MT_FD);
	show_memory_status("LD", GN_MT_LD);
	show_memory_status("MC", GN_MT_MC);
	show_memory_status("ON", GN_MT_ON);
	show_memory_status("RC", GN_MT_RC);

	/* tear down the connection */
	gn_sm_functions(GN_OP_Terminate, NULL, &state);

	return 0;
}
