/*
 * personal-launcher - Desktop icons to launch applications
 * Copyright (C) 2008  Andrew Olmsted  <andrew.olmsted@gmail.com>
 * 
 * Parts of this file are based on:
 * desktop-plugin-example - Example Desktop Plugin with real transparency
 * Copyright (C) 2008  Tommi Saviranta  <wnd@iki.fi>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */

#ifndef PERSONAL_LAUNCHER_H_
#define PERSONAL_LAUNCHER_H_

#include <glib-object.h>
#include <libgnomevfs/gnome-vfs.h>

#include <libhildondesktop/hildon-desktop-home-item.h>

G_BEGIN_DECLS


#define TYPE_PERSONAL_LAUNCHER	(personal_launcher_get_type())
#define PERSONAL_LAUNCHER(obj)	(G_TYPE_CHECK_INSTANCE_CAST((obj), \
			TYPE_PERSONAL_LAUNCHER, PersonalLauncher))
#define PERSONAL_LAUNCHER_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), TYPE_PERSONAL_LAUNCHER, PersonalLauncher))
#define IS_PERSONAL_LAUNCHERT(obj)	(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
			TYPE_PERSONAL_LAUNCHER))
#define IS_PERSONAL_LAUNCHERT_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), TYPE_PERSONAL_LAUNCHER))
#define PERSONAL_LAUNCHER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), \
			TYPE_PERSONAL_LAUNCHER, PersonalLauncher))
#define PERSONAL_LAUNCHER_GET_PRIVATE(obj) \
		(G_TYPE_INSTANCE_GET_PRIVATE((obj), TYPE_PERSONAL_LAUNCHER, \
				PersonalLauncher))

typedef struct _PersonalLauncherPrivate PersonalLauncherPrivate;

/* Instance struct */
typedef struct {
	HildonDesktopHomeItem parent;
	GtkWidget			   *layout;
	GnomeVFSMonitorHandle  *fileMon;
	guint                  updateTimeout;
	gboolean			   queueRefresh;
	XRectangle			   clip;
	PersonalLauncherPrivate *priv;
} PersonalLauncher;

/* Class struct */
typedef struct {
	HildonDesktopHomeItemClass parent_class;
} PersonalLauncherClass;


GType personal_launcher_get_type(void);


G_END_DECLS

#endif
