#ifndef FEEDRENDERER_H
#define FEEDRENDERER_H

#include "feedinterface.h"
#include <QUrl>

class QTextEdit;


/*!
    \class FeedRenderer

    \brief Abstract class for dumping feed content to UI

    renderEntries() should look at all available feed entries
    and present them in the 'editor' widget appropriately.

*/


class FeedRenderer
{
public:    
    virtual void renderEntries(const QVector< FeedEntry >& entries, QTextEdit& editor) = 0;
    // will be set to base url of rendered item - only implement if necessary
    virtual QUrl baseUrl();
    virtual ~FeedRenderer();
};

/*!
    \class TrivialFeedRenderer

    \brief Show each entry separated by horizontal line.
*/


class TrivialFeedRenderer : public FeedRenderer
{
public:
    TrivialFeedRenderer();
    void renderEntries(const QVector< FeedEntry >& entries, QTextEdit& editor);    
};

/*!
    \class FileContentRenderer

    \brief Show local files, one per feed.

    This just sets the url of QTextBrowser to point directly
    at the local file on renderEntries().

    Will not crash if we have more than one entry, but
    that's an unsupported usage scenario.
*/


class FileContentRenderer : public FeedRenderer
{
public:
    FileContentRenderer();
    void renderEntries(const QVector< FeedEntry >& entries, QTextEdit& editor);
    QUrl baseUrl();
    ~FileContentRenderer();

private:
    QUrl m_baseUrl;  
};

#endif // FEEDRENDERER_H
