/*
  PackageView - Show debian package details
  Copyright (C) 2008  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "PackageDetails.h"

#include <Lum/Base/L10N.h>
#include <Lum/Base/String.h>

#include <Lum/Model/Header.h>
#include <Lum/Model/Table.h>

#include <Lum/ButtonRow.h>
#include <Lum/Edit/Edit.h>
#include <Lum/Label.h>
#include <Lum/Panel.h>
#include <Lum/Tab.h>
#include <Lum/Table.h>
#include <Lum/Text.h>
#include <Lum/View.h>

PackageDetails::PackageDetails(Package& package)
 : package(package)
{
  Observe(GetClosedAction());
}

Lum::Object* PackageDetails::GetTextField(const std::wstring& text) const
{
  Lum::Text *t;

  t=new Lum::Text(text);
  t->SetFlex(true,false);
  t->SetMaxWidth(Lum::Base::Size::stdCharWidth,20);

  return t;
}

void PackageDetails::PreInit()
{
  Lum::Edit::Edit             *edit;
  Lum::Edit::Text             *editContent;
  Lum::Panel                  *vPanel;
  Lum::Model::HeaderRef       headers;
  Lum::Model::StringMatrixRef headerList;
  std::vector<std::wstring>   header;
  Lum::Tab                    *tab;
  Lum::Table                  *table;

  vPanel=Lum::VPanel::Create(true,true);

  tab=Lum::Tab::Create(true,true);

  headerList=new Lum::Model::StringMatrix();

  header.clear();
  header.push_back(L"Package");
  header.push_back(package.GetName());
  headerList->Append(header);

  header.clear();
  header.push_back(L"Version");
  header.push_back(package.GetVersion());
  headerList->Append(header);

  header.clear();
  header.push_back(L"Section");
  header.push_back(package.GetSection());
  headerList->Append(header);

  header.clear();
  header.push_back(L"Description");
  header.push_back((package.GetShortDescription().empty() ? L"<no description>" : package.GetShortDescription()));
  headerList->Append(header);

  header.clear();
  header.push_back(L"Maintainer");
  header.push_back((package.GetMaintainer().empty() ? L"<no maintainer>" : package.GetMaintainer()));
  headerList->Append(header);

  header.clear();
  header.push_back(L"Package size");
  header.push_back(Lum::Base::NumberToWString(package.GetPackageSize())+L" bytes");
  headerList->Append(header);


  header.clear();
  header.push_back(L"Install size");
  header.push_back(Lum::Base::NumberToWString(package.GetInstalledSize())+L" bytes");
  headerList->Append(header);

  headers=new Lum::Model::HeaderImpl();
  headers->AddColumn(L"Data",Lum::Base::Size::stdCharWidth,15);
  headers->AddColumn(L"Value",Lum::Base::Size::stdCharWidth,20,true);

  table=new Lum::Table();
  table->SetFlex(true,true);
  table->SetShowHeader(true);
  table->GetTableView()->SetAutoHSize(true);
  table->GetTableView()->SetAutoFitColumns(true);
  table->SetHeaderModel(headers);
  table->SetModel(headerList);

  tab->Add(L"Data",table);

  editContent=new Lum::Edit::Text();
  editContent->SetText(package.GetDescription());
  editContent->Disable();

  edit=new Lum::Edit::Edit();
  edit->SetFlex(true,true);
  edit->SetMinWidth(Lum::Base::Size::stdCharWidth,40);
  edit->SetMinHeight(Lum::Base::Size::stdCharHeight,5);
  edit->SetConfig(Lum::Edit::Config::GetDefaultConfig());
  edit->SetColorSheme(Lum::Edit::ColorSheme::GetDefaultColorSheme());
  edit->SetFont(Lum::OS::display->GetFont());
  edit->SetModel(editContent);

  tab->Add(L"Description",Lum::View::Create(edit,true,true));

  table=new Lum::Table();
  table->SetFlex(true,true);

  if (package.LoadPackageContent(files)) {
    Lum::Model::StringRefTableRef filesModel=new Lum::Model::StringRefTable(files);

    table->SetModel(filesModel);
  }

  tab->Add(L"Content",table);

  editContent=new Lum::Edit::Text();
  editContent->SetText(package.GetDependencies());
  editContent->Disable();

  edit=new Lum::Edit::Edit();
  edit->SetFlex(true,true);
  edit->SetMinWidth(Lum::Base::Size::stdCharWidth,40);
  edit->SetMinHeight(Lum::Base::Size::stdCharHeight,5);
  edit->SetConfig(Lum::Edit::Config::GetDefaultConfig());
  edit->SetColorSheme(Lum::Edit::ColorSheme::GetDefaultColorSheme());
  edit->SetFont(Lum::OS::display->GetFont());
  edit->SetModel(editContent);

  tab->Add(L"Dependencies",Lum::View::Create(edit,true,true));

  vPanel->Add(tab);
  vPanel->AddSpace();
  vPanel->Add(Lum::ButtonRow::CreateClose(GetClosedAction(),true,false));

  SetMain(vPanel);

  Lum::Dialog::PreInit();
}

void PackageDetails::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
{
  if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
    Exit();
  }

  Lum::Dialog::Resync(model,msg);
}
