/*
  PackageView - Show debian package details
  Copyright (C) 2008  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "PackageDetails.h"

#include <Lum/Base/L10N.h>
#include <Lum/Base/String.h>

#include <Lum/Button.h>
#include <Lum/ButtonRow.h>
#include <Lum/Edit/Edit.h>
#include <Lum/Label.h>
#include <Lum/Panel.h>
#include <Lum/Space.h>
#include <Lum/Tab.h>
#include <Lum/View.h>
#include <Lum/WindowGroup.h>

PackageDetails::PackageDetails(Package& package)
 : package(package)
{
  AttachModel(GetClosedAction());
}

PackageDetails::~PackageDetails()
{
  UnattachModel(GetClosedAction());
}

void PackageDetails::PreInit()
{
  Lum::Button           *button;
  Lum::ButtonRow        *row;
  Lum::Edit::Edit       *edit;
  Lum::Edit::Text       *editContent;
  Lum::Label            *label;
  Lum::Panel            *vPanel;
  Lum::Tab              *tab;
  Lum::View             *view;
  Lum::WindowGroup      *wGroup;

  vPanel=new Lum::VPanel();
  vPanel->SetFlex(true,true);

  tab=new Lum::Tab();
  tab->SetFlex(true,true);

  label=new Lum::Label();
  label->SetFlex(true,true);

  label->AddLabel(L"Package:",package.GetName()+L" "+package.GetVersion()+ L" ("+package.GetSection()+L")");
  label->AddLabel(L"Description:",package.GetShortDescription().empty() ? L"<no description>" : package.GetShortDescription());
  label->AddLabel(L"Maintainer:",package.GetMaintainer().empty() ? L"<no maintainer>" : package.GetMaintainer());
  label->AddLabel(L"Homepage:", package.GetHomepage().empty() ? L"<no homepage> " : package.GetHomepage());
  label->AddLabel(L"Size (deb/inst.):",Lum::Base::NumberToWString(package.GetPackageSize())+L"/"+
                  Lum::Base::NumberToWString(package.GetInstalledSize()));

  tab->Add(L"Data",label);

  editContent=new Lum::Edit::Text();
  editContent->SetText(package.GetDescription());
  editContent->Disable();

  view=new Lum::View();
  view->SetFlex(true,true);

  edit=new Lum::Edit::Edit();
  edit->SetFlex(true,true);
  edit->RequestFocus();
  edit->SetMinWidth(Lum::Base::Size::stdCharWidth,55);
  edit->SetMinHeight(Lum::Base::Size::stdCharHeight,5);
  edit->SetConfig(Lum::Edit::Config::GetDefaultConfig());
  edit->SetColorSheme(Lum::Edit::ColorSheme::GetDefaultColorSheme());
  edit->SetFont(Lum::OS::display->GetFont());
  edit->SetModel(editContent);

  view->SetObject(edit);

  tab->Add(L"Description",view);

  editContent=new Lum::Edit::Text();
  editContent->SetText(package.GetDependencies());
  editContent->Disable();

  view=new Lum::View();
  view->SetFlex(true,true);

  edit=new Lum::Edit::Edit();
  edit->SetFlex(true,true);
  edit->RequestFocus();
  edit->SetMinWidth(Lum::Base::Size::stdCharWidth,55);
  edit->SetMinHeight(Lum::Base::Size::stdCharHeight,5);
  edit->SetConfig(Lum::Edit::Config::GetDefaultConfig());
  edit->SetColorSheme(Lum::Edit::ColorSheme::GetDefaultColorSheme());
  edit->SetFont(Lum::OS::display->GetFont());
  edit->SetModel(editContent);

  view->SetObject(edit);

  tab->Add(L"Dependencies",view);

  vPanel->Add(tab);

  vPanel->Add(new Lum::VSpace());

  row=new Lum::ButtonRow();
  row->SetFlex(true,false);

  button=new Lum::Button;
  button->SetFlex(true,true);
  button->RequestFocus();
  button->SetModel(GetClosedAction());
  button->SetText(_ld(dlgButtonOk));
  button->SetType(Lum::Button::typeCommit);
  row->Add(button);

  vPanel->Add(row);

  wGroup=new Lum::WindowGroup();
  wGroup->SetFlex(true,true);
  wGroup->SetMain(vPanel);

  SetTop(wGroup);

  Lum::Dialog::PreInit();
}

void PackageDetails::Resync(Lum::Base::Model* model, const Lum::Base::ResyncMsg& msg)
{
  if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
    Exit();
  }

  Lum::Dialog::Resync(model,msg);
}
