/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of MTetrinet.
 *
 * MTetrinet is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * MTetrinet is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MTetrinet.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MISC_H
#define MISC_H

#include <locale.h>
#include <libintl.h>

#define LOCALEDIR "/usr/share/locale"

#define _(String) gettext(String)
#define N_(String) (String)

void errorf(GtkWidget *parent, const char *fmt, ...);
void messagef(GtkWidget *parent, char *title, const char *fmt, ...);
gboolean yes_no_f(GtkWidget *parent,
		  char *title, const char *fmt, ...);

char *find_file(char *name);

#endif // MISC_H
