#include "minigpsd.h"

// web pages from server

//kml feed

static char gpskml[] = "<Document>"
  "<flyToView>1</flyToView>"
  "<name>%s %d.%03d</name>"
  "<LookAt>"
  "<longitude>%d.%06d</longitude>\n"
  "<latitude>%d.%06d</latitude>\n"
  "<range>%d</range>"
  "<tilt>%d</tilt>"
  "<heading>%d.%03d</heading>"
  "</LookAt>"
  "<Placemark>"
  "<Style><IconStyle><Icon><href>"
  "root://icons/high_res_places.png"
  "</href></Icon></IconStyle></Style>"
  "<Point><coordinates>" "%d.%06d,%d.%06d" "</coordinates></Point>" "</Placemark>" "</Document>\n";

void dokml(char *c)
{
    char *d;
    int range = 1500, tilt = 45;
    d = strstr(c, "kml");
    d--;
    d--;
    while (*d && (*d >= '0' && *d <= '9'))
        d--;
    range = atoi(&d[1]);
    d--;
    while (*d && (*d >= '0' && *d <= '9'))
        d--;

    tilt = atoi(&d[1]);

    sprintf(xbuf, gpskml, rtname, gpst.gspd / 1000, gpst.gspd % 1000,
      gpst.llon / 1000000, abs(gpst.llon % 1000000), gpst.llat / 1000000, abs(gpst.llat % 1000000), range, tilt, gpst.gtrk / 1000, gpst.gtrk % 1000,
      gpst.llon / 1000000, abs(gpst.llon % 1000000), gpst.llat / 1000000, abs(gpst.llat % 1000000));
}

//moving google map

static char xmldata[] = "<xml><markers><marker lat=\"%d.%06d\" lng=\"%d.%06d\"/></markers></xml>";

void doxml()
{
    sprintf(xbuf, xmldata, gpst.llat / 1000000, abs(gpst.llat % 1000000), gpst.llon / 1000000, abs(gpst.llon % 1000000));
}

static char dogmaphtml[] =
  "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\""
  " \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">"
  "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><title>MiniGPSD Google Maps</title>"
  "<style> bdy,html { margin:0px; width: 100%; height: 100%; } </style>"
  "<script src=\"http://maps.google.com/maps?file=api&amp;v=2&amp;key="
  /*localhost:8888 */ "ABQIAAAANuLIexvN57fLejioS_Sc1xSiW6_TZA8KXStWCUXuIknmHbpzIxQde8r5eV8EKfChVtmY49dFftroVg"
  ///*127.0.0.1:8888*/ "ABQIAAAANuLIexvN57fLejioS_Sc1xRi_j0U6kJrkFvY4-OX2XYmEAa76BQr5MmGpSXMqbjSSeNcvxvHyxx6_Q"
  "\" type=\"text/javascript\"></script>"
  "<script type=\"text/javascript\"> var map; var mark; var timer = setInterval(\"posrefresh()\", 5 * 1000 );"
  "function posrefresh(){"
  "GDownloadUrl(\"gpsdata.xml\",function(data, responseCode) {"
  "var xml = GXml.parse(data); var markers = xml.documentElement.getElementsByTagName(\"marker\");var point;"
  "for(var i = 0; i < markers.length; i++){point = new GLatLng( parseFloat(markers[i].getAttribute(\"lat\")),"
  " parseFloat(markers[i].getAttribute(\"lng\")));}mark.setLatLng(point);map.panTo(point); });}"
  "function load(){if(GBrowserIsCompatible()){map = new GMap2(document.getElementById(\"map\"));"
  "	map.checkResize();"
  "mark = new GMarker(new GLatLng(0.0,0.0));"
  "map.setCenter(new GLatLng(0.0,120.0), 14);map.addControl(new GMapTypeControl());"
  "map.addControl(new GSmallZoomControl());map.addControl(new GScaleControl());posrefresh();map.addOverlay(mark);}}"
  "</script></head><bdy>"
  "<div id=\"map\" style=\"width:100%;height:100%\"></div>"
  "<script>window.onload = load;window.onunload = GUnload;</script>" "</bdy></html>";

void dogmap()
{
    strcpy(xbuf, dogmaphtml);
}

//standard gps view

static char gpspage1[] = "<HEAD><TITLE>%s</TITLE></HEAD><BODY>"
  "<STYLE type=\"text/css\">BR{clear:left}</STYLE>\n"
  "<IFRAME align=right width=80%% height=100%% src=\"http://maps.google.com/maps?q=%d.%06d+%d.%06d&output=html\"></IFRAME>\n";

static char gpspage2[] =
  "%02d-%02d-%02d %02d:%02d:%02d<br>"
  "lat=%d.%06d<br>lon=%d.%06d<br>"
  "%dD gpst.fix<br>%s gpst.lock<br>"
  "gpst.alt=%d.%03d<br>"
  "spd=%d.%03d<br>"
  "trk=%d.%03d<br>" "PDoP=%d.%02d<br>" "HDoP=%d.%02d<br>" "VDoP=%d.%02d<br>\n" "<table><tr><th>SN<th>EL<th>AZM<th>SG<th>U</tr>";

static char gpspage9[] = "</table></BODY></HTML>\r\n\r\n";

void doweb()
{
    char *c;
    int n;
    c = strchr(xbuf, '&');
    if (!c)
        c = "";
    sprintf(xbuf, gpspage1, rtname, gpst.llat / 1000000, abs(gpst.llat % 1000000), gpst.llon / 1000000, abs(gpst.llon % 1000000));
    sprintf(&xbuf[strlen(xbuf)], gpspage2, gpst.yr, gpst.mo, gpst.dy, gpst.hr, gpst.mn, gpst.sc, gpst.llat / 1000000, abs(gpst.llat % 1000000), gpst.llon / 1000000,
      abs(gpst.llon % 1000000), gpst.fix, gpst.lock ? (gpst.lock == 1 ? "GPS" : "DGPS") : "no", gpst.alt / 1000, abs(gpst.alt % 1000)
      , gpst.gspd / 1000, gpst.gspd % 1000, gpst.gtrk / 1000, gpst.gtrk % 1000, gpst.pdop / 1000, gpst.pdop % 1000 / 10, gpst.hdop / 1000, gpst.hdop % 1000 / 10,
      gpst.vdop / 1000, gpst.vdop % 1000 / 10);
    for (n = 0; n < gpsat.nsats; n++) {
        int m;
        sprintf(&xbuf[strlen(xbuf)], "<tr><td>%02d<td>%02d<td>%03d<td>%02d<td>", gpsat.view[n], gpsat.el[gpsat.view[n]], gpsat.az[gpsat.view[n]], gpsat.sn[gpsat.view[n]]);
        for (m = 0; m < 12; m++)
            if (gpsat.sats[m] == gpsat.view[n])
                break;
        sprintf(&xbuf[strlen(xbuf)], "%s</tr>", m == 12 ? " " : "*");
    }
    //    sprintf(&xbuf[strlen(xbuf)], gpspage9);
    strcpy(&xbuf[strlen(xbuf)], gpspage9);
}
