/*
 * Copyright: (C) 2008 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */
#ifndef CAR_TAB_H
#define CAR_TAB_H


#include <gtk/gtk.h>

extern void car_tab_layout(GtkWidget *window);
extern void car_tab_load_car(char *);
extern GtkWidget *car_tab_get_car_selector();
extern GtkWidget *car_tab_get_text_buffer();
extern int  car_tab_get_car_inserted();
extern void car_tab_update_units(int units);
extern void car_tab_update_units_entry(int units);
extern void car_tab_update_cost_units(int units);
extern void car_tab_update_car_combo_box(int);
extern void car_tab_set_life_MPG(char *text);
extern void car_tab_set_last_MPG(char *text);
extern void car_tab_set_miles_month(char *text);
extern void car_tab_update_text_labels(
   char     *lifetime_label,
   char     *last_label,
   char     *miles_month_label);
extern void car_import_clicked_cb(GtkWidget* w, gpointer data);
extern void car_export_clicked_cb(GtkWidget* w, gpointer data);
extern void car_backup_clicked_cb(GtkWidget* w, gpointer data);

#define CAR_MPG_US_TEXT  "MPG(US)"
#define CAR_MPG_IMP_TEXT "MPG(Imp)"
#define CAR_LP100KM_TEXT "L/100km"
#define CAR_LP10KM_TEXT  "L/10km"
#define CAR_MPL_TEXT     "Miles/L"
#define CAR_KMPL_TEXT    "km/L"

#define CAR_MPG_US_INDEX  0
#define CAR_LP100KM_INDEX 1
#define CAR_LP10KM_INDEX  2
#define CAR_MPL_INDEX     3
#define CAR_KMPL_INDEX    4
#define CAR_MPG_IMP_INDEX 5

#endif
