/*
 * Copyright: (C) 2008 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */

#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "common_tab.h"
#include "care_tab.h"
#include "mileagefile.h"

static GtkWidget *car_selector = NULL;
static GtkWidget  *table1 = NULL;
static int        car_inserted = FALSE;
static GtkWidget  *date_label = NULL;
static GtkWidget  *date_text = NULL;
static GtkWidget  *repeat_label = NULL;
static GtkWidget  *repeat_text = NULL;
static GtkWidget  *alert_but = NULL;
static GtkWidget  *odo_text = NULL;
static GtkWidget  *activity_text = NULL;
static GtkWidget  *comment_text = NULL;

static void car_selector_clicked_cb(GtkWidget* w, gpointer data);
static void care_save_clicked_cb(GtkWidget* w, gpointer data);
static void care_button_clicked_cb(GtkWidget* w, gpointer data);

void care_tab_layout(GtkWidget *window)
{
   GtkWidget  *activity_but;
   GtkWidget  *label2, *label4, *label5;
   GtkWidget  *button;

   table1 = gtk_table_new(9,9,FALSE);
   gtk_container_add(GTK_CONTAINER(window), (GtkWidget *)table1);

   car_selector = gtk_combo_box_new_text();
   gtk_table_attach(GTK_TABLE(table1), car_selector, 3, 7, 0, 1, GTK_FILL, GTK_SHRINK, 2, 2);
   gtk_signal_connect(GTK_OBJECT(car_selector),
                     "changed",
                     GTK_SIGNAL_FUNC(car_selector_clicked_cb),
                     car_selector);

   alert_but = gtk_radio_button_new_with_label(NULL, "Alerts");
   gtk_table_attach(GTK_TABLE(table1), alert_but, 0, 4, 1, 2, GTK_FILL, GTK_SHRINK, 2, 2);
   gtk_signal_connect(GTK_OBJECT(alert_but),
                     "toggled",
                     GTK_SIGNAL_FUNC(care_button_clicked_cb),
                     car_selector);

   activity_but = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(alert_but), "Activity");
   gtk_table_attach(GTK_TABLE(table1), activity_but, 5, 9, 1, 2, GTK_FILL, GTK_SHRINK, 2, 2);
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(activity_but), TRUE);

   date_label = gtk_label_new("Date YYYY/MM/DD");
   gtk_table_attach(GTK_TABLE(table1), date_label, 0, 4, 2, 3, GTK_FILL, GTK_SHRINK, 2, 2);

   date_text = gtk_entry_new_with_max_length(15);
   gtk_table_attach(GTK_TABLE(table1), date_text, 5, 9, 2, 3, GTK_FILL, GTK_SHRINK, 2, 2);

   label2 = gtk_label_new("Odometer");
   gtk_table_attach(GTK_TABLE(table1), label2, 0, 4, 3, 4, GTK_FILL, GTK_SHRINK, 2, 2);

   odo_text = gtk_entry_new_with_max_length(15);
   gtk_table_attach(GTK_TABLE(table1), odo_text, 5, 9, 3, 4, GTK_FILL, GTK_SHRINK, 2, 2);

   repeat_label = gtk_label_new("Repeat Every");
   gtk_table_attach(GTK_TABLE(table1), repeat_label, 0, 4, 4, 5, GTK_FILL, GTK_SHRINK, 2, 2);
   gtk_widget_set_sensitive(GTK_WIDGET(repeat_label), FALSE);

   repeat_text = gtk_entry_new_with_max_length(15);
   gtk_table_attach(GTK_TABLE(table1), repeat_text, 5, 9, 4, 5, GTK_FILL, GTK_SHRINK, 2, 2);
   gtk_widget_set_sensitive(GTK_WIDGET(repeat_text), FALSE);

   label4 = gtk_label_new("Activity");
   gtk_table_attach(GTK_TABLE(table1), label4, 0, 4, 5, 6, GTK_FILL, GTK_SHRINK, 2, 2);

   activity_text = gtk_entry_new_with_max_length(25);
   gtk_table_attach(GTK_TABLE(table1), activity_text, 5, 9, 5, 6, GTK_FILL, GTK_SHRINK, 2, 2);

   label5 = gtk_label_new("Comment");
   gtk_table_attach(GTK_TABLE(table1), label5, 0, 3, 6, 7, GTK_FILL, GTK_SHRINK, 2, 2);

   comment_text = gtk_entry_new_with_max_length(60);
   gtk_table_attach(GTK_TABLE(table1), comment_text, 3, 9, 6, 7, GTK_FILL, GTK_SHRINK, 2, 2);

   button = gtk_button_new_with_label("Save");
   gtk_signal_connect(GTK_OBJECT(button),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_save_clicked_cb),
                     NULL);
   gtk_table_attach(GTK_TABLE(table1), button, 3, 6, 7, 8, GTK_FILL, GTK_SHRINK, 2, 2);

}

void
care_tab_load_car(char * car)
{  
   if (car == NULL) 
   {
      gtk_widget_destroy(car_selector);
      car_selector = gtk_combo_box_new_text();
      gtk_table_attach(GTK_TABLE(table1), car_selector, 3, 7, 0, 1, GTK_FILL, GTK_SHRINK, 2, 2);
      gtk_signal_connect(GTK_OBJECT(car_selector),
                     "changed",
                     GTK_SIGNAL_FUNC(car_selector_clicked_cb),
                     car_selector);
      gtk_widget_show_all(car_selector);
      car_inserted = FALSE;
   }
   else
   {
      gtk_combo_box_append_text(GTK_COMBO_BOX(car_selector), car);
      car_inserted = TRUE;
   }
}

GtkWidget *
care_tab_get_car_selector()
{
   return car_selector;
}

int
care_tab_get_car_inserted()
{
   return car_inserted;
}

void
care_tab_update_car_combo_box(int value)
{
   gtk_combo_box_set_active(GTK_COMBO_BOX(car_selector), value);
}

void
car_selector_clicked_cb(GtkWidget* w, gpointer data)
{
   char *car;

   /* Update all combo boxes to the same value */
   common_tab_update_car_combo_box(gtk_combo_box_get_active((GtkComboBox *)car_selector));

   if (data)
   {
      car = gtk_combo_box_get_active_text(data);
      if (car[strlen(car) - 1] == '\n')
      {
         car[strlen(car) - 1] = '\0';
      }

#ifdef DEBUG
      fprintf(stdout, "Car Selector choosen %s.\n", car);
#endif
#if 0
      /* Only called from car_tab */
      common_tab_load_data(car);
#endif

      if (car)
         free(car);
   }
}

void
care_save_clicked_cb(GtkWidget* w, gpointer data)
{
   char *date_str;
   char *odo_str;
   char *repeat_str;
   char *activity_str;
   char *comment_str;
   char *car;
   GtkWidget  *dialog = NULL;

#ifdef DEBUG
      fprintf(stdout, "Save selected\n");
#endif
   date_str = (char *)gtk_entry_get_text(GTK_ENTRY(date_text));
   odo_str = (char *)gtk_entry_get_text(GTK_ENTRY(odo_text));
   repeat_str = (char *)gtk_entry_get_text(GTK_ENTRY(repeat_text));
   activity_str = (char *)gtk_entry_get_text(GTK_ENTRY(activity_text));
   comment_str = (char *)gtk_entry_get_text(GTK_ENTRY(comment_text));

   /* ALERT saved */
   if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(alert_but)) == TRUE)
   {
      if ((odo_str == NULL) || (atof(odo_str) <= 0.0))
      {
         dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Alert not Stored! Invalid odometer.");
         gtk_dialog_run (GTK_DIALOG (dialog));
         gtk_widget_destroy (dialog);
         return;
      }
      if ((activity_str == NULL) || (strlen(activity_str) == 0))
      {
         dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Alert not Stored! Invalid Activity.");
         gtk_dialog_run (GTK_DIALOG (dialog));
         gtk_widget_destroy (dialog);
         return;
      }

      car = gtk_combo_box_get_active_text(GTK_COMBO_BOX(car_selector));
      if (car != NULL)
      {
         if (car[strlen(car) - 1] == '\n')
         {
            car[strlen(car) - 1] = '\0';
         }

         /* IF Repeat String is empty then put in 0 */
         if (strlen(repeat_str) == 0)
            addAlertEntry(car, odo_str, "0", activity_str, comment_str);
         else
            addAlertEntry(car, odo_str, repeat_str, activity_str, comment_str);
         common_tab_updateDisplayTab(car);
         g_free(car);

         /* Clear all entries */
         gtk_entry_set_text(GTK_ENTRY(date_text), "");
         gtk_entry_set_text(GTK_ENTRY(odo_text), "");
         gtk_entry_set_text(GTK_ENTRY(repeat_text), "");
         gtk_entry_set_text(GTK_ENTRY(activity_text), "");
         gtk_entry_set_text(GTK_ENTRY(comment_text), "");
      }
      else
      {
         dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Alert not Stored! Please create car first.");
         gtk_dialog_run (GTK_DIALOG (dialog));
         gtk_widget_destroy (dialog);
      }
   }
   /* ACTIVITY saved */
   else
   {
       if (common_valid_date(date_str) == FALSE)
       {
          dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Activity not Stored! Invalid date.");
          gtk_dialog_run (GTK_DIALOG (dialog));
          gtk_widget_destroy (dialog);
          return;
       }
      if ((odo_str == NULL) || (atof(odo_str) <= 0.0))
      {
         dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Activity not Stored! Invalid odometer.");
         gtk_dialog_run (GTK_DIALOG (dialog));
         gtk_widget_destroy (dialog);
         return;
      }
      if ((activity_str == NULL) || (strlen(activity_str) == 0))
      {
         dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Activity not Stored! Invalid Activity.");
         gtk_dialog_run (GTK_DIALOG (dialog));
         gtk_widget_destroy (dialog);
         return;
      }

      car = gtk_combo_box_get_active_text(GTK_COMBO_BOX(car_selector));
      if (car != NULL)
      {
         if (car[strlen(car) - 1] == '\n')
         {
            car[strlen(car) - 1] = '\0';
         }
         addActivityEntry(car, date_str, odo_str, activity_str, comment_str);
         common_tab_updateDisplayTab(car);
         g_free(car);

         /* Clear all entries */
         gtk_entry_set_text(GTK_ENTRY(date_text), "");
         gtk_entry_set_text(GTK_ENTRY(odo_text), "");
         gtk_entry_set_text(GTK_ENTRY(repeat_text), "");
         gtk_entry_set_text(GTK_ENTRY(activity_text), "");
         gtk_entry_set_text(GTK_ENTRY(comment_text), "");
      }
      else
      {
          dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Activity not Stored! Please create car first.");
          gtk_dialog_run (GTK_DIALOG (dialog));
          gtk_widget_destroy (dialog);
      }
   }
}

void
care_button_clicked_cb(GtkWidget* w, gpointer data)
{
   /* IF alert button is TRUE */
   if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)) == TRUE)
   {
      if (date_label)
         gtk_widget_set_sensitive(GTK_WIDGET(date_label), FALSE);
      if (date_text)
         gtk_widget_set_sensitive(GTK_WIDGET(date_text), FALSE);
      if (repeat_label)
         gtk_widget_set_sensitive(GTK_WIDGET(repeat_label), TRUE);
      if (repeat_text)
         gtk_widget_set_sensitive(GTK_WIDGET(repeat_text), TRUE);
   }
   else
   {
      if (date_label)
         gtk_widget_set_sensitive(GTK_WIDGET(date_label), TRUE);
      if (date_text)
         gtk_widget_set_sensitive(GTK_WIDGET(date_text), TRUE);
      if (repeat_label)
         gtk_widget_set_sensitive(GTK_WIDGET(repeat_label), FALSE);
      if (repeat_text)
         gtk_widget_set_sensitive(GTK_WIDGET(repeat_text), FALSE);
   }
}

