/*****************************************************************************
 *** Mauku - Jaiku client for Maemo devices 
 ***
 *** Copyright (c) 2007 Henrik Hedberg <hhedberg@innologies.fi>
 ***
 *** Licensed under the Apache License, Version 2.0 (the "License");
 *** you may not use this file except in compliance with the License.
 *** You may obtain a copy of the License at
 ***
 ***     http://www.apache.org/licenses/LICENSE-2.0
 ***
 *** Unless required by applicable law or agreed to in writing, software
 *** distributed under the License is distributed on an "AS IS" BASIS,
 *** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *** See the License for the specific language governing permissions and
 *** limitations under the License.
 ***
 *****************************************************************************/

#ifndef INCLUDED_IMAGECACHE_H
#define INCLUDED_IMAGECACHE_H

#include "config.h"

#include <glib.h>
#include <gtk/gtk.h>

/* Data types */

typedef struct {
	GHashTable* images;
	GMutex* images_mutex;
} ImageCache;

/* Constructor and destructor */

ImageCache* image_cache_new();
void image_cache_destroy(ImageCache* image_cache);

/* Member functions */

GdkPixbuf* image_cache_load_image(ImageCache* image_cache, MicrofeedHttp* http, gchar* url);

#endif
