/*****************************************************************************
 *** Mauku - The micro-blogging client for Maemo devices 
 ***
 *** Copyright (c) 2007-2008 Henrik Hedberg <hhedberg@innologies.fi>
 ***
 *** Licensed under the Apache License, Version 2.0 (the "License");
 *** you may not use this file except in compliance with the License.
 *** You may obtain a copy of the License at
 ***
 ***     http://www.apache.org/licenses/LICENSE-2.0
 ***
 *** Unless required by applicable law or agreed to in writing, software
 *** distributed under the License is distributed on an "AS IS" BASIS,
 *** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *** See the License for the specific language governing permissions and
 *** limitations under the License.
 ***
 *****************************************************************************/

#ifndef INCLUDED_UI_H
#define INCLUDED_UI_H

#include "config.h"

#include <glib.h>

/* Data types */

typedef enum {
	UI_SENSITIVE_ACTION_WRITE_SOMETHING = 1 << 0,
	UI_SENSITIVE_ACTION_UPDATE = 1 << 1,
	UI_SENSITIVE_ACTION_ADD_COMMENT = 1 << 2,
	UI_SENSITIVE_ACTION_SEND = 1 << 3,
	UI_SENSITIVE_ACTION_OPEN_OVERVIEW = 1 << 4,
	UI_SENSITIVE_ACTION_OPEN_CONTACTS = 1 << 5,
	UI_SENSITIVE_ACTION_OPEN_EXPLORE = 1 << 6,
	UI_SENSITIVE_ACTION_OPEN_YOUR_ITEMS = 1 << 7,
	UI_SENSITIVE_ACTION_OPEN_MARKED_ITEMS = 1 << 8,
	UI_SENSITIVE_ACTION_OPEN_DIRECT_MESSAGES = 1 << 9,
	UI_SENSITIVE_ACTION_OPEN_REPLIES = 1 << 10,
	UI_SENSITIVE_ACTION_ALL = (1 << 11) - 1
} UiSensitiveActionType;

/* Initializer */

void ui_init();

/* Static functions */

#include "view.h"

void ui_close_view(View* view);
void ui_popup_menu();
void ui_set_location(const gchar* location_text);
void ui_set_sensitive_actions(UiSensitiveActionType sensitive_actions);
void ui_set_toolbar_hidden(gboolean toolbar_hidden);
void ui_set_update_sensitive(gboolean update_sensitive);
void ui_start_update(View* view);
void ui_start_update_overview();

#endif
	
