/*****************************************************************************
 *** Mauku - The micro-blogging client for Maemo devices 
 ***
 *** Copyright (c) 2007-2008 Henrik Hedberg <hhedberg@innologies.fi>
 ***
 *** Licensed under the Apache License, Version 2.0 (the "License");
 *** you may not use this file except in compliance with the License.
 *** You may obtain a copy of the License at
 ***
 ***     http://www.apache.org/licenses/LICENSE-2.0
 ***
 *** Unless required by applicable law or agreed to in writing, software
 *** distributed under the License is distributed on an "AS IS" BASIS,
 *** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *** See the License for the specific language governing permissions and
 *** limitations under the License.
 ***
 *****************************************************************************/

#ifndef INCLUDED_MAUKU_H
#define INCLUDED_MAUKU_H

#include "config.h"

#include <gconf/gconf-client.h>
#include <libosso.h>

/* Support for backtrace uploads */

#define MAUKU_BACKTRACE_UPLOADS_ENABLED

/* DBUS constants */

#define MAUKU_DBUS_NAME "com.henrikhedberg.mauku"
#define MAUKU_LED_PATTERN_NAME "PatternComHenrikhedbergMauku"

/* GConf configuration keys */

#define MAUKU_GCONF_DIR "/apps/mauku"
#define MAUKU_GCONF_KEY_CONFIGURATION_VERSION MAUKU_GCONF_DIR "/version"
#define MAUKU_GCONF_KEY_JAIKU_ENABLED MAUKU_GCONF_DIR "/jaiku/enabled"
#define MAUKU_GCONF_KEY_JAIKU_NAME MAUKU_GCONF_DIR "/jaiku/name"
#define MAUKU_GCONF_KEY_JAIKU_PASSWORD MAUKU_GCONF_DIR "/jaiku/password"
#define MAUKU_GCONF_KEY_JAIKU_KEY MAUKU_GCONF_DIR "/jaiku/key"
#define MAUKU_GCONF_KEY_TWITTER_ENABLED MAUKU_GCONF_DIR "/twitter/enabled"
#define MAUKU_GCONF_KEY_TWITTER_NAME MAUKU_GCONF_DIR "/twitter/name"
#define MAUKU_GCONF_KEY_TWITTER_PASSWORD MAUKU_GCONF_DIR "/twitter/password"
#define MAUKU_GCONF_DIR_EMAIL MAUKU_GCONF_DIR "/email"
#define MAUKU_GCONF_KEY_EMAIL_ENABLED MAUKU_GCONF_DIR_EMAIL "/enabled"
#define MAUKU_GCONF_KEY_EMAIL_PROTO MAUKU_GCONF_DIR_EMAIL "/proto"
#define MAUKU_GCONF_KEY_EMAIL_HOST MAUKU_GCONF_DIR_EMAIL "/host"
#define MAUKU_GCONF_KEY_EMAIL_PORT MAUKU_GCONF_DIR_EMAIL "/port"
#define MAUKU_GCONF_KEY_EMAIL_NAME MAUKU_GCONF_DIR_EMAIL "/name"
#define MAUKU_GCONF_KEY_EMAIL_PASSWORD MAUKU_GCONF_DIR_EMAIL "/password"
#define MAUKU_GCONF_KEY_UPDATE MAUKU_GCONF_DIR "/update"
#define MAUKU_GCONF_KEY_KEEP_OLD_ITEMS MAUKU_GCONF_DIR "/keep_old_items"
#define MAUKU_GCONF_KEY_SHOW_TOOLBAR MAUKU_GCONF_DIR "/show_toolbar"
#define MAUKU_GCONF_KEY_SHOW_SCROLLBAR MAUKU_GCONF_DIR "/show_scrollbar"
#define MAUKU_GCONF_KEY_NEW_ITEM_NOTIFICATION MAUKU_GCONF_DIR "/new_item_notification"
#define MAUKU_GCONF_KEY_BLINK_LED MAUKU_GCONF_DIR "/blink_led"
#define MAUKU_GCONF_KEY_BACKLIGHT MAUKU_GCONF_DIR "/backlight"
#define MAUKU_GCONF_KEY_RAISE_WINDOW MAUKU_GCONF_DIR "/raise_window"
#define MAUKU_GCONF_KEY_SPEECH MAUKU_GCONF_DIR "/speech"
#define MAUKU_GCONF_KEY_MARKED_ITEMS MAUKU_GCONF_DIR "/marked_items"

/* Stock icons */

#define MAUKU_STOCK_CONTACTS "mauku-contacts"
#define MAUKU_STOCK_LOCATION_CHANGE "mauku-location-change"
#define MAUKU_STOCK_MAIL_MESSAGE_NEW "mauku-mail-message-new"
#define MAUKU_STOCK_OVERVIEW "mauku-overview"
#define MAUKU_STOCK_VIEW_REFRESH "mauku-view-refresh"

/* Other header files */

#include "ui.h"
#include "sending.h"
#include "http.h"
#include "view.h"
#include "settings.h"
#include "imagecache.h"
#include "backend.h"
#include "jaiku.h"
#include "twitter.h"
#include "texttospeechservice.h"
#include "geoclue.h"
#include "email.h"

/* Global variables */

extern osso_context_t* osso_context; /* in main.c */
extern ImageCache* image_cache; /* in main.c */
extern GConfClient* gconf; /* in settings.c */

/* Thread debugging support */

#ifdef NO_THREADS
#undef gdk_threads_enter
#define gdk_threads_enter()
#undef gdk_threads_leave
#define gdk_threads_leave() 
#undef g_thread_create
#define g_thread_create(a, b, c, d) a(b)
#endif

#ifdef DEBUG_THREADS
#define gdk_threads_enter() printf("*** Threads ENTER >>> %s\n", __FUNCTION__); gdk_threads_enter();
#define gdk_threads_leave() printf("*** Threads LEAVE <<< %s\n", __FUNCTION__); gdk_threads_leave();
#endif

/* Other constants */

#define UPDATE_THREAD_NICE_INCREMENT 10

#endif
