/*****************************************************************************
 *** Mauku - Jaiku client for Maemo devices 
 ***
 *** Copyright (c) 2007 Henrik Hedberg <hhedberg@innologies.fi>
 ***
 *** Licensed under the Apache License, Version 2.0 (the "License");
 *** you may not use this file except in compliance with the License.
 *** You may obtain a copy of the License at
 ***
 ***     http://www.apache.org/licenses/LICENSE-2.0
 ***
 *** Unless required by applicable law or agreed to in writing, software
 *** distributed under the License is distributed on an "AS IS" BASIS,
 *** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *** See the License for the specific language governing permissions and
 *** limitations under the License.
 ***
 *****************************************************************************/

#ifndef INCLUDED_HTTP_H
#define INCLUDED_HTTP_H

#include "config.h"

#include <curl/curl.h>
#include <json.h>
#include <time.h>

/* Data types */

typedef struct json_object JsonObject;

typedef struct _Http Http;

/* Initializer, cleanup, constructor and destructor*/

void http_init();
void http_cleanup();
Http* http_new();
void http_destroy(Http* http);

/* Member functions */

void http_free(Http* http, gchar* ptr);
char* http_get_data(Http* http, const char* url, size_t* len);
JsonObject* http_get_json_object(Http* http, const char* url);
time_t http_get_reply_start_time(Http* http);
time_t http_get_server_time(Http* http);
time_t http_parse_date(Http* http, gchar* datestring);
char* http_post_data(Http* http, const char* url, size_t* len, const char* post_data);
JsonObject* http_post_json_object(Http* http, const char* url, const char* post_data);
gboolean http_set_cookie_file(Http* http, const gchar* filename);
gboolean http_set_basic_authentication(Http* http, const gchar* userpass);
gchar* http_url_encode(Http* http, const gchar* s);

/* Static functions */

gboolean http_is_connected();
gboolean http_make_connected();

#endif
