/*****************************************************************************
 *** Mauku - Jaiku client for Maemo devices 
 ***
 *** Generic backend functionality
 ***
 *** Copyright (c) 2007-2008 Henrik Hedberg <hhedberg@innologies.fi>
 ***
 *** Licensed under the Apache License, Version 2.0 (the "License");
 *** you may not use this file except in compliance with the License.
 *** You may obtain a copy of the License at
 ***
 ***     http://www.apache.org/licenses/LICENSE-2.0
 ***
 *** Unless required by applicable law or agreed to in writing, software
 *** distributed under the License is distributed on an "AS IS" BASIS,
 *** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *** See the License for the specific language governing permissions and
 *** limitations under the License.
 ***
 *****************************************************************************/

#ifndef INCLUDED_BACKEND_H
#define INCLUDED_BACKEND_H

/* Data types */

typedef gboolean (*UpdateThreadCallback)(ViewAddingSession* session, JsonObject* feed, Http* http, time_t delta, gpointer user_data);

/* Static functions */

GList* backend_append_links_to_selections(GList* selections, gchar* text, GCallback callback);
void backend_start_update(View* view, gchar* url, gchar* userpass, ViewItemSource* item_source, gboolean keep_old_items, UpdateThreadCallback update_thread_callback, gpointer user_data);
void backend_update_marked_items_view(View* view);

#endif
