#include "songlistend.h"
#include "../common.h"

sqlite3 *db = NULL;
osso_context_t *osso = NULL;
GMainLoop *loop = NULL;
GConfClient *gc;

unsigned long trackCounter=0;

gchar artist[256];
gchar track[256];
gchar album[256];
unsigned int duration=0;
unsigned int playstarted=0;
unsigned long trackCount=0;
unsigned int prevtype = 0;

void signalHandler(int sig);
gboolean waitInsert(gpointer data);
gboolean insertTrack(char *artist, char *track, char *album, int duration, int playedon);

void signalHandler(int sig)
{
switch(sig){
			case SIGHUP:
				syslog(LOG_NOTICE, "got HUP");
				break;		
			case SIGTERM:
				g_main_loop_quit(loop);
				break;		
		}
}

void notify()
{
osso_rpc_async_run(osso,
									"com.nokia.scrobblerd",
									"/com/nokia/scrobblerd",
									"com.nokia.scrobblerd",
									"notify", async_cb, NULL,
									DBUS_TYPE_STRING,
									artist,
									DBUS_TYPE_STRING,
									track,
									DBUS_TYPE_STRING,
									album,
									DBUS_TYPE_UINT32,
									duration,
									DBUS_TYPE_INVALID);
}

/*xtype: 1:dbus 2:osso-media-server signal*/
void playing(gchar* xtrack, gchar* xartist, gchar *xalbum, unsigned int xlength, unsigned int xposition, unsigned int xtype)
{
int ti=(int)time(NULL);
int ps = ti - xposition; /* play started */

if ((xposition>=240) || (xposition>(xlength/2)))
	{
	insertTrack(xartist, xtrack, xalbum, xlength, ps);
	trackCount = 0;
	}
else
	{
	if (abs(xlength-duration)<=1 && abs(playstarted-ps)<30)
		{
		syslog(LOG_NOTICE, "skipping duplicate track (%s/%s)", xtrack, xartist);
		return;
		}

	trackCounter++;
	trackCount = trackCounter;

	strncpy(artist, xartist, sizeof(artist));
	strncpy(track, xtrack, sizeof(track));
	strncpy(album, xalbum, sizeof(album));
	duration = xlength;
	playstarted=ps;
	prevtype = xtype;
	
	int submpos = xlength/2;
	if (submpos>240) submpos = 240;
	int submtime = playstarted + submpos;
	
	if (ti>submtime)
		{
		syslog(LOG_ERR, "current time > track endtime!");
		trackCount=0;
		}
	else
		{
		notify();
		g_timeout_add((submtime - ti)*1000, waitInsert, (gpointer) trackCount);
		}
	}
	
	
}

gint dbus_callback (const gchar *interface, const gchar *method, GArray *arguments, gpointer data, osso_rpc_t *retval)
{
  syslog(LOG_NOTICE, "songlistend dbus: %s, %s\n", interface, method);
/*
syslog(LOG_WARNING, "arglen: %d", arguments->len);
int j;
for(j=0;j<arguments->len;j++)
    {
    osso_rpc_t v=g_array_index(arguments, osso_rpc_t, j);
    if (v.type==DBUS_TYPE_STRING) syslog(LOG_WARNING, "arg %d: string: %s", j, v.value.s);
    else if (v.type==DBUS_TYPE_UINT32) syslog(LOG_WARNING, "arg %d: uint32: %ul", j, v.value.u);
    else if (v.type==DBUS_TYPE_INT32) syslog(LOG_WARNING, "arg %d: int32: %d", j, v.value.i);
    else if (v.type==DBUS_TYPE_DOUBLE) syslog(LOG_WARNING, "arg %d: double", j);
    else syslog(LOG_WARNING, "arg %d: unknown", j);
    }
*/
 	if (g_ascii_strcasecmp(method, "quit") == 0)
 		{
		g_main_loop_quit(loop);
		}

/*
string:artist name
string:track name
string:album name (or empty string)
int32 / uint32:track duration in seconds
int32 / uint32:current position in seconds
*/
 	else if (g_ascii_strcasecmp(method, "playing") == 0)
 		{
		if (arguments->len!=5)
			{
			syslog(LOG_WARNING, "got PLAYING call, invalid number of arguments!");
			}
		else
			{
			do
				{
				osso_rpc_t art=g_array_index(arguments, osso_rpc_t, 0);
				osso_rpc_t tra=g_array_index(arguments, osso_rpc_t, 1);
				osso_rpc_t alb=g_array_index(arguments, osso_rpc_t, 2);
				osso_rpc_t dur=g_array_index(arguments, osso_rpc_t, 3);
				osso_rpc_t pos=g_array_index(arguments, osso_rpc_t, 4);
			
				if (art.type!=DBUS_TYPE_STRING || art.value.s==NULL) break;
				if (tra.type!=DBUS_TYPE_STRING || tra.value.s==NULL) break;
				if (alb.type!=DBUS_TYPE_STRING || alb.value.s==NULL) break;
				if (dur.type!=DBUS_TYPE_UINT32 && dur.type!=DBUS_TYPE_INT32) break;
				if (pos.type!=DBUS_TYPE_UINT32 && pos.type!=DBUS_TYPE_INT32) break;
				if (dur.value.u<30) break;
				if (pos.value.u>dur.value.u) break;

				syslog(LOG_NOTICE, "PLAYING call valid: %s/%s", art.value.s, tra.value.s);

				playing(tra.value.s, art.value.s, alb.value.s, dur.value.u, pos.value.u, 1);

				}while(false);
			}
		}/*playing*/

 	else if (g_ascii_strcasecmp(method, "stopped") == 0)
 		{
		syslog(LOG_NOTICE, "STOPPED call");
		trackCount=0;
		}/*stopped*/

  retval->type = DBUS_TYPE_INVALID;
  return OSSO_OK;
}

gboolean waitInsert(gpointer data)
{
if (trackCount==0) return(false);

unsigned int tc=(unsigned long)data;
if (tc!=trackCount)
	{
	syslog(LOG_NOTICE, "waitInsert() called too late, cache is invalid");
	return(false);
	}

insertTrack(artist, track, album, duration, playstarted);
trackCount=0;

return(false);
}

static void media_server_details(DBusGProxy* prox, const GHashTable* table, gpointer userData)
{
gchar *track, *artist, *album, *tmp;
unsigned int length = 0;

tmp	= g_hash_table_lookup(table, "has_video");
if (tmp == NULL || strcmp(tmp, "0")!=0)
	{
	syslog(LOG_NOTICE, "debug: playing video, skipped");
	return;
	}

track	= g_hash_table_lookup(table, "title");
artist	= g_hash_table_lookup(table, "artist");
album	= g_hash_table_lookup(table, "album");
tmp	= g_hash_table_lookup(table, "length");
if (tmp!=NULL)
	{
	length = g_strtod(tmp, NULL)/1000;
	}

if (album==NULL) album="";

if (length<30 || track==NULL || artist==NULL)
	{
	syslog(LOG_NOTICE, "track not applicable, skipping");
	return;
	}

syslog(LOG_NOTICE, "debug: signal: %s/%s/%s/%d", track, artist, album, length);
playing(track, artist, album, length, 0, 2);
}

void media_server_connect()
{
DBusGConnection* bus;
DBusGProxy* prox;

/*
 signal sender=:1.11 -> dest=(null destination) path=; interface=com.nokia.osso_media_server.music; member=details_received
  array [
      dict entry(
         string "length"
         string "480705"
      )
      dict entry(
         string "has_video"
         string "0"
      )
      dict entry(
         string "seekable"
         string "1"
      )
      dict entry(
         string "title"
         string "While We Were Hunting Rabbits"
      )
      dict entry(
         string "artist"
         string "Matthew Good"
      )
      dict entry(
         string "date"
         string "2003-01-01"
      )
      dict entry(
         string "album"
         string "Avalanche"
      )
      dict entry(
         string "genre"
         string "Rock"
      )
      dict entry(
         string "track number"
         string "7"
      )
   ]
*/
bus = dbus_g_bus_get(DBUS_BUS_SESSION, NULL);
prox = dbus_g_proxy_new_for_name(bus, "com.nokia.osso_media_server", "/com/nokia/osso_media_server", "com.nokia.osso_media_server.music");
if (prox == NULL)
	{
	syslog(LOG_ERR, "Could not set up proxy for osso_media_server");
	return;
	}

dbus_g_proxy_add_signal(prox, "details_received", /*DBUS_TYPE_G_STRING_STRING_HASHTABLE*/dbus_g_type_get_map ("GHashTable", G_TYPE_STRING, G_TYPE_STRING), G_TYPE_INVALID);
dbus_g_proxy_connect_signal(prox, "details_received", G_CALLBACK(media_server_details), NULL, NULL);
syslog(LOG_DEBUG, "Connected to osso_media_server's details_received");
}

int main(int argc, char *argv[])
{
int lfp=0;

openlog("songlistend", LOG_PID | LOG_PERROR, LOG_DAEMON);

if (getuid()==0)
	{
	syslog(LOG_ERR, "do not run as root!");
	exit(1);
	}

gboolean dbuscalled=false;
if (argc>1 && strcmp(argv[1], "--dbus")==0)
	{
	dbuscalled=true;
	}

lfp=open("/var/run/songlistend.lock",O_RDWR|O_CREAT,0640);
if (lfp<0)
	{
	syslog(LOG_ERR, "could not open lock file for writing");
	if (dbuscalled==false) exit(1);
	}
else if (flock(lfp, LOCK_EX | LOCK_NB)<0)
	{
	syslog(LOG_ERR, "already running");
	exit(1);
	}


if (dbuscalled==false)
	{
	pid_t pid;
	if ((pid = fork()) < 0)
		{
	  return 1;
		}
	else if (pid != 0)
		{
	  exit(0);
		}
	}

setsid();
chdir("/");
umask(022); /* 755 */

if (lfp>0)
	{
	char str[16];
	sprintf(str,"%d\n",getpid());
	write(lfp,str,strlen(str));
	}

signal(SIGCHLD,SIG_IGN);
signal(SIGTSTP,SIG_IGN);
signal(SIGTTOU,SIG_IGN);
signal(SIGTTIN,SIG_IGN);
signal(SIGHUP, signalHandler);
signal(SIGTERM, signalHandler);

g_type_init();
gc = gconf_client_get_default();

osso = osso_initialize("songlistend", PACKAGE_VERSION, FALSE/*dbuscalled*/, NULL);

/* if (osso_rpc_set_default_cb_f(osso, dbus_callback, NULL) != OSSO_OK) */
if (osso_rpc_set_cb_f(osso, "com.nokia.songlistend", "com/nokia/songlistend", "com.nokia.songlistend", dbus_callback, NULL) != OSSO_OK)
	{
	syslog(LOG_ERR, "error setting dbus callback");
	exit(1);
	}

media_server_connect();
	
loop=g_main_loop_new(NULL, TRUE);
g_main_loop_run(loop);

if (db) sqlite3_close(db);
if (osso) osso_deinitialize(osso);

syslog(LOG_NOTICE, "exiting");
return(0);
}

static void async_cb(const gchar *interface, const gchar *method,
                     osso_rpc_t *retval, gpointer data)
{
/*
syslog(LOG_ERR, "method %s returned", method);
*/
}


gboolean insertTrack(char *artist, char *track, char *album, int duration, int playedon)
{
if(gc_get_bool_fall(gc, GCONF_PATH_SCROBBLE, TRUE)!=TRUE)
	{
	syslog(LOG_DEBUG, "skipping insertion: scrobbling is disabled");
	return(true);
	}

if (!db)
	{
	int rc;
	rc = sqlite3_open(SCROBBLERDB, &db);
	if (rc)
		{
		db=NULL;
		syslog(LOG_WARNING, "could not open sqlite3 db: %d", rc);
		return(false);
		}
	sqlite3_exec(db, "PRAGMA synchronous = OFF;", NULL, NULL, NULL);
	}

char tq[1024];
	
sprintf(tq, "CREATE TABLE tracks ( \
	idx INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, \
	artist TEXT, \
	track TEXT, \
	album TEXT, \
	duration INTEGER NOT NULL DEFAULT 0, \
	playedon INTEGER NOT NULL DEFAULT 0, \
	submitdate INTEGER NOT NULL DEFAULT 0);");
sqlite3_exec(db, tq, NULL, NULL, NULL);

sprintf(tq, "CREATE INDEX tracks_index ON tracks (submitdate, playedon);");
sqlite3_exec(db, tq, NULL, NULL, NULL);

sprintf(tq, "INSERT INTO tracks (artist, track, album, duration, playedon) VALUES(?, ?, ?, %d, %d)", duration, playedon);
sqlite3_stmt *stmt = NULL;
const char *dum;
int rc = sqlite3_prepare(db, tq, strlen(tq), &stmt, &dum);
if (rc)
	{
	syslog(LOG_WARNING, "error preparing to insert: %d", rc);
	return(false);
	}
sqlite3_bind_text(stmt, 1, artist, strlen(artist), SQLITE_TRANSIENT);
sqlite3_bind_text(stmt, 2, track, strlen(track), SQLITE_TRANSIENT);
sqlite3_bind_text(stmt, 3, album, strlen(album), SQLITE_TRANSIENT);

rc = SQLITE_BUSY;
while(rc == SQLITE_BUSY)
	{
		rc = sqlite3_step(stmt);
		if (rc == SQLITE_ERROR || rc == SQLITE_MISUSE || rc == SQLITE_DONE)
			break;
	}
sqlite3_finalize(stmt);

if (rc == SQLITE_ERROR || rc == SQLITE_MISUSE)
	{
	syslog(LOG_WARNING, "error inserting: %d", rc);
	return(false);
	}

syslog(LOG_NOTICE, "inserted track: %s/%s", artist, track);

osso_rpc_async_run(osso,
	"com.nokia.scrobblerd",
	"/com/nokia/scrobblerd",
	"com.nokia.scrobblerd",
	"run", async_cb, NULL,
	DBUS_TYPE_INVALID);
  
/*syslog(LOG_ERR, "ret is %d", ret);*/

return(true);
}
