#include "../common.h"
#include "lastfm.h"
#include "../md5.h"

int lastfm_loggedin = 0;
char sessionid[33];
char posturl[256];
char npurl[256];
int interval=0;

size_t curlDataReceived(void *ptr, size_t size, size_t nmemb, FILE *stream);

size_t curlDataReceived(void *ptr, size_t size, size_t nmemb, FILE *stream) 
{ 
  if(g_string_append((GString *)stream, (char *) ptr) == NULL) { 
     return(-1); 
  } else { 
     return(strlen(ptr)); 
  } 
}

int geturl(char *url, char *postfields, GString *out)
{
if (out==NULL) return(1);

CURL *curl = curl_easy_init();

if (curl)
	{
	curl_easy_setopt(curl, CURLOPT_URL, url);
	curl_easy_setopt(curl, CURLOPT_USERAGENT, "maemoscrobbler");
	curl_easy_setopt(curl, CURLOPT_FAILONERROR, 1);
	curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, 1);
	curl_easy_setopt(curl, CURLOPT_TIMEOUT, 10);
	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, curlDataReceived);
	curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 1);
	curl_easy_setopt(curl, CURLOPT_MUTE, 1);
	curl_easy_setopt(curl, CURLOPT_FILE, out);
	if (postfields!=NULL) curl_easy_setopt(curl, CURLOPT_POSTFIELDS, postfields);
	
	int ret=curl_easy_perform(curl);
	curl_easy_cleanup(curl);

/*
	if (ret!=0)
		{
		syslog(LOG_DEBUG, "error in geturl(): %d", ret);
		}
*/

	return(ret);
	}

return(1);
}

/*ret=0:conn error  1:ok  2:badauth 3:badtime 4:banned 5:failed 6:other error*/
gint lastfm_login(gchar *username, gchar *passmd5)
{
/*fprintf(stderr, "lastfm_login()\n");*/

if (interval>0) sleep(interval);

GString *str=g_string_new(NULL);

CURL *curl = curl_easy_init();
char *un=curl_easy_escape(curl, username, 0);

int ts = (int)time(NULL);
char tm[96];
sprintf(tm, "%s%d", passmd5, ts);
char auth[64];
md5(tm, auth);

char url[256];
sprintf(url, "http://post.audioscrobbler.com/?hs=true&p=1.2.1&c=mae&v=0.1&u=%s&t=%d&a=%s", un, ts, auth);

curl_free(un);
curl_easy_cleanup(curl);

int val=geturl(url, NULL, str);
if (val!=0)
	{
	g_string_free(str, true);
	return(0);
	}

gchar *s=g_string_free(str, false);
char tmp[1024];
strncpy(tmp, s, sizeof(tmp));
g_free(s);

/*syslog(LOG_NOTICE, "response *%s*", tmp);*/

gchar** t=g_strsplit(tmp, "\n", 0);
guint len=g_strv_length(t);

gint retval=6;
lastfm_loggedin=0;

char tt[128];
char *in;

if (len>3)
	{
	strncpy(tt, t[0], sizeof(tt));
	in=index(tt, ' ');
	if (in) tt[in-tt]=0;
	
	if (strcmp(tt, "OK")==0)
		{
		retval=1;
		lastfm_loggedin=1;
		interval=0;
		}
	else if (strcmp(tt, "BADAUTH")==0) retval=2;
	else if (strcmp(tt, "BADTIME")==0) retval=3;
	else if (strcmp(tt, "BANNED")==0) retval=4;
	else if (strcmp(tt, "FAILED")==0) retval=5;
	
/*	fprintf(stderr, "TEST0: *%s*\n", tt);*/

	strncpy(sessionid, t[1], sizeof(sessionid));
/*	syslog(LOG_NOTICE, "session id *%s*", sessionid);*/

	strncpy(npurl, t[2], sizeof(npurl));
/*	syslog(LOG_NOTICE, "np url *%s*", npurl);*/

	strncpy(posturl, t[3], sizeof(posturl));
/*	syslog(LOG_NOTICE, "post url *%s*", posturl);*/
	}

g_strfreev(t);

if (retval>1)
	{
	if (interval==0) interval=60;
	else if (interval>0) interval*=2;
	if (interval>=120*60) interval=120*60;

	syslog(LOG_NOTICE, "failure wait interval is=%d", interval);
	}

return(retval);
}

/* errno: 1=ok >9=error */
gboolean lastfm_submit(gchar *username, gchar *passmd5, GString *songs, gint *errno)
{
/*fprintf(stderr, "lastfm_submit()\n");*/

gboolean retval=false;

if (lastfm_loggedin==0)
	{
	int loret=lastfm_login(username, passmd5);
	if (loret!=1)
		{
		if (loret>0) *errno=10; /*other error, invalid username?*/
						 else *errno=2; /*conn prob*/
		return(retval);
		}
	}

*errno=3; /*conn prob 2*/

GString *pf=g_string_new(NULL);

g_string_printf(pf, "s=%s&%s", sessionid, songs->str);

/*syslog(LOG_NOTICE, "pf *%s*", pf->str);*/

GString *pres=g_string_new(NULL);
int val=geturl(posturl, pf->str, pres);

g_string_free(pf, true);

if (val!=0)
	{
	g_string_free(pres, true);
	return(false);
	}

*errno=4;

/*fprintf(stderr, "pres=*%s*\n", pres->str);*/

gchar *s=g_string_free(pres, false);
char tmp[1024];
strncpy(tmp, s, sizeof(tmp));
g_free(s);

gchar** t=g_strsplit(tmp, "\n", 0);
guint len=g_strv_length(t);

if (len>0)
	{
	if (strcmp(t[0], "OK")==0)
		{
		retval=true;
		*errno=1;
		}
	else
		{
		if (strcmp(t[0], "BADSESSION")==0)
			{
			*errno=11;
			lastfm_loggedin=0;
			}
		else
			{
			*errno=5;
			}

		syslog(LOG_ERR, "ERROR: %s", t[0]);
		}
	
	}

return(retval);
}

/* errno: 1=ok >9=error */
gboolean lastfm_notify(gchar *username, gchar *passmd5, GString *song, gint *errno)
{
/*fprintf(stderr, "lastfm_notify()\n");*/

gboolean retval=false;

if (lastfm_loggedin==0)
	{
	int loret=lastfm_login(username, passmd5);
	if (loret!=1)
		{
		if (loret>0) *errno=10; /*other error, invalid username?*/
						 else *errno=2; /*conn prob*/
		return(retval);
		}
	}

*errno=3; /*conn prob 2*/

GString *pf=g_string_new(NULL);

g_string_printf(pf, "s=%s&%s", sessionid, song->str);

/*fprintf(stderr, "pf=*%s*\n", pf->str);*/

GString *pres=g_string_new(NULL);
int val=geturl(npurl, pf->str, pres);

g_string_free(pf, true);

if (val!=0)
	{
	g_string_free(pres, true);
	return(false);
	}

*errno=4;

/*fprintf(stderr, "pres=*%s*\n", pres->str);*/

gchar *s=g_string_free(pres, false);
char tmp[1024];
strncpy(tmp, s, sizeof(tmp));
g_free(s);

gchar** t=g_strsplit(tmp, "\n", 0);
guint len=g_strv_length(t);

if (len>0)
	{
	if (strcmp(t[0], "OK")==0)
		{
		retval=true;
		*errno=1;
		}
	else
		{
		if (strcmp(t[0], "BADSESSION")==0)
			{
			*errno=11;
			lastfm_loggedin=0;
			}
		else
			{
			*errno=5;
			}

		syslog(LOG_ERR, "ERROR: %s", t[0]);
		}
	
	}

return(retval);
}
