#include <glib.h>
#include <gtk/gtk.h>

#include <libosso.h>
#include <osso-log.h>

#include <assert.h>
#include <string.h>

#include <hildon/hildon-caption.h>

#include "maemoscrobblercp.h"
#include "../common.h"

#define DEFPASS "********"

static void ui_create_main_dialog(CpApplet *applet, gpointer window);
static void ui_destroy(CpApplet *applet);

osso_return_t execute(osso_context_t * osso, gpointer data,
		      gboolean user_activated)
{
	CpApplet applet;
	gint response = 1;
	
	(void)user_activated;

	/* Create the main dialog and refresh the ui */

	ui_create_main_dialog(&applet, data);

	applet.osso = osso;

	if (applet.dialog == NULL) {
		ULOG_CRIT_L("Unable to create applet dialog, exiting..");
		return OSSO_ERROR;
	}

/*
	while (response == 1) {
		response = gtk_dialog_run(GTK_DIALOG(applet.dialog));
		if (response == 1) {
			gtk_widget_show_all(GTK_WIDGET(applet.commands_dialog));
			gtk_dialog_run(applet.commands_dialog);
			gtk_widget_hide(GTK_WIDGET(applet.commands_dialog));
		}
	}
*/
	response = gtk_dialog_run(GTK_DIALOG(applet.dialog));

	if (response == GTK_RESPONSE_ACCEPT)
		{
		strncpy(applet.as_username, gtk_entry_get_text(GTK_ENTRY(applet.en_username)), 64);
		strncpy(applet.as_passmd5, gtk_entry_get_text(GTK_ENTRY(applet.en_passmd5)), 64);

		applet.enabled=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(applet.ck_enabled));
		applet.submit=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(applet.ck_submit));

		if (strcmp(applet.as_username, "")==0 && strcmp(applet.as_passmd5, "")==0) applet.enabled=FALSE;
	
		gconf_client_set_string(applet.gcc, GCONF_PATH_USERNAME, applet.as_username, NULL);

		if (strcmp(applet.as_passmd5, DEFPASS)!=0)
			{
			char tmp[64];
			md5(applet.as_passmd5, tmp);
			gconf_client_set_string(applet.gcc, GCONF_PATH_PASSMD5, tmp, NULL);
			}

		gconf_client_set_bool(applet.gcc, GCONF_PATH_SCROBBLE, applet.enabled, NULL);
		gconf_client_set_bool(applet.gcc, GCONF_PATH_SUBMIT, applet.submit, NULL);
		if (applet.clear_error==TRUE) gconf_client_set_int(applet.gcc, GCONF_PATH_LASTERROR, 0, NULL);
		}

	/* Make un-initializations */
	ui_destroy(&applet);

	/* Otherwise, return error */
	return OSSO_OK;
}

static void bu_clear_clicked(GtkWidget *widget, CpApplet *applet)
{
applet->clear_error = TRUE;
gtk_label_set_text(GTK_LABEL(applet->lb_last), "Press OK to apply ");
gtk_widget_hide(applet->lb_lasttime);
gtk_widget_set_sensitive(applet->bu_clear, FALSE);
}

static void gch_lasterror(GConfClient *gcc, guint con, GConfEntry *entry, CpApplet *applet)
{
	if (entry->value) applet->gc_errno = gconf_value_get_int(entry->value);
							 else applet->gc_errno = 0;

	char *lasterr="Status: %s ";
	char lab[128];
	if (applet->gc_errno==0) sprintf(lab, lasterr, "Awaiting");
	else if (applet->gc_errno==1) sprintf(lab, lasterr, "OK");
	else if (applet->gc_errno==2 || applet->gc_errno==3) sprintf(lab, lasterr, "Could not connect");
	else if (applet->gc_errno==4) sprintf(lab, lasterr, "General error");
	else if (applet->gc_errno==5) sprintf(lab, lasterr, "Error submitting");
	else if (applet->gc_errno==6) sprintf(lab, lasterr, "DB error");
	else if (applet->gc_errno==10) strcpy(lab, "STOPPED: Invalid username? ");
	else if (applet->gc_errno==11) strcpy(lab, "STOPPED: Incorrect user/pass ");
	else sprintf(lab, "Status: %s (%u) ", "Unknown error", applet->gc_errno);

	gtk_label_set_text(GTK_LABEL(applet->lb_last), lab);

	if (applet->gc_errno>=10) gtk_widget_set_sensitive(applet->bu_clear, TRUE);
											 else gtk_widget_set_sensitive(applet->bu_clear, FALSE);
	
}

static void gch_lasterrortime(GConfClient *gcc, guint con, GConfEntry *entry, CpApplet *applet)
{
if (entry->value)
	{
	time_t tim = (time_t) gconf_value_get_int(entry->value);

	if (tim>0 && applet->gc_errno>0)
		{
		char ti[64];
		strftime(ti, sizeof(ti), "(%H:%M) ", localtime(&tim));
		gtk_label_set_text(GTK_LABEL(applet->lb_lasttime), ti);
		}
	else
		gtk_label_set_text(GTK_LABEL(applet->lb_lasttime), "");
	}
else
	gtk_label_set_text(GTK_LABEL(applet->lb_lasttime), "");
}

static void ui_create_main_dialog(CpApplet *applet, gpointer window)
{
	gchar *tmps;

	applet->gcc = gconf_client_get_default();
	applet->enabled = gc_get_bool_fall(applet->gcc, GCONF_PATH_SCROBBLE, TRUE);
	applet->submit = gc_get_bool_fall(applet->gcc, GCONF_PATH_SUBMIT, TRUE);
	applet->clear_error = FALSE;

	gconf_client_add_dir(applet->gcc, GCONF_PATH, GCONF_CLIENT_PRELOAD_NONE, NULL);
	applet->gc_notify_id_lasterror = gconf_client_notify_add(applet->gcc, GCONF_PATH_LASTERROR, gch_lasterror, applet, NULL, NULL);
	applet->gc_notify_id_lasterrortime = gconf_client_notify_add(applet->gcc, GCONF_PATH_LASTERRORTIME, gch_lasterrortime, applet, NULL, NULL);

	if (!(applet->as_username && applet->as_passmd5)) applet->enabled=FALSE;

	applet->dialog =
		GTK_DIALOG(gtk_dialog_new_with_buttons
			   (_("Scrobbling settings"), GTK_WINDOW(window),
			    GTK_DIALOG_MODAL,
			    _("Ok"), GTK_RESPONSE_ACCEPT,
/*			    _("Commands"), 1,*/
			    _("Cancel"), GTK_RESPONSE_REJECT,
			    NULL)
		);

	GtkWidget *dialog_vbox, *dialog_alignment, *caption;

	dialog_alignment = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
	dialog_vbox = gtk_vbox_new(FALSE, 0);

	gtk_container_add(GTK_CONTAINER(dialog_alignment), dialog_vbox);
	gtk_container_add(GTK_CONTAINER(applet->dialog->vbox), dialog_alignment);

	GtkSizeGroup *size_group = gtk_size_group_new(GTK_SIZE_GROUP_HORIZONTAL);
	
	applet->en_username = gtk_entry_new_with_max_length(64);
	g_object_set(G_OBJECT(applet->en_username), "autocap", FALSE, 0);
	tmps = gconf_client_get_string(applet->gcc, GCONF_PATH_USERNAME, NULL);
	if (tmps)
		{
		gtk_entry_set_text(GTK_ENTRY(applet->en_username), tmps);
		g_free(tmps);
		}
	caption = hildon_caption_new(size_group, "Username:", applet->en_username, NULL, HILDON_CAPTION_MANDATORY);
	gtk_container_add(GTK_CONTAINER(dialog_vbox), caption);

	applet->en_passmd5 = gtk_entry_new_with_max_length(64);
	g_object_set(G_OBJECT(applet->en_passmd5), "autocap", FALSE, 0);
	tmps = gconf_client_get_string(applet->gcc, GCONF_PATH_PASSMD5, NULL);
	if (tmps)
		{
		gtk_entry_set_text(GTK_ENTRY(applet->en_passmd5), DEFPASS);
		g_free(tmps);
		}
	gtk_entry_set_visibility(GTK_ENTRY(applet->en_passmd5), FALSE);

	caption = hildon_caption_new(size_group, "Password:", applet->en_passmd5, NULL, HILDON_CAPTION_MANDATORY);
	gtk_container_add(GTK_CONTAINER(dialog_vbox), caption);

	applet->ck_enabled = gtk_check_button_new();
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(applet->ck_enabled), applet->enabled);
	caption = hildon_caption_new(size_group, "Enable scrobbling", applet->ck_enabled, NULL, HILDON_CAPTION_MANDATORY);
	gtk_container_add(GTK_CONTAINER(dialog_vbox), caption);

	applet->ck_submit=gtk_check_button_new();
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(applet->ck_submit), applet->submit);
	caption = hildon_caption_new(size_group, "Submit if connection is detected", applet->ck_submit, NULL, HILDON_CAPTION_MANDATORY);
	gtk_container_add(GTK_CONTAINER(dialog_vbox), caption);


	GtkWidget *algn = gtk_alignment_new(0.5, 0.5, 0.0, 0.0);
	gtk_alignment_set_padding(GTK_ALIGNMENT(algn), 10, 10, 0, 0);
	
	GtkWidget *hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(algn), hbox);

	applet->lb_last = gtk_label_new("Status: (unknown) ");
	gtk_container_add(GTK_CONTAINER(hbox), applet->lb_last);

	applet->lb_lasttime = gtk_label_new("");
	gtk_container_add(GTK_CONTAINER(hbox), applet->lb_lasttime);

	applet->bu_clear = gtk_button_new_with_label("continue");
	gtk_container_add(GTK_CONTAINER(hbox), applet->bu_clear);
	gtk_widget_set_sensitive(applet->bu_clear, FALSE);

	gtk_container_add(GTK_CONTAINER(dialog_vbox), algn);
	g_signal_connect_after(G_OBJECT(applet->bu_clear), "clicked", G_CALLBACK(bu_clear_clicked), applet);

	gconf_client_notify(applet->gcc, GCONF_PATH_LASTERROR);
	gconf_client_notify(applet->gcc, GCONF_PATH_LASTERRORTIME);

	gtk_widget_show_all(GTK_WIDGET(applet->dialog));
}

osso_return_t save_state(osso_context_t * osso, gpointer data)
{
	(void)osso;
	(void)data;
	return OSSO_OK;
}

static void ui_destroy(CpApplet *applet)
{
	gtk_widget_destroy(GTK_WIDGET(applet->dialog));
	gconf_client_notify_remove(applet->gcc, applet->gc_notify_id_lasterror);
	gconf_client_notify_remove(applet->gcc, applet->gc_notify_id_lasterrortime);
}

