/*
 * booster_maemomm.cc (c) Openismus Gmbh 2007
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#include "booster_maemomm.h"
#include "config.h"
#include <hildonmm/init.h>
#include <hildon-fmmm.h>
#include <libosso.h>
#include <iostream>

#include <maemo-launcher/booster_api.h>

static void debug(const gchar* message)
{
#ifdef DEBUG
	std::cout << message << std::endl;
#endif
}
	

static booster_state_t
booster_maemomm_preinit(int *argc, char ***argv)
{
	debug("booster_maemomm_preinit");
#ifdef DEBUG
	Glib::Timer timer;
#endif
  Hildon::init();
  Hildon::fm_init();
#ifdef DEBUG
	long unsigned int elapsed;
	timer.elapsed(elapsed);
	std::cout << "init took " << elapsed << " microseconds" << std::endl;
#endif
	
	// Return 0 state
	return 0;
}

static void
booster_maemomm_init(const char *progfilename, const booster_state_t state)
{
	
}

static void
booster_maemomm_reload(booster_state_t state)
{
	
}


// Note: The name of this structure has to be booster_<booster_name>_api

booster_api_t booster_maemomm_api = {
  0,
  booster_maemomm_preinit,
  booster_maemomm_init,
  booster_maemomm_reload,
};
