#include <stdio.h>
#include <stdlib.h>
#include <SDL/SDL.h>
#include "game.h"

#if HGW_FUNC
#include <hgw/hgw.h>
HgwContext *hgw_context = NULL;
#endif
#include "callbacks.h"

#define     CRD_PILE        0
#define     CRD_FOUNDATION        1
#define     CRD_RESERVE     2
#define     CRD_WASTE           3

void game_loop(void);

CGame Klondike;
SDL_Surface *screen;
bool startdrag = false;

void Initialize(void) {// must be called only once
    SDL_WM_SetCaption("My Card Game", NULL); // Set the window title

    InitDeck(screen);
    Klondike.Initialize(screen);
    color_bg = SDL_MapRGB(screen->format, 0, 128, 64);

    //index 0
    Klondike.CreateRegion(CRD_PILE, CRD_VISIBLE|CRD_3D, 0, 0, CRD_OSYMBOL, 35, 10, 2, 2);
    //index 1-7
    for(int i=1; i <= 7; i++)
        Klondike.CreateRegion(CRD_FOUNDATION, CRD_VISIBLE|CRD_DODRAG|CRD_DODROP, CRD_DOOPCOLOR|CRD_DOLOWER|CRD_DOLOWERBY1|CRD_DOKING, CRD_DRAGFACEUP, CRD_HSYMBOL, (CARDWIDTH * (i - 1)) + (i * 35), CARDHEIGHT + 40, 0, 16);
    //index 8
    Klondike.CreateRegion(CRD_RESERVE, CRD_VISIBLE|CRD_FACEUP|CRD_DODRAG|CRD_3D, CRD_DOALL, CRD_DRAGTOP, CRD_NSYMBOL, CARDWIDTH + 65, 10, 0, 0);
    //index 9-12
    for(int i=4; i <= 7; i++)
        Klondike.CreateRegion(CRD_WASTE, CRD_VISIBLE|CRD_3D|CRD_DODRAG|CRD_DODROP, CRD_DOSINGLE|CRD_DOHIGHER|CRD_DOHIGHERBY1|CRD_DOACE|CRD_DOSUIT, CRD_DRAGTOP, CRD_HSYMBOL, (CARDWIDTH * (i - 1)) + (i * 35), 10, 0, 0);
}

void NewGame() {
    //Reset pile symbol
    Klondike[0].SetSymbol(CRD_OSYMBOL);

    //Empty the card regions from the previous game
    Klondike.EmptyStacks();

    //create then shuffle the deck
    Klondike[0].NewDeck();

    //deal
    for(int i=1; i <= 7; i++)
        Klondike[i].Push(Klondike[0].Pop(i));

    //initialize all card coordinates
    Klondike.InitAllCoords(true);

    //set initial faced up cards in foundations
    for(int i=1; i <= 7; i++)
        Klondike[i].SetCardFaceUp(true, Klondike[i].Size() - 1);
}

void HandleMouseDownEvent(SDL_Event &event)
{
    CCardRegion *srcReg;

    if(event.button.button == SDL_BUTTON_LEFT)
    {
        srcReg = Klondike.OnMouseDown(event.button.x, event.button.y);
        if(srcReg == NULL) return;

        //clicked on the top of the foundations
        if((srcReg->Id == CRD_FOUNDATION) && srcReg->PtOnTop(event.button.x, event.button.y))
        {
            srcReg->SetCardFaceUp(true, srcReg->Size() - 1);
        }

        //clicked on the foundations, reserve, wastes for dragging
        if(((srcReg->Id == CRD_FOUNDATION) || (srcReg->Id == CRD_RESERVE) ||
            (srcReg->Id == CRD_WASTE)) &&
            Klondike.InitDrag(NULL, event.button.x, event.button.y, srcReg))
        {
            startdrag = true;
            SDL_WM_GrabInput(SDL_GRAB_ON);
        }

        //clicked on the pile
        if(srcReg->Id == CRD_PILE)
        {
            CCardStack *cs = new CCardStack;
            if(srcReg->Empty() && !Klondike[8].Empty()) //Bring back the cards
            {
                *cs = Klondike[8].Pop(Klondike[8].Size());
                cs->SetCardsFaceUp(false);
                Klondike.InitDrag(cs, -1, -1, NULL);
                Klondike.DoDrop(&Klondike[0]);
                Klondike[0].Reverse();
                Klondike[0].InitCardCoords();
            }

            else if(!srcReg->Empty() && (!Klondike[8].Empty() ||
                                         Klondike[8].Empty()))
            {
                *cs = Klondike[0].Pop(1);
                cs->SetCardsFaceUp(true);
                Klondike.InitDrag(cs, -1, -1, NULL);
                Klondike.DoDrop(&Klondike[8]);
            }
            delete cs;
        }
    }

    //substitute right-click for double-click event
    if(event.button.button == SDL_BUTTON_RIGHT)
    {
        srcReg = Klondike.OnMouseDown(event.button.x, event.button.y);
        if(srcReg == NULL) return;
        CCardRegion *cr;
        CCard card =  srcReg->GetCard(srcReg->Size()-1);

        //clicked on the top of the foundations
        if (((srcReg->Id == CRD_FOUNDATION) || (srcReg->Id == CRD_RESERVE)) &&
             card.FaceUp() && srcReg->PtOnTop(event.button.x, event.button.y))
        {
            if(cr = Klondike.FindDropRegion(CRD_WASTE, card))
            {
                CCardStack *cs = new CCardStack;
                *cs = srcReg->Pop(1);
                Klondike.InitDrag(cs, -1, -1, NULL);
                Klondike.DoDrop(cr);
                delete cs;
            }
        }
    }
}

void HandleMouseMoveEvent(SDL_Event &event)
{
    if(event.motion.state == SDL_BUTTON(1) && startdrag)
        Klondike.DoDrag(event.motion.x, event.motion.y);
}

void HandleMouseUpEvent(SDL_Event &event)
{
    if(startdrag)
    {
        startdrag = false;
        Klondike.DoDrop();
        SDL_WM_GrabInput(SDL_GRAB_OFF);
    }
    if(Klondike[0].Empty() && Klondike[8].Empty())
    {
        Klondike[0].SetSymbol(1);
        Klondike.DrawStaticScene();
    }
    //victory
    if ((Klondike[9].Size() == 13) && (Klondike[10].Size() == 13) &&\
        (Klondike[11].Size() == 13) && (Klondike[12].Size() == 13))
    {
        AnimateCards();
        NewGame();
        Klondike.DrawStaticScene();
    }
}

/**
 * Game main loop
 */
void game_loop(void) {
    SDL_Event event;
    int done = 0;
    int step = 0;

    HgwError err;
    HgwMessage msg;
    HgwMessageFlags flags;

    Klondike.DrawStaticScene();

    while (!done) {
        err = hgw_msg_check_incoming(hgw_context, &msg, flags);
        if (err == HGW_ERR_COMMUNICATION) {
        }

        if (SDL_PollEvent(&event)) switch (event.type) {

            case SDL_QUIT:
                done = 1;
                quit_callback(0);
                break;

            case SDL_KEYDOWN:
                switch (event.key.keysym.sym) {
                    case SDLK_ESCAPE:
                        //done = 1;
                        //quit_callback(0);
                        //break;

                    case SDLK_F4:
                    case SDLK_F5:
                    case SDLK_F6:
                        done = 1;
                        exit_callback(0);
                        break;
                }
                break;

            case SDL_MOUSEBUTTONDOWN:
                step = 1;
                HandleMouseDownEvent(event);
                break;

            case SDL_MOUSEMOTION:
                step--;
                if (!step) {
                    step = 6;
                    HandleMouseMoveEvent(event);
                }
                break;

            case SDL_MOUSEBUTTONUP:
                HandleMouseUpEvent(event);
                SDL_PumpEvents();
                break;
        }
    }

}


int main(int argc, char *argv[]) {
    FILE *han;
    unsigned char mask = 0;
    int i, j, l;

#if HGW_FUNC
    hgw_context = hgw_context_compat_init(argc, argv);
    if (!hgw_context) {
        fprintf(stderr, "Cannot init hildon-games-wrapper!\n");
        return 0;
    } else {
        printf("hildon-games-wrapper initialized.");
    }
    hgw_compat_set_cb_exit(hgw_context, exit_callback);
    hgw_compat_set_cb_quit(hgw_context, quit_callback);
    hgw_compat_set_cb_flush(hgw_context, flush_callback);

    if (!hgw_context_compat_check(hgw_context)) return 0;

    /* hildon-games-wrapper part */
    //hgw_context->smain(hgw_context, 0);
    //hgw_context_compat_destroy_deinit(hgw_context);
    usleep(100);
#endif

    // Initialize SDL
    if( SDL_Init(SDL_INIT_VIDEO) < 0 ) {
        printf("Unable to initialize SDL: %s\n", SDL_GetError());
        exit(1);
    }
    atexit(SDL_Quit);

    // Initialize video
    screen = SDL_SetVideoMode(800, 480, 16,
                              SDL_HWSURFACE | SDL_DOUBLEBUF | SDL_FULLSCREEN);

    if (screen == NULL) {
        printf("Unable to set 800x480 video: %s\n", SDL_GetError());
        exit(1);
    }

#if HGW_FUNC
    SDL_SetCursor(SDL_CreateCursor(&mask, &mask, 8, 1, 0, 0));
#endif

    // Initialize game
    Initialize();
    han = fopen("/tmp/.maemodrac-save", "rb");

    if (!han) {
        NewGame();
    } else {
        // Reload last game state
        Klondike.EmptyStacks();
        for (i = 0; i < 13; i++) {
            l = fgetc(han);
            Klondike[i].SetSize(l);
            for (j = 0; j < l; j++) {
                Klondike[i].SetCardIdx(j, fgetc(han));
                Klondike[i].SetCardFaceUp(fgetc(han), j);
            }
        }
        Klondike.InitAllCoords(false);
        fclose(han);
    }

    // Main loop
    game_loop();

#if HGW_FUNC
    //hgw_context->deinit(hgw_context);
    hgw_context_compat_destroy_deinit(hgw_context);
#endif
    return 0;
}
