#!/usr/bin/env python
# -*- coding: UTF8 -*-

import pygtk
import gtk
import gtk.gdk
import hildon
import osso
import os
import string

from molmass import MassCalc, SanityError

osso_c = osso.Context("maemo_periodic", "1.1", False)

distro = 'chinook'

#grupos clasicos
c1=[3,11,19,37,55,87] #Alcalinos
c2=[4,12,20,38,56,88] #Alcalino-terreos
c3=[9,17,35,53,85] #Halogenos
c4=[2,10,18,36,54,86] #Gases nobles
c5=[5,14,32,33,51,52,84] #Metaloides
c6=[1,6,7,8,15,16,34] #No metales
c7=[13,31,49,50,81,82,83] #Otros metales
c8=range(57,72) #Lantanidos
c9=range(89,104) #Actinidos




#grupos de elementos
g1=[1,3,11,19,37,55,87,29,47,79,111,65,97]
g2=[4,12,20,38,56,88,30,48,80,66,98]
g3=[5,13,31,49,81,67,99,21,39,57,89]
g4=[6,14,32,50,82,68,100,22,40,72,104,58,90]
g5=[7,15,33,51,83,69,101,23,41,73,105,59,91]
g6=[8,16,34,52,84,70,102,24,42,74,106,60,92]
g7=[9,17,35,53,85,71,103,25,43,75,107,61,93]


#Valores por defecto variables de referencia
global tref
tref=298.0


from listas import *


def elige_color(tipo,num):

	if tipo==1: #Por grupos
		if num in g1: return 'cyan'
		elif num in g2: return "#77B577"
		elif num in g3: return 'green'
		elif num in g4: return 'magenta'
		elif num in g5: return 'red'
		elif num in g6: return 'yellow'
		elif num in g7: return "#D0BB87"
		return 'grey'
	elif tipo==2: #Clasico
		if num in c1: return "#FEFE00"
		elif num in c2: return "#69DEFF"
		elif num in c3: return "#25CF25"
		elif num in c4: return "#FF4FA1"
		elif num in c5: return "#DBA620"
		elif num in c6: return "#D0BB87"
		elif num in c7: return "#77B577"
		elif num in c8 or num in c9: return "#1E90FF"
		else: return "#00FF00"
	elif tipo==3: #Estado fisico respecto a Temp.ref.
		try:
			vapor=float(vap[num])
		except:
			try:
				aux=vap[num].split()
				vapor=float(aux[0])
			except:
				vapor=-1
		try:
			fusion=float(fus[num])
		except:
			try:
				aux=fus[num].split()
				fusion=float(aux[0])
			except:
				fusion=-1
			
		if tref<fusion: return "#D0BB87"
		elif tref<vapor: return 'cyan'
		elif (fusion>0 and vapor>0): return 'grey'
		else: return 'magenta'
			
	else: return 'grey'




class MainWindow(hildon.Program):
	

	def __init__(self):
		hildon.Program.__init__(self)
        
		self.window = hildon.Window()
		self.window.set_default_size(800, 480)
		self.window.set_title('Periodic Table')
		self.window.connect("destroy", gtk.main_quit)

		self.window.connect("key-press-event", self.on_key_press)
		self.window.connect("window-state-event", self.on_window_state_change)
		self.window_in_fullscreen = False 

		self.add_window(self.window)
 
## Make menu       
		self.menubar1 = gtk.Menu()
		for child in self.menubar1.get_children():
			child.reparent(menu)
		self.window.set_menu(self.menubar1)
		self.window.show_all()
		self.menubar1.show()

		self.exit = gtk.MenuItem("Exit")
		self.exit.set_size_request(-1, 45)
		self.exit.show()
		self.exit.connect("activate", gtk.main_quit)

#Submenu View
		self.m_view=gtk.Menu()
		self.m_view.show()
		self.ver=gtk.MenuItem("View")
		self.ver.set_size_request(-1, 45)
		self.ver.show()
		self.ver.set_submenu(self.m_view)
		
		self.sincol=gtk.MenuItem("Colorless")
		self.sincol.set_size_request(-1, 45)
		self.sincol.show()
		self.sincol.connect("activate",self.on_view_cless)

		self.grupo=gtk.MenuItem("Groups")
		self.grupo.set_size_request(-1, 45)
		self.grupo.show()
		self.grupo.connect("activate",self.on_view_group)

		self.clasic=gtk.MenuItem("Classic")
		self.clasic.set_size_request(-1, 45)
		self.clasic.show()
		self.clasic.connect("activate",self.on_view_classic)

		self.fisest=gtk.MenuItem("Phys.State")
		self.fisest.set_size_request(-1, 45)
		self.fisest.show()
		self.fisest.connect("activate",self.on_view_fisest)

		self.m_view.append(self.sincol)
		self.m_view.append(self.grupo)
		self.m_view.append(self.clasic)
		self.m_view.append(self.fisest)

#Submenu Options

		self.options=gtk.MenuItem("Options")
		self.options.set_size_request(-1, 45)
		self.options.show()
		self.options.connect("activate", self.on_options)

#Submenu Grafics

		self.grafics=gtk.MenuItem("Graphics")
		self.grafics.set_size_request(-1, 45)
		self.grafics.show()
		self.grafics.connect("activate", self.on_grafics)
		
#Submenu Calc

		self.calc=gtk.MenuItem("Calc")
		self.calc.set_size_request(-1, 45)
		self.calc.show()
		self.calc.connect("activate", self.on_calc)

#Submenu Web
		self.m_web=gtk.Menu()
		self.m_web.show()
		self.web=gtk.MenuItem("Web")
		self.web.set_size_request(-1, 45)
		self.web.show()
		self.web.set_submenu(self.m_web)

		self.conect=gtk.MenuItem("Connect to ...")
		self.conect.set_size_request(-1, 45)
		self.conect.show()
		self.conect.connect("activate",self.on_web_conect)

		self.query=gtk.MenuItem("Query...")
		self.query.set_size_request(-1, 45)
		self.query.show()
		self.query.connect("activate", self.on_web_query)

		self.m_web.append(self.conect)
		self.m_web.append(self.query)

#Submenu about

		self.m_about=gtk.Menu()
		self.m_about.show()
		self.about=gtk.MenuItem("About")
		self.about.set_size_request(-1, 45)
		self.about.show()
		self.about.set_submenu(self.m_about)

		self.refs=gtk.MenuItem("References")
		self.refs.set_size_request(-1, 45)
		self.refs.show()
		self.refs.connect("activate",self.on_about_refs)

		self.credits=gtk.MenuItem("Credits")
		self.credits.set_size_request(-1, 45)
		self.credits.show()
		self.credits.connect("activate",self.on_about_credits)

		self.m_about.append(self.refs)
		self.m_about.append(self.credits)
		

#Empaquetar elementos del menu
		
		self.menubar1.append(self.options)
		self.menubar1.append(self.ver)
		self.menubar1.append(self.grafics)
		self.menubar1.append(self.calc)
		self.menubar1.append(self.web)
		self.menubar1.append(self.about)
		self.menubar1.append(self.exit)
		

## Make table

		self.table1 = gtk.Table()
		self.table1.show()
		self.table1.set_row_spacings(0)
		self.table1.set_col_spacings(0)



		boton=['']
		global caja
		caja=['']
		for i in range(1,len(nom)):
			if distro == 'chinook':
				pass
			else:
				self.alignment1 = gtk.Alignment(0.5, 0.5, 1, 1)
				self.alignment1.show()

				self.hbuttonbox1 = gtk.HButtonBox()
				self.hbuttonbox1.set_size_request(37, 20)
				self.hbuttonbox1.show()
				self.hbuttonbox1.set_spacing(0)
				self.hbuttonbox1.set_layout(gtk.BUTTONBOX_EDGE)

			self.button1 = gtk.Button()
			boton.append(self.button1)

			boton[i].set_size_request(38, 20)
			boton[i].set_border_width(0)
			boton[i].connect("clicked", self.on_click)

			self.eventbox=gtk.EventBox()
			self.eventbox.set_size_request(38, 20)
			caja.append(self.eventbox)
			boton[i].add(self.eventbox)
			self.eventbox.show()
			self.label1 = gtk.Label()
			self.label1.set_markup("<small>"+sim[i]+"</small>")
			self.eventbox.add(self.label1)
			self.label1.show()
			color=elige_color(2,i)
			self.eventbox.modify_bg(gtk.STATE_NORMAL,self.eventbox.get_colormap().alloc_color(color))
                       

			boton[i].set_name(sim[i])
			boton[i].show()
			if distro == 'chinook':
				pass
			else:
				self.hbuttonbox1.pack_start(boton[i], False, False, 0)
				self.alignment1.add(self.hbuttonbox1)

			if i==1:
				left=0
				top=0
			elif i==2:
				left=17
				top=0
			elif i in range(3,5):
				left=i-3
				top=1
			elif i in range(5,11):
				left=i+7
				top=1
			elif i in range(11,13):
				left=i-11
				top=2
			elif i in range(13,19):
				left=i-1
				top=2
			elif i in range(19,37):
				left=i-19
				top=3
			elif i in range(37,55):
				left=i-37
				top=4
			elif i in range(55,57):
				left=i-55
				top=5
			elif i in range(72,87):
				left=i-69
				top=5
			elif i in range(87,89):
				left=i-87
				top=6
			elif i in range(104,112):
				left=i-101
				top=6
			elif i in range(57,72):
				left=i-55
				top=7
			elif i in range(89,104):
				left=i-87
				top=8
			
			

			right=left+1
			bottom=top+1
			if distro == 'chinook':
				self.table1.attach(boton[i], left, right, top, bottom, gtk.EXPAND|gtk.FILL, gtk.EXPAND|gtk.FILL, 0, 0)
			else:
				self.table1.attach(self.alignment1, left, right, top, bottom, gtk.EXPAND|gtk.FILL, gtk.EXPAND|gtk.FILL, 0, 0)

## add table to main window

		self.window.add(self.table1)

## Functions for call elements window

	def on_click(self, widget):
		global element
		element = widget.get_name()
		MyDialog()



## Functions for fullscreen
	def on_window_state_change(self, widget, event, *args):           
		if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
			self.window_in_fullscreen = True
		else:
			self.window_in_fullscreen = False

	def on_key_press(self, widget, event, *args):            
		if event.keyval == gtk.keysyms.F6:
			if self.window_in_fullscreen:
				self.window.unfullscreen ()
			else:
				self.window.fullscreen ()

## Funciones de los menus

	def on_about_credits(self, widget):
		AboutDialog()

	def on_view_cless(self, widget):
		for i in range(1,len(caja)):
			caja[i].modify_bg(gtk.STATE_NORMAL,caja[i].get_colormap().alloc_color("grey"))
			caja[i].show()
			

	def on_view_group(self, widget):
		for i in range(1,len(caja)):
			color=elige_color(1,i)
			caja[i].modify_bg(gtk.STATE_NORMAL,caja[i].get_colormap().alloc_color(color))
			caja[i].show()

	def on_view_classic(self, widget):
		for i in range(1,len(caja)):
			color=elige_color(2,i)
			caja[i].modify_bg(gtk.STATE_NORMAL,caja[i].get_colormap().alloc_color(color))
			caja[i].show()

	def on_view_fisest(self,widget):
	
		for i in range(1,len(caja)):
			color=elige_color(3,i)
			caja[i].modify_bg(gtk.STATE_NORMAL,caja[i].get_colormap().alloc_color(color))
			caja[i].show()
	

	def on_options(self,widget):
		Opciones()

	def on_grafics(self,widget):
		GraficProps()

	def on_calc(self,widget):
		MassMolecular()

	def on_web_conect(self,widget):
		WebConect()

	def on_web_query(self,widget):
		WebQuery()

	def on_about_refs(self,widget):
		AboutRefs()


## Run graphical interface
	def run(self):
		self.window.show_all()
		gtk.main()

## About Dialog
class AboutDialog:
	def __init__(self):

		dialog = gtk.AboutDialog()
		dialog.set_name("Maemo Periodic")
		dialog.set_version("1.0")
		dialog.set_copyright("Copyleft © 2006")
		dialog.set_website("https://garage.maemo.org/projects/maemo-periodic/")
		dialog.set_authors(["Luis Lorenzo Paris <llorenzo@gmail.com>", "Daniel Martín Yerga <dyerga@gmail.com>","","Module molmass written for Patrick Thomson <patrick.thomson@gmail.com>"])
		dialog.set_artists(["Logo and icon by Daniel Martín Yerga <dyerga@gmail.com>."])
 		logo = gtk.gdk.pixbuf_new_from_file("/usr/share/maemo-periodic/pixmaps/about.png")
		dialog.set_logo(logo)
		dialog.set_license("This program is released under the GNU General Public License.\nPlease visit http://www.gnu.org/copyleft/gpl.html for details.")
		dialog.run()
		dialog.destroy()

## Window for the elements' properties

class MyDialog(MainWindow):

#El titulo de mayor longitud tiene 25 caracteres; si se annade una propiedad ojo con esto.
#En la ventana caben 54 caracteres

	def __init__(MainWindow):
		def scroll_to(x=0, y=0):
			v = swin.get_vadjustment()
			child_height = swin.child.child.size_request()[1]
			new_adj = gtk.Adjustment(y, 0, child_height)
			swin.set_vadjustment(new_adj)

		def scroll_by(dx=0, dy=0):
			v = swin.get_vadjustment()
			new_y = min(v.upper, v.value + dy)
#			print v.upper, v.value
			scroll_to(0, new_y)
#			print new_y

# Los valores de 100 y -100 son los 'pixels' que avanza el scroll

		def on_key_press(widget, event, *args):            
			if event.keyval == gtk.keysyms.Down:
				scroll_by(0, 100)
			elif event.keyval == gtk.keysyms.Up:
				scroll_by(0, -100)
			elif event.keyval == gtk.keysyms.F6:
				if win.win_in_fullscreen:
					win.unfullscreen ()
				else:
					win.fullscreen ()
    
		def on_window_state_change(widget, event, *args):           
			if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
				win.win_in_fullscreen = True
			else:
				win.win_in_fullscreen = False


		win = hildon.Window()
		win.connect('destroy', gtk.Widget.destroy)
		win.connect("key-press-event", on_key_press)
		win.connect("window-state-event", on_window_state_change)
		win.win_in_fullscreen = False 
		nelem=sim.index(element)
		win.set_title(nom[nelem])

		notebook = gtk.Notebook()
		notebook.set_tab_pos(gtk.POS_BOTTOM)
		notebook.set_scrollable(False)
		notebook.show()

		swin = gtk.ScrolledWindow()
		if distro == 'chinook':
			hildon.hildon_helper_set_thumb_scrollbar(swin, True)
		swin.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
#		win.add(swin)
		swin.show()

		#Para poder alinear se necesita fuente monospace
		etiqueta='<tt>'


		for i in range(len(titulo)):
		
			tit=titulo[i]
		
			if props[i][nelem] in [' ','-'] or len(props[i][nelem])<1:
		
				etiqueta+="<b><u>%25s:</u></b> Na\n" % tit	
			else:
		
				if corresp[i]>=0: unids=units[corresp[i]]
				else:	unids=''
				#si tiene unidades no sera muy largo: no se considea sumar len(unids)+1
				if len(props[i][nelem])<23: etiqueta+="<b><u>%25s:</u></b> %s %s\n" % (tit,props[i][nelem],unids)
				else:
					trozo=[]
					resto=props[i][nelem]
					corte=22
					longitud=len(resto)-resto.count('>')*5.5
				
					while longitud>22:
						while not resto[corte]==' ': corte-=1
						corte+=1
						trozo.append(resto[:corte])
						resto=resto[corte:]
						longitud=len(resto)-resto.count('>')*5.5
						corte=22
					trozo.append(resto)
					etiqueta+="<b><u>%25s:</u></b> %s\n" % (tit,trozo[0])
					
					for i in range(1,len(trozo)): etiqueta+=' '*26+trozo[i]+'\n'

					#En este caso no hara falta poner unidades
					#etiqueta+=' '*28+trozo[-1]+unids+'\n'
				
			
		etiqueta+='</tt>'
			
		
		label = gtk.Label(etiqueta)
		label.set_use_markup(True)
		label.set_line_wrap(False)
		swin.add_with_viewport(label)
		#Parece que es la justificacion por defecto pero por si acaso...
		label.set_justify(gtk.JUSTIFY_LEFT)
		label.show()

		label54 = gtk.Label("Properties")
		label54.set_padding(0, 0)
		label54.show()

		scrolledwindow2 = gtk.ScrolledWindow()
		scrolledwindow2.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
		scrolledwindow2.show()
		scrolledwindow2.set_shadow_type(gtk.SHADOW_IN)

		isot_div = isot[int(num[nelem])].split(",")
		etiqueta1='<tt>'
		for i in range(len(isot_div)):
			etiqueta01=str(isot_div[i])
			etiqueta1+= "\n" +etiqueta01
		
		etiqueta1+='</tt>'
		label2 = gtk.Label(etiqueta1)
		label2.set_use_markup(True)
		label2.set_line_wrap(False)
		scrolledwindow2.add_with_viewport(label2)
		label2.set_justify(gtk.JUSTIFY_LEFT)
		label2.show()


		label55 = gtk.Label("Natural Isotopes")
		label55.set_padding(0, 0)
		label55.show()

		notebook.append_page(swin, label54)

		notebook.append_page(scrolledwindow2, label55)

		win.add(notebook)
		win.show()
		

class MassMolecular(MainWindow):
	def __init__(MainWindow):

		def on_calcular_clicked(widget):
			try:

				calculator = MassCalc()
				formula = entry1.get_text()
				result = calculator.compute(formula)
				calculator.setaccurate(False)
				start, end = buffer1.get_bounds()
				buffer1.delete(start, end)
				buffer1.insert(start, str(result)+" amu")
				textview1.set_buffer(buffer1)
				textview1.show()

			except SanityError, reason:

				start, end = buffer1.get_bounds()
				buffer1.delete(start, end)
				buffer1.insert(start, "formula failed: "+str(reason))
				textview1.set_buffer(buffer1)
				textview1.show()

		def on_cerrar_clicked(widget):
			dlg.destroy()

		dlg = gtk.Dialog(title='Calculate Molecular Mass', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER)
		dlg.set_border_width(6)
		dlg.set_default_size(560, 200)

		vbox1 = gtk.VBox(False, 8)
		vbox1.set_border_width(4)
		label1 = gtk.Label("Write a formula: ")
		vbox1.pack_start(label1, True, True, 0)

		hbox = gtk.HBox(False, 8)
		vbox1.pack_start(hbox)

		entry1 = gtk.Entry()
		entry1.set_text("")
		entry1.set_editable(True)
		entry1.set_visibility(True)
		vbox1.set_spacing(2)
		hbox.pack_start(entry1, True, True, 0)

		vbox1.pack_start(gtk.HSeparator(), True, True, 0)

		label2 = gtk.Label("Molecular mass is:")
		vbox1.pack_start(label2, True, True, 0)

		hbox = gtk.HBox(False, 8)
		vbox1.pack_start(hbox, True, True, 0)
		vbox2 = gtk.VBox()

		textview1 = gtk.TextView()
		textview1.set_wrap_mode(gtk.WRAP_NONE)
		textview1.set_cursor_visible(False)
		textview1.set_editable(False)
		textview1.set_justification(gtk.JUSTIFY_CENTER)
		buffer1=gtk.TextBuffer()
		textview1.set_buffer(buffer1)

		vbox2.pack_start(textview1, True, True, 0)
		vbox1.pack_start(vbox2, True, True, 0)

		hbuttonbox1 = gtk.HButtonBox()
		hbuttonbox1.show()
		hbuttonbox1.set_spacing(2)
		hbuttonbox1.set_border_width(2)
		hbuttonbox1.set_layout(gtk.BUTTONBOX_END)

		button1 = gtk.Button(label="Calculate")
		button1.show()
		button1.connect("clicked", on_calcular_clicked)
		hbuttonbox1.pack_start(button1)

		button2 = gtk.Button(label="Close")
		button2.show()
		button2.connect("clicked", on_cerrar_clicked)
		hbuttonbox1.pack_start(button2)

		dlg.action_area.pack_start(hbuttonbox1, False, False, 8)
		dlg.vbox.pack_start(vbox1, True, True, 8)
		
		dlg.show_all()

class GraficProps(MainWindow):
	def __init__(MainWindow):

		def save_png(widget):
			file_dialog = hildon.FileChooserDialog(wgraf, gtk.FILE_CHOOSER_ACTION_SAVE)
			file_dialog.set_default_response(gtk.RESPONSE_OK)

			response = file_dialog.run()
			if response == gtk.RESPONSE_OK:
				x, y, w, h = dra1.get_allocation()
				pix_buffer = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, False, 8, w, h)
				pix_buffer.get_from_drawable(pixmap, pixmap.get_colormap(), 0, 0, 0, 0, w, h)
				pix_buffer.save(file_dialog.get_filename(), "png")
			file_dialog.destroy()

				
		def crea_pixmap(widget):
			x, y, width, height = wgraf.get_allocation()

			pixmap = gtk.gdk.Pixmap(dra1.window, width, height)
			pixmap.draw_rectangle(dra1.get_style().white_gc,True, 0, 0, width, height)
			return pixmap

		def refoco(widget,event):
			 x , y, width, height = event.area
			 widget.window.draw_drawable(widget.get_style().fg_gc[gtk.STATE_NORMAL],pixmap, x, y, x, y, width, height)
			

		def ver_activo(combo):
			model = combo.get_model()
			active = combo.get_active()
			if active < 0:
				return None
			return model[active][0]


		def on_dibujar_clicked(widget):
			ox=100
			fx=650
			oy=300
			fy=50
			
			x, y, width, height = wgraf.get_allocation()
			pixmap.draw_rectangle(dra1.get_style().white_gc,True, 0, 0, width, height)			
			
			gc.set_foreground(blanco)
			gc.set_background(blanco)
			dibujo.draw_rectangle(gc,True,0,0,700,350)
			
			gc.line_width=1
			gc.line_style=0


			axe=ver_activo(comboprop)
			nprop=titulo.index(axe)
			axe='Graph '+axe
			wgraf.set_title(axe)
			nat_ini=sim.index(ver_activo(combode))
			nat_fin=sim.index(ver_activo(comboa))
			gc.set_foreground(negro)
			txto.set_text(titulo[nprop])
		
			pixmap.draw_layout(gc,250,15,txto)
			gc.set_foreground(gris)
			gc.set_background(blanco)
			if nat_ini>nat_fin:
				aux=nat_fin
				nat_fin=nat_ini
				nat_ini=aux
			valores=[]
			maxy=-1e20
			miny=1e20
			for i in range(nat_ini, nat_fin+1):
				try:
					aux=float(props[nprop][i])
					valores.append(aux)
					if aux>maxy: maxy=aux
					if aux<miny: miny=aux
						
				
				except:
					try:
						aux=props[nprop][i].split()
						valores.append(float(aux[0]))
						if float(aux[0])>maxy: maxy=float(aux[0])
						if float(aux[0])<miny: miny=float(aux[0])
				
					except:
						valores.append('NA')
		
			if maxy==miny:
				if maxy>0 :maxy=1.1*maxy
				else: maxy=0.9
				if miny>0 : miny=0.9*miny
				else: miny=1.1*miny
			
			nat=nat_fin-nat_ini
			sclx=(fx-ox)/nat
		
			scly=(oy-fy)/(maxy-miny)
			
				
			dptos=[]
			gc.set_foreground(tinta)
			gc.line_width=3
			for i in range(len(valores)):
				try:
					axe=(ox+i*sclx,oy-(valores[i]-miny)*scly)
				
				except:
					axe=(ox+i*sclx,'NA')
					
				dptos.append(axe)
		
			ctd0=False
			vale0=True
			vale1=True
			i=1
			x0,y0=dptos[0]
			try:
				y0=int(y0)
			except:
				vale0=False
			
			while i<len(valores):
				x1,y1=dptos[i]
				try:
					y1=int(y1)
					vale1=True
				except:
					vale1=False
				if vale0 and vale1:
				
					pixmap.draw_line(gc,x0,y0,x1,y1)
					ctd0=True
				elif vale0 and not vale1 and not ctd0:
				
					pixmap.draw_rectangle(gc,True,x0-3,y0-3,6,6)
				elif not vale0 and vale1: ctd0=False
				

				vale0=vale1
				x0,y0=x1,y1
				i+=1
			if not vale0 and vale1:
			
				pixmap.draw_rectangle(gc,True,x1-3,y1-3,6,6)
			
				
			if nat>10: numm=10
			else: numm=nat
			y0=oy+10
			y1=oy-10
			gc.set_foreground(gris)
			gc.line_width=1
		
			pixmap.draw_line(gc, ox,oy,fx,oy)
		
			pixmap.draw_line(gc, ox,oy,ox,fy)
			gc.line_style=1
			if corresp[nprop]>=0:
				txto.set_text('['+units[corresp[nprop]]+']')
			
				pixmap.draw_layout(gc,10,10,txto)
			for i in range(numm+1):
				x=sclx*(i*nat/numm)+ox
				txto.set_text(repr(int(nat_ini+i*nat/numm)))
			
				pixmap.draw_line(gc,x,oy,x,fy)
			
				pixmap.draw_layout(gc,x-10, oy+10, txto)
			inc=(maxy-miny)/10
			x0=ox-10
			x1=ox+10
			for i in range(11):
				y=oy-(oy-fy)*(inc*(i)/(maxy-miny))
				aux=inc*i+miny
				axe="%.2e" % aux
				txto.set_text(axe)
			
				pixmap.draw_line(gc,ox,y,fx,y)
			
				pixmap.draw_layout(gc,x0-90,y-15,txto)

			#pintar el pixmap
			x , y, width, height = wgraf.get_allocation()
			dra1.window.draw_drawable(dra1.get_style().fg_gc[gtk.STATE_NORMAL],pixmap, x, y, x, y, width, height)
			
			pass
		
		wgraf = hildon.Window()
		wgraf.connect('destroy', gtk.Widget.destroy)
		wgraf.set_title('Graphics')

		
		vbox1=gtk.VBox(False,3)
	
		dra1=gtk.DrawingArea()
		dra1.show()
		dra1.set_size_request(650,350)

		dra1.connect('expose_event',refoco)

		menubar2 = gtk.Menu()
		for child in menubar2.get_children():
			child.reparent(menu)
		wgraf.set_menu(menubar2)
		menubar2.show()

		save_menu = gtk.MenuItem("Save")
		save_menu.set_size_request(-1, 45)
		save_menu.show()
		save_menu.connect("activate", save_png)
		menubar2.append(save_menu)

		vbox1.pack_start(dra1, True, True,0)
		hbox1=gtk.HBox(False,0)

		comboprop=gtk.combo_box_new_text()
		comboprop.set_size_request(230,30)
		for i in range(len(titulo)):
			if graficable[i]:
				comboprop.append_text(titulo[i])
		comboprop.set_active(0)
		comboprop.show()
		hbox1.pack_start(comboprop, True, True,0)
		label1=gtk.Label("From:")
		label1.set_size_request(80,30)
		label1.show()
		hbox1.pack_start(label1,True,True,0)
		combode=gtk.combo_box_new_text()
		combode.set_size_request(80,30)
		for i in range(1,len(sim)):
			combode.append_text(sim[i])
		combode.set_active(0)
		combode.show()
		hbox1.pack_start(combode,True,True,0)
		label2=gtk.Label("To:")
		label2.set_size_request(45,30)
		label2.show()
		hbox1.pack_start(label2,False,False,0)
		comboa=gtk.combo_box_new_text()
		comboa.set_size_request(80,30)
		for i in range(1,len(sim)):
			comboa.append_text(sim[i])
		comboa.set_active(len(sim)-2)
		comboa.show()
		hbox1.pack_start(comboa,True,True,0)
		boton=gtk.Button(label="Draw")
		boton.set_size_request(80,40)
		boton.show()
		boton.connect("clicked", on_dibujar_clicked)
		hbox1.pack_start(boton,True,True,0)
		#boton salir
		salir=gtk.Button(label="Close")
	
		salir.show()
		salir.connect("clicked", lambda a: wgraf.destroy())
		hbox1.pack_start(salir,True,True,0)

		
		vbox1.pack_start(hbox1,True,True,0)
		wgraf.add(vbox1)
		wgraf.show_all()
		
		txto=dra1.create_pango_layout("")
		dibujo=dra1.window
		dibujo.show()
		gc=dibujo.new_gc()
		
		pixmap=crea_pixmap(dra1)
				
		colormap=gc.get_colormap()
		blanco=colormap.alloc_color('white')
		negro=colormap.alloc_color('black')
		tinta=colormap.alloc_color('brown')
		gris=colormap.alloc_color('grey')
		dra1.show()	


class Opciones(MainWindow):
	def __init__(MainWindow):
		
		def on_cerrar_clicked(widget):
			dlg.destroy()
		def on_aceptar_clicked(widget):
			global tref
			tref=escala.get_value()
			dlg.destroy()
			

		dlg = gtk.Dialog(title='Options', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER)
		dlg.set_border_width(6)
		dlg.set_default_size(560, 200)

		hbox1 = gtk.HBox(False, 8)
		hbox1.set_border_width(4)
		label1 = gtk.Label("Ref. Temp [K]: ")
		hbox1.pack_start(label1, True, True, 0)

		ajuste=gtk.Adjustment(tref,0,6000,2,10,0)
		escala=gtk.HScale(ajuste)
		escala.set_digits(0)
		escala.show()

		hbox1.pack_start(escala, True, True, 0)


		hbuttonbox1 = gtk.HButtonBox()
		hbuttonbox1.show()
		hbuttonbox1.set_spacing(2)
		hbuttonbox1.set_border_width(2)
		hbuttonbox1.set_layout(gtk.BUTTONBOX_END)

		button1 = gtk.Button(label="Set")
		button1.show()
		button1.connect("clicked", on_aceptar_clicked)
		hbuttonbox1.pack_start(button1)

		button2 = gtk.Button(label="Cancel")
		button2.show()
		button2.connect("clicked", on_cerrar_clicked)
		hbuttonbox1.pack_start(button2)

		dlg.action_area.pack_start(hbuttonbox1, False, False, 8)
		dlg.vbox.pack_start(hbox1, True, True, 8)
		
		dlg.show_all()


class WebConect(MainWindow):

	def __init__(MainWindow):
		def on_cerrar_clicked(widget):
			dlg.destroy()
		def on_aceptar_clicked(widget):
			entrada=combo.child.get_text()
			orden=comando+"\'"+entrada+"\'"
			os.system(orden)
			dlg.destroy()


		comando="dbus-send --print-reply --dest=com.nokia.osso_browser /com/nokia/osso_browser/service com.nokia.osso_browser.load_url string:"
	
		dlg = gtk.Dialog(title='Web Connect...', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER)
		dlg.set_border_width(6)
		dlg.set_default_size(560, 200)

		hbox1 = gtk.HBox(False, 8)
		hbox1.set_border_width(4)
		label1 = gtk.Label("URL :  ")
		hbox1.pack_start(label1, True, True, 0)
		combo=gtk.combo_box_entry_new_text()
		combo.append_text('webbook.nist.gov/chemistry/')
		combo.append_text('http://www.iupac.org/')

		hbox1.pack_start(combo, True, True, 0)


		hbuttonbox1 = gtk.HButtonBox()
		hbuttonbox1.show()
		hbuttonbox1.set_spacing(2)
		hbuttonbox1.set_border_width(2)
		hbuttonbox1.set_layout(gtk.BUTTONBOX_END)

		button1 = gtk.Button(label="Go")
		button1.show()
		button1.connect("clicked", on_aceptar_clicked)
		hbuttonbox1.pack_start(button1)

		button2 = gtk.Button(label="Close")
		button2.show()
		button2.connect("clicked", on_cerrar_clicked)
		hbuttonbox1.pack_start(button2)

		dlg.action_area.pack_start(hbuttonbox1, False, False, 8)
		dlg.vbox.pack_start(hbox1, True, True, 8)
		
		dlg.show_all()

class WebQuery(MainWindow):
	def __init__(MainWindow):
		def on_cerrar_clicked(widget):
			dlg.destroy()
		def on_aceptar_clicked(widget):
			entrada=texto.get_text()
			if radio.get_active():
				entrada.replace('(','%28')
				entrada.replace(')','%29')
				entrada='webbook.nist.gov/cgi/cbook.cgi?Formula='+entrada
			else:
				entrada='webbook.nist.gov/cgi/cbook.cgi?Name='+entrada
			orden=comando+"\'"+entrada+"\'"
			os.system(orden)
			
			dlg.destroy()


		
		comando="dbus-send --print-reply --dest=com.nokia.osso_browser /com/nokia/osso_browser/service com.nokia.osso_browser.load_url string:"
	
		dlg = gtk.Dialog(title='Query NIST database', parent=None, flags=gtk.DIALOG_MODAL | gtk.WIN_POS_CENTER)
		dlg.set_border_width(6)
		dlg.set_default_size(560, 200)

		vbox1=gtk.VBox(False,8)
		vbox1.set_border_width(4)
		radio=gtk.RadioButton(None,"Name")
		vbox1.pack_start(radio,True,True,0)
		radio.set_active(True)
		radio.show()
		radio=gtk.RadioButton(radio,"Formula")
		vbox1.pack_start(radio,True,True,0)
		radio.show()

		hbox1 = gtk.HBox(False, 8)
		hbox1.set_border_width(4)
		label1 = gtk.Label("Key :  ")
		hbox1.pack_start(label1, False, False, 1)
		texto=gtk.Entry()
		texto.set_text("")
		texto.set_editable(True)
		texto.set_visibility(True)
		

		hbox1.pack_start(texto, True, True, 0)
		hbox1.show()
		vbox1.pack_start(hbox1,True,True,0)
		vbox1.show()

		hbuttonbox1 = gtk.HButtonBox()
		hbuttonbox1.show()
		hbuttonbox1.set_spacing(2)
		hbuttonbox1.set_border_width(2)
		hbuttonbox1.set_layout(gtk.BUTTONBOX_END)

		button1 = gtk.Button(label="Query")
		button1.show()
		button1.connect("clicked", on_aceptar_clicked)
		hbuttonbox1.pack_start(button1)

		button2 = gtk.Button(label="Close")
		button2.show()
		button2.connect("clicked", on_cerrar_clicked)
		hbuttonbox1.pack_start(button2)

		dlg.action_area.pack_start(hbuttonbox1, False, False, 8)
		dlg.vbox.pack_start(vbox1, True, True, 8)
		
		dlg.show_all()

class AboutRefs(MainWindow):
	def __init__(self):

		def on_cerrar_clicked(widget):
			self.dlg.destroy()

		self.dlg = gtk.Dialog(title='References', parent=None, flags=gtk.WIN_POS_CENTER)
		self.dlg.set_border_width(6)
		self.dlg.set_default_size(400, 200)

		self.hbox1 = gtk.HBox(False, 8)
		self.hbox1.set_border_width(4)

		textview1 = gtk.TextView()
		textview1.connect("event-after", self.event_after)
		
		textview1.set_wrap_mode(gtk.WRAP_NONE)
		textview1.set_cursor_visible(False)
		textview1.set_editable(False)
		textview1.set_justification(gtk.JUSTIFY_CENTER)

		buffer = textview1.get_buffer()

		self.show_url(buffer, 1)

		self.hbox1.pack_start(textview1, True, True, 0)

		hbuttonbox1 = gtk.HButtonBox()
		hbuttonbox1.show()
		hbuttonbox1.set_spacing(2)
		hbuttonbox1.set_border_width(2)
		hbuttonbox1.set_layout(gtk.BUTTONBOX_END)

		button1 = gtk.Button(label="Close", stock=gtk.STOCK_CLOSE)
		button1.show()
		button1.connect("clicked", on_cerrar_clicked)
		hbuttonbox1.pack_start(button1)

		self.dlg.action_area.pack_start(hbuttonbox1, False, False, 8)
		self.dlg.vbox.pack_start(self.hbox1, True, True, 8)
		
		self.dlg.show_all()


	def event_after(self, textview2, event):
		if event.type != gtk.gdk.BUTTON_RELEASE:
			return False
		if event.button != 1:
			return False

		buffer = textview2.get_buffer()

		x, y = textview2.window_to_buffer_coords(gtk.TEXT_WINDOW_WIDGET, int(event.x), int(event.y))
		iter = textview2.get_iter_at_location(x, y)

		self.on_click(textview2, iter)
		return False


	def insert_link(self, buffer, iter, text, url):
		tag = buffer.create_tag(None, foreground="blue")
		tag.set_data("url", url)
		buffer.insert_with_tags(iter, text, tag)


	def show_url(self, buffer, url):
		buffer.set_text("", 0)
		iter = buffer.get_iter_at_offset(0)
		self.insert_link(buffer, iter, "Wikipedia", "http://en.wikipedia.org/wiki/Periodic_Table")
		buffer.insert(iter, "\n")
		self.insert_link(buffer, iter, "Kalzium", "http://edu.kde.org/kalzium/")
		buffer.insert(iter, "\n")
		self.insert_link(buffer, iter, "Gperiodic", "http://gperiodic.seul.org")
		buffer.insert(iter, "\n")
		self.insert_link(buffer, iter, "Webelements", "http://www.webelements.com/")
		buffer.insert(iter, "\n")

	def on_click(self, textview2, iter):
		tags = iter.get_tags()
		for tag in tags:
			url = tag.get_data("url")
		entrada=str(url)
		comando="dbus-send --print-reply --dest=com.nokia.osso_browser /com/nokia/osso_browser/service com.nokia.osso_browser.load_url string:"
		orden=comando+"\'"+entrada+"\'"
		os.system(orden)
		self.dlg.destroy()



## Run app

if __name__ == "__main__":
	app = MainWindow()
	app.run()
