/*
 *  Miaouw - The Miaouw Library for Maemo Development
 *  Copyright (C) 2007 Henrik Hedberg <hhedberg@innologies.fi>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*

Install the libmiaouw-dev package first. Compile this program with

gcc -o miaouwcapturing $(pkg-config --cflags --libs miaouw gtk+-2.0 hildon-libs libosso) miaouwcapturing.c

in Maemo 3.x environment or

gcc -o miaouwcapturing $(pkg-config --cflags --libs miaouw gtk+-2.0 hildon-1 libosso) miaouwcapturing.c

in Maemo 4.x environment.

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>
#include <libosso.h>
#include <stdlib.h>
#if defined HILDON && HILDON == 0
#include <hildon-widgets/hildon-program.h>
#else
#include <hildon/hildon.h>
#endif

#include <miaouw/miaouw.h>

#define ROWS 30
#define COLS 15


static const gchar* gesture_to_string(MiaouwGestureType gesture) {
	switch (gesture) {
		case MIAOUW_GESTURE_FAILED:
			return "failed";
		case MIAOUW_GESTURE_NONE:
			return "none";
		case MIAOUW_GESTURE_LEFT:
			return "left";
		case MIAOUW_GESTURE_RIGHT:
			return "right";
		case MIAOUW_GESTURE_UP:
			return "up";
		case MIAOUW_GESTURE_DOWN:
			return "down";
	}
	
	return "unknown";
}

static gboolean gesture_event(MiaouwGestureEventBox* gesture_event_box, MiaouwGestureEvent* gesture_event, gpointer user_data) {
	GtkLabel* label;
	gchar* text;
	
	label = GTK_LABEL(user_data);
	if (gesture_event->previous_gesture != MIAOUW_GESTURE_NONE) {
		text = g_strdup_printf("Your gesture was: %s, %s",
		 gesture_to_string(gesture_event->previous_gesture), gesture_to_string(gesture_event->gesture));
	} else {
		text = g_strdup_printf("Your gesture was: %s",
		 gesture_to_string(gesture_event->gesture));
	}
	gtk_label_set_text(label, text);
	g_free(text);

	return FALSE;
}

static gboolean gesture_notify(MiaouwGestureEventBox* gesture_event_box, MiaouwGestureEvent* gesture_event, gpointer user_data) {
	GtkLabel* label;
	gchar* text;

	label = GTK_LABEL(user_data);
	text = g_strdup_printf("%s (%d %d => %d %d)\n%s (%d %d => %d %d)",
	 gesture_to_string(gesture_event->gesture),
	 gesture_event->previous_start_x, gesture_event->previous_start_y,
	 gesture_event->x, gesture_event->y,
	 gesture_to_string(gesture_event->previous_gesture),
	 gesture_event->start_x, gesture_event->start_y,
	 gesture_event->previous_start_x, gesture_event->previous_start_y);
	gtk_label_set_text(label, text);
	g_free(text);

	return FALSE;
}


int main(int argc, char** argv) {
	osso_context_t* osso_context;
	HildonProgram* program;
	GtkWidget* window;
	GtkWidget* gesture_event_box;
	GtkWidget* label;

	gtk_init(&argc, &argv);
	osso_context = osso_initialize("miaouwgesturing", "0.0.1", TRUE, NULL);

	program = HILDON_PROGRAM(hildon_program_get_instance());
	g_set_application_name("Miaouw");
	
	/* You can set the window title when creating a MiaouwWindow. */
	window = miaouw_window_new_with_title("Gesturing");
	hildon_program_add_window(program, HILDON_WINDOW(window));
	g_signal_connect(G_OBJECT(window), "destroy", G_CALLBACK(gtk_main_quit), NULL);

	gesture_event_box = miaouw_gesture_event_box_new();
	gtk_container_add(GTK_CONTAINER(window), gesture_event_box);

	label = gtk_label_new("Do gestures!");
	gtk_container_add(GTK_CONTAINER(gesture_event_box), label);

	g_signal_connect(gesture_event_box, "gesture-notify", G_CALLBACK(gesture_notify), label);
	g_signal_connect(gesture_event_box, "gesture-event", G_CALLBACK(gesture_event), label);

	gtk_widget_show_all(window);


	gtk_main();

	return 0;
}
