/*
 *  Miaouw - The Miaouw Library for Maemo Development
 *  Copyright (C) 2008 Henrik Hedberg <hhedberg@innologies.fi>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
 
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <signal.h>

#include <miaouw/miaouw.h>

void crash1(char* p, int i) {
	g_critical("Pointer: %p", p);
	*p = i;
}

void crash2(int i, void* jee) {
	crash1(jee, i);
}

void crash3(void* p, int i) {
	crash2(i, p);
}

int main(int argc, char** argv) {
	miaouw_backtrace_uploader_init(g_find_program_in_path(argv[0]), "Miaouw Crasher", VERSION, "http://miaouw.henrikhedberg.com/test_upload", 1024);

	g_warning("This application will crash...");
	
	crash3(0, 12);

	return 0;
}
