/*
 *  Miaouw - The Miaouw Library for Maemo Development
 *  Copyright (C) 2008 Henrik Hedberg <hhedberg@innologies.fi>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MIAOUW_EVENT_BOX_H
#define MIAOUW_EVENT_BOX_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gtk/gtk.h>

typedef struct _MiaouwEventBox MiaouwEventBox;
typedef struct _MiaouwEventBoxClass MiaouwEventBoxClass;
typedef struct _MiaouwEventBoxPrivate MiaouwEventBoxPrivate;

struct _MiaouwEventBox {
	GtkBin parent;

	/* private */
	MiaouwEventBoxPrivate* priv;
};

struct _MiaouwEventBoxClass {
  GtkBinClass parent;

  /* class members */
};

GType miaouw_event_box_get_type (void);

#define MIAOUW_TYPE_EVENT_BOX (miaouw_event_box_get_type())
#define MIAOUW_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), MIAOUW_TYPE_EVENT_BOX, MiaouwEventBox))
#define MIAOUW_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), MIAOUW_TYPE_EVENT_BOX, MiaouwEventBoxClass))
#define MIAOUW_IS_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), MIAOUW_TYPE_EVENT_BOX))
#define MIAOUW_IS_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), MIAOUW_TYPE_EVENT_BOX))
#define MIAOUW_EVENT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), MIAOUW_TYPE_EVENT_BOX, MiaouwEventBoxClass))

GtkWidget* miaouw_event_box_new();
GtkWidget* miaouw_event_box_new_with_window();

#endif
