/*
 *  Miaouw - The Miaouw Library for Maemo Development
 *  Copyright (C) 2007 Henrik Hedberg <hhedberg@innologies.fi>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef MIAOUW_H
#define MIAOUW_H

#include <libosso.h>
#include <gdk/gdk.h>

typedef struct _MiaouwEventHandlerState MiaouwEventHandlerState;
typedef gboolean (*MiaouwEventHandler)(GdkEvent* event, MiaouwEventHandlerState* state, gpointer user_data);

void miaouw_init(osso_context_t* osso_context);

void miaouw_backtrace_uploader_init(const gchar* application_path, const gchar* application_name,
                                    const gchar* application_version, const gchar* upload_url, const guint max_log_lines);

void miaouw_event_handler_append(MiaouwEventHandler event_handler, gpointer user_data);
void miaouw_event_handler_next(GdkEvent* event, MiaouwEventHandlerState* state);
void miaouw_event_handler_prepend(MiaouwEventHandler event_handler, gpointer user_data);
void miaouw_event_handler_remove(MiaouwEventHandler event_handler, gpointer user_data);

#include <miaouw/miaouwwindow.h>
#include <miaouw/miaouwscrolledwindow.h>
#include <miaouw/miaouwbox.h>
#include <miaouw/miaouwgestureeventbox.h>
#include <miaouw/miaouweventbox.h>

#endif
